/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.helpers;

import com.sos.yade.engine.commons.arguments.YADEArguments;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;

public class YADEParallelExecutorFactory {
    public static ForkJoinPool create(int configuredMaxThreads, int numberOfTasks) {
        int maxThreads = numberOfTasks < configuredMaxThreads ? numberOfTasks : configuredMaxThreads;
        return new ForkJoinPool(maxThreads, new ForkJoinPool.ForkJoinWorkerThreadFactory(){
            private int count = 1;

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                thread.setName("yade-thread-" + this.count++);
                return thread;
            }
        }, null, false);
    }

    public static void shutdown(ForkJoinPool pool) {
        if (pool == null) {
            return;
        }
        pool.shutdown();
        try {
            if (!pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static int getParallelism(YADEArguments args, int sourceFilesSize) {
        if (sourceFilesSize <= 1) {
            return 1;
        }
        return args.isParallelismEnabled() ? (Integer)args.getParallelism().getValue() : 1;
    }
}

