/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.command;

import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import com.sos.commons.util.beans.SOSCommandResult;
import com.sos.commons.util.beans.SOSEnv;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.yade.engine.addons.YADEEngineJumpHostAddon;
import com.sos.yade.engine.commons.YADEProviderFile;
import com.sos.yade.engine.commons.delegators.AYADEProviderDelegator;
import com.sos.yade.engine.commons.delegators.IYADEProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADETargetProviderDelegator;
import com.sos.yade.engine.commons.helpers.YADEProviderDelegatorHelper;
import com.sos.yade.engine.exceptions.YADEEngineCommandException;
import com.sos.yade.engine.exceptions.YADEEngineJumpHostCommandException;
import com.sos.yade.engine.handlers.command.YADEFileCommandVariablesResolver;
import com.sos.yade.engine.handlers.operations.copymove.file.commons.YADETargetProviderFile;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;

public class YADECommandExecutor {
    private static final String AFTER_OPERATION_BUILTIN_FUNCTION_REMOVE_DIRECTORY = "REMOVE_DIRECTORY()";
    private static final boolean THROW_ERROR_ON_STDERR = false;
    private static String AFTER_FILE_ENV_VAR_FILE_TRANSFER_STATUS = "YADE_FILE_TRANSFER_STATUS";
    private static String AFTER_FILE_ENV_VAR_FILE_IS_TRANSFERRED = "YADE_FILE_IS_TRANSFERRED";

    public static void executeBeforeOperation(ISOSLogger logger, AYADEProviderDelegator delegator) throws YADEEngineCommandException {
        YADECommandExecutor.executeBeforeOperation(logger, delegator, null);
    }

    public static void executeBeforeOperation(ISOSLogger logger, AYADEProviderDelegator delegator, YADEEngineJumpHostAddon jumpHostAddon) throws YADEEngineCommandException {
        if (delegator == null || delegator.getArgs().getCommands().getCommandsBeforeOperation().isEmpty()) {
            return;
        }
        SOSArgument<List<String>> arg = delegator.getArgs().getCommands().getCommandsBeforeOperation();
        YADECommandExecutor.logIfMultipleCommands(logger, delegator.getLabel(), arg, delegator.getArgs().getCommands().getCommandDelimiter());
        String argumentName = arg.getName();
        boolean isJumpHostClientCommand = jumpHostAddon != null && jumpHostAddon.isConfiguredOnSource();
        for (String command : (List)arg.getValue()) {
            logger.info("[%s][%s]%s", new Object[]{delegator.getLabel(), argumentName, command});
            SOSCommandResult result = delegator.getProvider().executeCommand(command);
            if (isJumpHostClientCommand) {
                YADECommandExecutor.logCommandResult(logger, "[" + delegator.getLabel() + "][" + argumentName + "]", result);
                try {
                    YADECommandExecutor.checkCommandResult(delegator, argumentName, result);
                    continue;
                }
                catch (YADEEngineCommandException e) {
                    throw new YADEEngineJumpHostCommandException(e);
                }
            }
            YADECommandExecutor.logCommandResult(logger, "[" + delegator.getLabel() + "][" + argumentName + "][" + command + "]", result);
            YADECommandExecutor.checkCommandResult(delegator, argumentName, result);
        }
    }

    public static void executeAfterOperationOnSuccess(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator) throws YADEEngineCommandException {
        SOSArgument<List<String>> arg = sourceDelegator.getArgs().getCommands().getCommandsAfterOperationOnSuccess();
        if (!arg.isEmpty()) {
            YADECommandExecutor.executeAfterOperationCommands(logger, sourceDelegator, arg, null);
        }
        if (targetDelegator != null && !(arg = targetDelegator.getArgs().getCommands().getCommandsAfterOperationOnSuccess()).isEmpty()) {
            YADECommandExecutor.executeAfterOperationCommands(logger, targetDelegator, arg, null);
        }
    }

    public static YADECommandResult executeAfterOperationOnError(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, Throwable exception) {
        YADECommandResult r = YADECommandResult.createInstance();
        SOSArgument<List<String>> arg = sourceDelegator.getArgs().getCommands().getCommandsAfterOperationOnError();
        if (!arg.isEmpty()) {
            try {
                YADECommandExecutor.executeAfterOperationCommands(logger, sourceDelegator, arg, exception);
            }
            catch (YADEEngineCommandException e) {
                r.source = e;
            }
        }
        if (targetDelegator != null && !(arg = targetDelegator.getArgs().getCommands().getCommandsAfterOperationOnError()).isEmpty()) {
            try {
                YADECommandExecutor.executeAfterOperationCommands(logger, targetDelegator, arg, exception);
            }
            catch (YADEEngineCommandException e) {
                r.target = e;
            }
        }
        return r;
    }

    public static YADECommandResult executeAfterOperationFinal(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, Throwable exception) {
        YADECommandResult r = YADECommandResult.createInstance();
        SOSArgument<List<String>> arg = sourceDelegator.getArgs().getCommands().getCommandsAfterOperationFinal();
        if (!arg.isEmpty()) {
            try {
                YADECommandExecutor.executeAfterOperationCommands(logger, sourceDelegator, arg, exception);
            }
            catch (YADEEngineCommandException e) {
                r.source = e;
            }
        }
        if (targetDelegator != null && !(arg = targetDelegator.getArgs().getCommands().getCommandsAfterOperationFinal()).isEmpty()) {
            try {
                YADECommandExecutor.executeAfterOperationCommands(logger, targetDelegator, arg, exception);
            }
            catch (YADEEngineCommandException e) {
                r.target = e;
            }
        }
        return r;
    }

    public static void executeBeforeFile(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, YADEProviderFile sourceFile) throws YADEEngineCommandException {
        YADECommandExecutor.executeBeforeFile(logger, sourceDelegator, null, sourceFile);
    }

    public static void executeBeforeFile(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, YADEProviderFile sourceFile) throws YADEEngineCommandException {
        SOSArgument<List<String>> arg = sourceDelegator.getArgs().getCommands().getCommandsBeforeFile();
        if (!(arg.isEmpty() || sourceFile.isSkipped() && !sourceDelegator.getArgs().getCommands().getCommandsBeforeFileEnableForSkipped().isTrue())) {
            YADECommandExecutor.executeFileCommands(logger, sourceDelegator, sourceDelegator, targetDelegator, arg, sourceFile, null, true);
        }
        if (!(targetDelegator == null || (arg = targetDelegator.getArgs().getCommands().getCommandsBeforeFile()).isEmpty() || sourceFile.isSkipped() && !targetDelegator.getArgs().getCommands().getCommandsBeforeFileEnableForSkipped().isTrue())) {
            YADECommandExecutor.executeFileCommands(logger, targetDelegator, sourceDelegator, targetDelegator, arg, sourceFile, null, false);
        }
    }

    public static void executeAfterFile(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, YADEProviderFile sourceFile) throws YADEEngineCommandException {
        YADECommandExecutor.executeAfterFile(logger, sourceDelegator, null, sourceFile);
    }

    public static void executeAfterFile(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, YADEProviderFile sourceFile) throws YADEEngineCommandException {
        SOSEnv env = null;
        SOSArgument<List<String>> arg = sourceDelegator.getArgs().getCommands().getCommandsAfterFile();
        YADETargetProviderFile targetFile = sourceFile.getTarget();
        if (!arg.isEmpty()) {
            boolean skipped;
            boolean bl = skipped = targetFile == null ? sourceFile.isSkipped() : targetFile.isSkipped();
            if (!skipped || !sourceDelegator.getArgs().getCommands().getCommandsAfterFileDisableForSkipped().isTrue()) {
                env = YADECommandExecutor.createLocalEnvForExecuteAfterFile(sourceFile);
                YADECommandExecutor.executeFileCommands(logger, sourceDelegator, sourceDelegator, targetDelegator, arg, sourceFile, env, true);
            }
        }
        if (!(targetDelegator == null || (arg = targetDelegator.getArgs().getCommands().getCommandsAfterFile()).isEmpty() || targetFile == null || targetFile.isSkipped() && targetDelegator.getArgs().getCommands().getCommandsAfterFileDisableForSkipped().isTrue())) {
            if (env == null) {
                env = YADECommandExecutor.createLocalEnvForExecuteAfterFile(sourceFile);
            }
            YADECommandExecutor.executeFileCommands(logger, targetDelegator, sourceDelegator, targetDelegator, arg, sourceFile, env, false);
        }
    }

    public static void executeBeforeRename(ISOSLogger logger, IYADEProviderDelegator delegator, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, YADEProviderFile sourceFile, boolean isSource) throws YADEEngineCommandException {
        SOSArgument<List<String>> arg = delegator.getArgs().getCommands().getCommandsBeforeRename();
        if (!arg.isEmpty()) {
            boolean skipped;
            boolean bl = skipped = sourceFile.getTarget() == null ? sourceFile.isSkipped() : sourceFile.getTarget().isSkipped();
            if (!skipped || !delegator.getArgs().getCommands().getCommandsAfterFileDisableForSkipped().isTrue()) {
                YADECommandExecutor.executeFileCommands(logger, delegator, sourceDelegator, targetDelegator, arg, sourceFile, null, isSource);
            }
        }
    }

    public static void executeJumpHostCommand(ISOSLogger logger, AYADEProviderDelegator jumpHostDelegator, String command) throws YADEEngineCommandException {
        if (jumpHostDelegator == null) {
            return;
        }
        logger.info("[%s]%s", new Object[]{jumpHostDelegator.getLabel(), command});
        SOSCommandResult result = jumpHostDelegator.getProvider().executeCommand(command);
        YADECommandExecutor.logCommandResult(logger, "[" + jumpHostDelegator.getLabel() + "]", result);
        try {
            YADECommandExecutor.checkCommandResult("[" + jumpHostDelegator.getLabel() + "]", result);
        }
        catch (YADEEngineCommandException e) {
            throw new YADEEngineJumpHostCommandException(e);
        }
    }

    private static void executeAfterOperationCommands(ISOSLogger logger, AYADEProviderDelegator delegator, SOSArgument<List<String>> arg, Throwable exception) throws YADEEngineCommandException {
        String argumentName = arg.getName();
        if (exception != null && YADEProviderDelegatorHelper.isConnectionException(exception) && !delegator.getProvider().isConnected()) {
            logger.info("[%s][%s][%s][skip]due to a connection exception", new Object[]{delegator.getLabel(), argumentName, SOSArgumentHelper.getListStringArgumentValueAsString(arg, (String)((String)delegator.getArgs().getCommands().getCommandDelimiter().getValue()))});
            return;
        }
        YADECommandExecutor.logIfMultipleCommands(logger, delegator.getLabel(), arg, delegator.getArgs().getCommands().getCommandDelimiter());
        for (String command : (List)arg.getValue()) {
            logger.info("[%s][%s]%s", new Object[]{delegator.getLabel(), argumentName, command});
            if (AFTER_OPERATION_BUILTIN_FUNCTION_REMOVE_DIRECTORY.equalsIgnoreCase(command)) {
                if (delegator.getDirectory() == null) {
                    logger.info("[%s][%s][%s][skip]Directory is not set", new Object[]{delegator.getLabel(), argumentName, command});
                    continue;
                }
                try {
                    if (delegator.getProvider().deleteIfExists(delegator.getDirectory())) {
                        logger.info("[%s][%s][%s][removed]%s", new Object[]{delegator.getLabel(), argumentName, command, delegator.getDirectory()});
                        continue;
                    }
                    logger.info("[%s][%s][%s][skip]Directory does not exist", new Object[]{delegator.getLabel(), argumentName, command});
                    continue;
                }
                catch (Throwable e) {
                    throw new YADEEngineCommandException(String.format("[%s][%s][%s]%s", delegator.getLabel(), argumentName, command, delegator.getDirectory()), e);
                }
            }
            SOSCommandResult result = delegator.getProvider().executeCommand(command);
            YADECommandExecutor.logCommandResult(logger, "[" + delegator.getLabel() + "][" + argumentName + "][" + command + "]", result);
            YADECommandExecutor.checkCommandResult(delegator, argumentName, result);
        }
    }

    private static SOSEnv createLocalEnvForExecuteAfterFile(YADEProviderFile sourceFile) {
        if (sourceFile.getTarget() == null) {
            return null;
        }
        SOSEnv env = new SOSEnv();
        env.putLocalEnv(AFTER_FILE_ENV_VAR_FILE_TRANSFER_STATUS, sourceFile.getTarget().getState().value());
        env.putLocalEnv(AFTER_FILE_ENV_VAR_FILE_IS_TRANSFERRED, sourceFile.getTarget().isTransferred() ? "1" : "0");
        return env;
    }

    private static void executeFileCommands(ISOSLogger logger, IYADEProviderDelegator delegator, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, SOSArgument<List<String>> arg, YADEProviderFile sourceFile, SOSEnv env, boolean isSource) throws YADEEngineCommandException {
        YADEProviderFile sourceOrTargetFile = isSource ? sourceFile : sourceFile.getTarget();
        YADECommandExecutor.logIfMultipleCommands(logger, delegator.getLabel(), arg, delegator.getArgs().getCommands().getCommandDelimiter(), sourceOrTargetFile);
        String prefix = String.format("[%s][%s][%s][%s]", sourceFile.getIndex(), delegator.getLabel(), sourceOrTargetFile.getFullPath(), arg.getName());
        for (String command : (List)arg.getValue()) {
            String msg = prefix + "[" + command + "]";
            logger.info((Object)(msg + "..."));
            String resolved = YADEFileCommandVariablesResolver.resolve(sourceDelegator, targetDelegator, sourceFile, command);
            SOSCommandResult result = delegator.getProvider().executeCommand(resolved, env);
            YADECommandExecutor.logCommandResult(logger, msg, result);
            YADECommandExecutor.checkCommandResult(prefix, result);
        }
    }

    private static void logIfMultipleCommands(ISOSLogger logger, String delegatorLabel, SOSArgument<List<String>> commandsArg, SOSArgument<String> commandDelimiterArg) {
        YADECommandExecutor.logIfMultipleCommands(logger, delegatorLabel, commandsArg, commandDelimiterArg, null);
    }

    private static void logIfMultipleCommands(ISOSLogger logger, String delegatorLabel, SOSArgument<List<String>> commandsArg, SOSArgument<String> commandDelimiterArg, YADEProviderFile sourceOrTargetFile) {
        if (((List)commandsArg.getValue()).size() > 1) {
            String add = "";
            if (sourceOrTargetFile != null) {
                add = String.format("[%s][%s]", sourceOrTargetFile.getIndex(), sourceOrTargetFile.getFullPath());
            }
            logger.info("[%s]%s[%s]%s", new Object[]{delegatorLabel, add, commandsArg.getName(), SOSArgumentHelper.getListStringArgumentValueAsString(commandsArg, (String)((String)commandDelimiterArg.getValue()))});
        }
    }

    private static void logCommandResult(ISOSLogger logger, String msg, SOSCommandResult result) {
        boolean hasException;
        if (result == null) {
            return;
        }
        boolean successExitCode = result.getExitCode() != null && result.getExitCode() == 0;
        boolean hasStdOut = !SOSString.isEmpty((String)result.getStdOut());
        boolean hasStdErr = !SOSString.isEmpty((String)result.getStdErr());
        boolean bl = hasException = result.getException() != null;
        if (successExitCode && !hasStdOut && !hasStdErr && !hasException) {
            return;
        }
        ArrayList<CallSite> l = new ArrayList<CallSite>();
        if (!successExitCode) {
            l.add((CallSite)((Object)("exitCode=" + result.getExitCode())));
        }
        if (hasStdOut) {
            l.add((CallSite)((Object)("std:out=" + result.getStdOut().trim())));
        }
        if (hasStdErr) {
            l.add((CallSite)((Object)("std:err=" + result.getStdErr().trim())));
        }
        if (hasException) {
            l.add((CallSite)((Object)("exception=" + result.getException())));
        }
        if (l.size() > 1) {
            logger.info((Object)(msg + "[result][" + String.join((CharSequence)"][", l) + "]"));
        } else {
            logger.info((Object)(msg + "[result]" + (String)l.get(0)));
        }
    }

    private static void checkCommandResult(AYADEProviderDelegator delegator, String argumentName, SOSCommandResult result) throws YADEEngineCommandException {
        YADECommandExecutor.checkCommandResult("[" + delegator.getLabel() + "][" + argumentName + "]", result);
    }

    private static void checkCommandResult(String prefix, SOSCommandResult result) throws YADEEngineCommandException {
        if (result == null) {
            return;
        }
        if (result.hasError(false)) {
            String stdErr = result.getStdErr().trim();
            String std = SOSString.isEmpty((String)stdErr) ? result.getStdOut().trim() : stdErr;
            throw new YADEEngineCommandException(prefix, result.getExitCode(), std);
        }
    }

    public class YADECommandResult {
        YADEEngineCommandException source;
        YADEEngineCommandException target;

        private static YADECommandResult createInstance() {
            return new YADECommandExecutor().new YADECommandResult();
        }

        public void logIfErrorOnInfoLevel(ISOSLogger logger) {
            this.logIfErrorOnInfoLevel(logger, this.source);
            this.logIfErrorOnInfoLevel(logger, this.target);
        }

        public void logIfErrorOnErrorLevel(ISOSLogger logger) {
            this.logIfErrorOnErrorLevel(logger, this.source);
            this.logIfErrorOnErrorLevel(logger, this.target);
        }

        private void logIfErrorOnInfoLevel(ISOSLogger logger, YADEEngineCommandException error) {
            if (error != null) {
                logger.info((Object)error);
            }
        }

        private void logIfErrorOnErrorLevel(ISOSLogger logger, YADEEngineCommandException error) {
            if (error != null) {
                logger.error((Throwable)((Object)error));
            }
        }
    }
}

