/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.command;

import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.yade.engine.commons.YADEProviderFile;
import com.sos.yade.engine.commons.delegators.AYADEProviderDelegator;
import com.sos.yade.engine.commons.delegators.IYADEProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADETargetProviderDelegator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YADEFileCommandVariablesResolver {
    private static final Set<String> VAR_NAMES = new HashSet<String>();
    private static final Pattern VARIABLE_PATTERN;

    public static String resolve(YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, ProviderFile providerFile, String command) {
        Matcher matcher = VARIABLE_PATTERN.matcher(command);
        if (!matcher.find()) {
            return command;
        }
        YADEProviderFile file = (YADEProviderFile)providerFile;
        StringBuilder result = new StringBuilder();
        matcher.reset();
        while (matcher.find()) {
            matcher.appendReplacement(result, Matcher.quoteReplacement(YADEFileCommandVariablesResolver.getVarValue(sourceDelegator, targetDelegator, file, matcher.group())));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String getVarValue(YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, YADEProviderFile file, String var) {
        boolean sourceFileNotNeedsRename = !file.needsRename();
        switch (var) {
            case "$date": {
                return new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            }
            case "$time": {
                return new SimpleDateFormat("HH:mm:ss").format(new Date());
            }
            case "${TargetDirFullName}": {
                return YADEFileCommandVariablesResolver.getDirectoryPath(targetDelegator);
            }
            case "${SourceDirFullName}": {
                return YADEFileCommandVariablesResolver.getDirectoryPath(sourceDelegator);
            }
            case "${TargetFileFullName}": {
                return file.getTarget() == null ? "" : YADEFileCommandVariablesResolver.getFileFullPath(file.getTarget().getFinalFullPath());
            }
            case "${TargetFileRelativeName}": {
                return file.getTarget() == null ? "" : YADEFileCommandVariablesResolver.getFileRelativePath(targetDelegator, file.getTarget().getFinalFullPath());
            }
            case "${TargetFileBaseName}": {
                return file.getTarget() == null ? "" : YADEFileCommandVariablesResolver.getFileBaseName(file.getTarget().getFinalFullPath());
            }
            case "${TargetFileParentFullName}": {
                return file.getTarget() == null ? "" : YADEFileCommandVariablesResolver.getFileParentFullPath(targetDelegator, file.getTarget().getFinalFullPath());
            }
            case "${TargetFileParentBaseName}": {
                return file.getTarget() == null ? "" : YADEFileCommandVariablesResolver.getFileParentBaseName(targetDelegator, file.getTarget().getFinalFullPath());
            }
            case "${TargetTransferFileFullName}": {
                return file.getTarget() == null ? "" : YADEFileCommandVariablesResolver.getFileFullPath(file.getTarget().getFullPath());
            }
            case "${TargetTransferFileRelativeName}": {
                return file.getTarget() == null ? "" : YADEFileCommandVariablesResolver.getFileRelativePath(targetDelegator, file.getTarget().getFullPath());
            }
            case "${TargetTransferFileBaseName}": {
                return file.getTarget() == null ? "" : YADEFileCommandVariablesResolver.getFileBaseName(file.getTarget().getFullPath());
            }
            case "${TargetTransferFileParentFullName}": {
                return file.getTarget() == null ? "" : YADEFileCommandVariablesResolver.getFileParentFullPath(targetDelegator, file.getTarget().getFullPath());
            }
            case "${TargetTransferFileParentBaseName}": {
                return file.getTarget() == null ? "" : YADEFileCommandVariablesResolver.getFileParentBaseName(targetDelegator, file.getTarget().getFullPath());
            }
            case "${SourceFileFullName}": {
                return YADEFileCommandVariablesResolver.getFileFullPath(file.getFullPath());
            }
            case "${SourceFileRelativeName}": {
                return YADEFileCommandVariablesResolver.getFileRelativePath(sourceDelegator, file.getFullPath());
            }
            case "${SourceFileBaseName}": {
                return YADEFileCommandVariablesResolver.getFileBaseName(file.getFullPath());
            }
            case "${SourceFileParentFullName}": {
                return YADEFileCommandVariablesResolver.getFileParentFullPath(sourceDelegator, file.getFullPath());
            }
            case "${SourceFileParentBaseName}": {
                return YADEFileCommandVariablesResolver.getFileParentBaseName(sourceDelegator, file.getFullPath());
            }
            case "${SourceFileRenamedFullName}": {
                return sourceFileNotNeedsRename ? "" : YADEFileCommandVariablesResolver.getFileFullPath(file.getFinalFullPath());
            }
            case "${SourceFileRenamedRelativeName}": {
                return sourceFileNotNeedsRename ? "" : YADEFileCommandVariablesResolver.getFileRelativePath(sourceDelegator, file.getFinalFullPath());
            }
            case "${SourceFileRenamedBaseName}": {
                return sourceFileNotNeedsRename ? "" : YADEFileCommandVariablesResolver.getFileBaseName(file.getFinalFullPath());
            }
            case "${SourceFileRenamedParentFullName}": {
                return sourceFileNotNeedsRename ? "" : YADEFileCommandVariablesResolver.getFileParentFullPath(sourceDelegator, file.getFinalFullPath());
            }
            case "${SourceFileRenamedParentBaseName}": {
                return sourceFileNotNeedsRename ? "" : YADEFileCommandVariablesResolver.getFileParentBaseName(sourceDelegator, file.getFinalFullPath());
            }
        }
        return var;
    }

    private static String getDirectoryPath(IYADEProviderDelegator delegator) {
        if (delegator == null || delegator.getDirectory() == null) {
            return YADEFileCommandVariablesResolver.getOrDefault(null);
        }
        return delegator.getDirectory();
    }

    private static String getFileFullPath(String fullPath) {
        return YADEFileCommandVariablesResolver.getOrDefault(fullPath);
    }

    private static String getFileRelativePath(IYADEProviderDelegator delegator, String fullPath) {
        if (delegator == null) {
            return YADEFileCommandVariablesResolver.getOrDefault(null);
        }
        if (delegator.getDirectory() == null) {
            return YADEFileCommandVariablesResolver.getFileBaseName(fullPath);
        }
        if (fullPath == null) {
            return YADEFileCommandVariablesResolver.getOrDefault(fullPath);
        }
        if (fullPath.startsWith(delegator.getDirectoryWithTrailingPathSeparator())) {
            return fullPath.substring(delegator.getDirectoryWithTrailingPathSeparator().length());
        }
        return YADEFileCommandVariablesResolver.getOrDefault(fullPath);
    }

    private static String getFileBaseName(String fullPath) {
        return YADEFileCommandVariablesResolver.getOrDefault(SOSPathUtils.getName((String)fullPath));
    }

    private static String getFileParentFullPath(AYADEProviderDelegator delegator, String fullPath) {
        return YADEFileCommandVariablesResolver.getOrDefault(delegator.getParentPath(fullPath));
    }

    private static String getFileParentBaseName(AYADEProviderDelegator delegator, String fullPath) {
        return YADEFileCommandVariablesResolver.getOrDefault(SOSPathUtils.getName((String)delegator.getParentPath(fullPath)));
    }

    private static String getOrDefault(String val) {
        return val == null ? "" : val;
    }

    static {
        VAR_NAMES.add("TargetDirFullName");
        VAR_NAMES.add("SourceDirFullName");
        VAR_NAMES.add("TargetFileFullName");
        VAR_NAMES.add("TargetFileRelativeName");
        VAR_NAMES.add("TargetFileBaseName");
        VAR_NAMES.add("TargetFileParentFullName");
        VAR_NAMES.add("TargetFileParentBaseName");
        VAR_NAMES.add("TargetTransferFileFullName");
        VAR_NAMES.add("TargetTransferFileRelativeName");
        VAR_NAMES.add("TargetTransferFileBaseName");
        VAR_NAMES.add("TargetTransferFileParentFullName");
        VAR_NAMES.add("TargetTransferFileParentBaseName");
        VAR_NAMES.add("SourceFileFullName");
        VAR_NAMES.add("SourceFileRelativeName");
        VAR_NAMES.add("SourceFileBaseName");
        VAR_NAMES.add("SourceFileParentFullName");
        VAR_NAMES.add("SourceFileParentBaseName");
        VAR_NAMES.add("SourceFileRenamedFullName");
        VAR_NAMES.add("SourceFileRenamedRelativeName");
        VAR_NAMES.add("SourceFileRenamedBaseName");
        VAR_NAMES.add("SourceFileRenamedParentFullName");
        VAR_NAMES.add("SourceFileRenamedParentBaseName");
        VARIABLE_PATTERN = Pattern.compile("\\$(date|time)|\\$\\{(" + String.join((CharSequence)"|", VAR_NAMES) + ")\\}");
    }
}

