/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.operations;

import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.commons.arguments.YADEArguments;
import com.sos.yade.engine.commons.arguments.YADEClientArguments;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADETargetProviderDelegator;
import com.sos.yade.engine.handlers.operations.copymove.YADECopyMoveOperationsHandler;
import com.sos.yade.engine.handlers.operations.getlist.YADEGetListOperationHandler;
import com.sos.yade.engine.handlers.operations.remove.YADERemoveOperationHandler;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class YADEOperationsManager {
    public static Duration process(ISOSLogger logger, YADEArguments args, YADEClientArguments clientArgs, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, List<ProviderFile> sourceFiles, AtomicBoolean cancel) throws Exception {
        Instant start = Instant.now();
        Yade.TransferOperation operation = (Yade.TransferOperation)args.getOperation().getValue();
        switch (operation) {
            case COPY: 
            case MOVE: {
                YADECopyMoveOperationsHandler.process(operation, logger, args, sourceDelegator, targetDelegator, sourceFiles, cancel);
                return Duration.between(start, Instant.now());
            }
            case REMOVE: {
                YADERemoveOperationHandler.process(operation, logger, args, sourceDelegator, sourceFiles, cancel);
                return Duration.between(start, Instant.now());
            }
            case GETLIST: {
                YADEGetListOperationHandler.process(operation, logger, sourceDelegator);
                return null;
            }
        }
        logger.info("[%s]ignored", new Object[]{operation});
        return null;
    }
}

