/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.operations.copymove;

import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.commons.YADEProviderFile;
import com.sos.yade.engine.commons.arguments.YADEArguments;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADETargetProviderDelegator;
import com.sos.yade.engine.commons.helpers.YADEClientBannerWriter;
import com.sos.yade.engine.commons.helpers.YADEParallelExecutorFactory;
import com.sos.yade.engine.commons.helpers.YADEProviderDelegatorHelper;
import com.sos.yade.engine.exceptions.YADEEngineOperationException;
import com.sos.yade.engine.exceptions.YADEEngineTransferFileException;
import com.sos.yade.engine.handlers.operations.copymove.YADECopyMoveOperationsConfig;
import com.sos.yade.engine.handlers.operations.copymove.file.YADEFileHandler;
import com.sos.yade.engine.handlers.operations.copymove.file.commons.YADETargetProviderFile;
import com.sos.yade.engine.handlers.operations.copymove.file.helpers.YADEFileActionsExecuter;
import com.sos.yade.engine.handlers.operations.copymove.file.helpers.YADETargetCumulativeFileHelper;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class YADECopyMoveOperationsHandler {
    public static void process(Yade.TransferOperation operation, ISOSLogger logger, YADEArguments args, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, List<ProviderFile> sourceFiles, AtomicBoolean cancel) throws Exception {
        if (targetDelegator == null) {
            throw new YADEEngineOperationException("TargetDelegator is required but missing");
        }
        YADECopyMoveOperationsConfig config = new YADECopyMoveOperationsConfig(operation, args, sourceDelegator, targetDelegator, sourceFiles.size());
        sourceDelegator.getDirectoryMapper().tryCreateAllTargetDirectoriesBeforeOperation(logger, config, sourceDelegator, targetDelegator);
        boolean isMoveOperation = config.isMoveOperation();
        boolean useCumulativeTargetFile = config.getTarget().getCumulate() != null;
        try {
            YADECopyMoveOperationsHandler.processFiles(logger, config, sourceDelegator, targetDelegator, sourceFiles, isMoveOperation, useCumulativeTargetFile, cancel);
            YADECopyMoveOperationsHandler.finalizeTransactionIfNeeded(logger, config, sourceDelegator, targetDelegator, sourceFiles, isMoveOperation, useCumulativeTargetFile, cancel);
        }
        catch (Throwable e) {
            YADECopyMoveOperationsHandler.onError(logger, config, sourceDelegator, targetDelegator, sourceFiles, useCumulativeTargetFile);
            throw e;
        }
    }

    public static void handleReusableResourcesBeforeTransfer(YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator) {
        if (!config.processFilesSequentially()) {
            sourceDelegator.getProvider().disableReusableResource();
            targetDelegator.getProvider().disableReusableResource();
        }
    }

    private static void processFiles(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, List<ProviderFile> sourceFiles, boolean isMoveOperation, boolean useCumulativeTargetFile, AtomicBoolean cancel) throws Exception {
        try {
            if (config.processFilesSequentially()) {
                YADECopyMoveOperationsHandler.processFilesSequentially(logger, config, sourceDelegator, targetDelegator, sourceFiles, isMoveOperation, useCumulativeTargetFile, cancel);
            } else {
                YADECopyMoveOperationsHandler.processFilesInParallel(logger, config, sourceDelegator, targetDelegator, sourceFiles, isMoveOperation, cancel);
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (config.isTransactionalEnabled() || sourceDelegator.getArgs().getCommands().isPostProcessingOnOperationErrorEnabled() || targetDelegator.getArgs().getCommands().isPostProcessingOnOperationErrorEnabled()) {
                YADEProviderDelegatorHelper.ensureConnected(logger, sourceDelegator);
                YADEProviderDelegatorHelper.ensureConnected(logger, targetDelegator);
            }
        }
    }

    private static void processFilesInParallel(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, List<ProviderFile> sourceFiles, boolean isMoveOperation, AtomicBoolean cancel) throws Exception {
        YADECopyMoveOperationsHandler.handleReusableResourcesBeforeTransfer(config, sourceDelegator, targetDelegator);
        AtomicInteger nonTransactionalErrorCounter = new AtomicInteger();
        AtomicReference lastNonTransactionalError = new AtomicReference();
        ForkJoinPool threadPool = YADEParallelExecutorFactory.create(config.getParallelism(), sourceFiles.size());
        try {
            ((ForkJoinTask)threadPool.submit(() -> sourceFiles.parallelStream().forEach(f -> {
                if (cancel.get()) {
                    return;
                }
                YADEProviderFile sourceFile = (YADEProviderFile)((Object)((Object)f));
                try {
                    new YADEFileHandler(logger, config, sourceDelegator, targetDelegator, sourceFile, cancel).run(isMoveOperation, false, true);
                }
                catch (Exception e) {
                    if (config.isTransactionalEnabled()) {
                        cancel.set(true);
                        throw new RuntimeException(e);
                    }
                    YADECopyMoveOperationsHandler.setFailedIfNonTransactional(logger, sourceFile, e);
                    nonTransactionalErrorCounter.incrementAndGet();
                    lastNonTransactionalError.set(e);
                }
            }))).join();
        }
        catch (Exception e) {
            throw new YADEEngineOperationException(YADECopyMoveOperationsHandler.getTransferFileException(e.getCause()));
        }
        finally {
            YADEParallelExecutorFactory.shutdown(threadPool);
        }
        YADECopyMoveOperationsHandler.checkNonTransactionalResult(sourceFiles, nonTransactionalErrorCounter.get(), (Throwable)lastNonTransactionalError.get());
    }

    private static void processFilesSequentially(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, List<ProviderFile> sourceFiles, boolean isMoveOperation, boolean useCumulativeTargetFile, AtomicBoolean cancel) throws Exception {
        int lastFileIndex = 0;
        if (useCumulativeTargetFile) {
            YADETargetCumulativeFileHelper.tryDeleteFile(logger, config, targetDelegator);
            if (config.getTarget().isKeepModificationDateEnabled()) {
                lastFileIndex = sourceFiles.get(sourceFiles.size() - 1).getIndex();
            }
        }
        int nonTransactionalErrorCounter = 0;
        Throwable lastNonTransactionalError = null;
        for (ProviderFile sourceFile : sourceFiles) {
            if (cancel.get()) {
                return;
            }
            YADEProviderFile f = (YADEProviderFile)sourceFile;
            boolean useLastModified = lastFileIndex == 0 || lastFileIndex == f.getIndex();
            try {
                new YADEFileHandler(logger, config, sourceDelegator, targetDelegator, f, cancel).run(isMoveOperation, useCumulativeTargetFile, useLastModified);
            }
            catch (Throwable e) {
                if (config.isTransactionalEnabled()) {
                    cancel.set(true);
                    throw e;
                }
                YADECopyMoveOperationsHandler.setFailedIfNonTransactional(logger, f, e);
                ++nonTransactionalErrorCounter;
                lastNonTransactionalError = e;
            }
        }
        YADECopyMoveOperationsHandler.checkNonTransactionalResult(sourceFiles, nonTransactionalErrorCounter, lastNonTransactionalError);
        if (useCumulativeTargetFile) {
            YADETargetCumulativeFileHelper.onSuccess(logger, config, targetDelegator);
        }
    }

    private static void checkNonTransactionalResult(List<ProviderFile> sourceFiles, int nonTransactionalErrorCounter, Throwable lastNonTransactionalError) throws Exception {
        if (nonTransactionalErrorCounter <= 0 || nonTransactionalErrorCounter != sourceFiles.size()) {
            return;
        }
        throw new Exception("Processing of all files failed. Last exception: " + lastNonTransactionalError, lastNonTransactionalError);
    }

    private static void finalizeTransactionIfNeeded(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, List<ProviderFile> sourceFiles, boolean isMoveOperation, boolean useCumulativeTargetFile, AtomicBoolean cancel) throws Exception {
        if (!config.isTransactionalEnabled()) {
            return;
        }
        if (!config.getSource().needsFilePostProcessing() && !config.getTarget().needsFilePostProcessing()) {
            return;
        }
        logger.info((Object)"****************************************************************************************");
        YADECopyMoveOperationsHandler.handleReusableResourcesAfterTransfer(logger, config, sourceDelegator, targetDelegator);
        try {
            String moved = isMoveOperation ? YADEClientBannerWriter.formatState(Yade.TransferEntryState.MOVED) : "";
            boolean isAtomicallyEnabled = config.getTarget().getAtomic() != null;
            int lastFileIndex = 0;
            if (useCumulativeTargetFile && config.getTarget().isKeepModificationDateEnabled()) {
                lastFileIndex = sourceFiles.get(sourceFiles.size() - 1).getIndex();
            }
            for (ProviderFile pf : sourceFiles) {
                YADEProviderFile sourceFile = (YADEProviderFile)pf;
                String fileTransferLogPrefix = String.valueOf(sourceFile.getIndex());
                boolean useLastModified = lastFileIndex == 0 || lastFileIndex == sourceFile.getIndex();
                YADEFileActionsExecuter.postProcessingOnSuccess(logger, fileTransferLogPrefix, config, sourceDelegator, targetDelegator, sourceFile, isAtomicallyEnabled, useLastModified);
                if (!isMoveOperation || sourceDelegator.isJumpHost() || !sourceDelegator.getProvider().deleteFileIfExists(sourceFile.getFinalFullPath())) continue;
                sourceFile.setState(Yade.TransferEntryState.MOVED);
                logger.info("[%s][%s][%s]%s", new Object[]{fileTransferLogPrefix, moved, sourceDelegator.getLabel(), sourceFile.getFinalFullPath()});
            }
        }
        catch (Exception e) {
            logger.error((Object)("[finalizeTransaction]" + e.getMessage()));
            throw e;
        }
    }

    private static void onError(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, List<ProviderFile> sourceFiles, boolean useCumulativeTargetFile) {
        if (config.isTransactionalEnabled()) {
            YADECopyMoveOperationsHandler.rollbackTransactional(logger, config, sourceDelegator, targetDelegator, sourceFiles, useCumulativeTargetFile);
        }
    }

    private static void rollbackTransactional(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, List<ProviderFile> sourceFiles, boolean useCumulativeTargetFile) {
        if (useCumulativeTargetFile) {
            YADETargetCumulativeFileHelper.rollback(logger, config, targetDelegator);
            return;
        }
        logger.info((Object)"****************************************************************************************");
        boolean isJumpHostRollback = false;
        if (targetDelegator.isJumpHost()) {
            logger.info((Object)("[" + targetDelegator.getLabel() + "]rollback"));
            isJumpHostRollback = true;
        }
        if (!isJumpHostRollback) {
            YADECopyMoveOperationsHandler.handleReusableResourcesAfterTransfer(logger, config, sourceDelegator, targetDelegator);
        }
        for (ProviderFile pf : sourceFiles) {
            YADEProviderFile sourceFile = (YADEProviderFile)pf;
            YADETargetProviderFile targetFile = sourceFile.getTarget();
            String fileTransferLogPrefix = String.valueOf(sourceFile.getIndex());
            if (targetFile == null) {
                sourceFile.setState(Yade.TransferEntryState.SELECTED);
                sourceFile.setSubState(Yade.TransferEntryState.ABORTED);
                continue;
            }
            if (isJumpHostRollback) {
                targetFile.setSubState(Yade.TransferEntryState.ROLLED_BACK);
                continue;
            }
            if (!targetFile.isTransferredOrTransferring()) continue;
            if (config.getTarget().isCreateIntegrityHashFileEnabled() && targetFile.getIntegrityHash() != null) {
                String path = targetFile.getFinalFullPath() + config.getIntegrityHashFileExtensionWithDot();
                try {
                    if (targetDelegator.getProvider().deleteFileIfExists(path)) {
                        logger.info("[%s][%s][rollback][%s]deleted", new Object[]{fileTransferLogPrefix, targetDelegator.getLabel(), path});
                    }
                }
                catch (Exception e) {
                    logger.error("[%s][%s][rollback][%s]%s", new Object[]{fileTransferLogPrefix, targetDelegator.getLabel(), path, e.toString()});
                }
            }
            String targetFilePath = Yade.TransferEntryState.RENAMED.equals((Object)targetFile.getSubState()) ? targetFile.getFinalFullPath() : targetFile.getFullPath();
            try {
                if (targetDelegator.getProvider().deleteFileIfExists(targetFilePath)) {
                    logger.info("[%s][%s][rollback][%s]deleted", new Object[]{fileTransferLogPrefix, targetDelegator.getLabel(), targetFilePath});
                }
                targetFile.setSubState(Yade.TransferEntryState.ROLLED_BACK);
            }
            catch (Exception e) {
                logger.error("[%s][%s][rollback][%s]%s", new Object[]{fileTransferLogPrefix, targetDelegator.getLabel(), targetFilePath, e.toString()});
                targetFile.setSubState(Yade.TransferEntryState.ROLLBACK_FAILED);
            }
        }
    }

    private static void handleReusableResourcesAfterTransfer(ISOSLogger logger, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator) {
        sourceDelegator.getProvider().enableReusableResource();
        targetDelegator.getProvider().enableReusableResource();
    }

    private static void setFailedIfNonTransactional(ISOSLogger logger, YADEProviderFile f, Throwable ex) {
        YADEProviderFile y = f;
        if (y.getTarget() == null) {
            y.setSubState(Yade.TransferEntryState.FAILED);
        } else {
            y.getTarget().setSubState(Yade.TransferEntryState.FAILED);
        }
        if (ex != null) {
            String msg = ex.getMessage() == null ? ex.toString() : ex.getMessage();
            logger.warn(msg, ex.getCause());
        }
    }

    private static Throwable getTransferFileException(Throwable ex) {
        Throwable e;
        if (ex == null) {
            return ex;
        }
        for (e = ex; e != null; e = e.getCause()) {
            if (!(e instanceof YADEEngineTransferFileException)) continue;
            return e;
        }
        return e;
    }
}

