/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.operations.copymove.file.helpers;

import com.sos.commons.util.SOSString;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.util.loggers.impl.SLF4JLogger;
import com.sos.commons.vfs.commons.AProvider;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.local.LocalProvider;
import com.sos.commons.vfs.local.commons.LocalProviderArguments;
import com.sos.yade.engine.commons.YADEProviderFile;
import com.sos.yade.engine.commons.arguments.YADESourceArguments;
import com.sos.yade.engine.commons.delegators.AYADEProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.handlers.operations.copymove.file.commons.YADEFileNameInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YADEFileReplacementHelper {
    private static final String VAR_DATE_PREFIX = "[date:";
    private static final String VAR_FILENAME_PREFIX = "[filename:";

    public static Optional<YADEFileNameInfo> getReplacementResultIfDifferent(AYADEProviderDelegator delegator, String fileName, String regex, String replacement) {
        String newName;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(fileName);
        if (!matcher.find()) {
            return Optional.empty();
        }
        if (matcher.groupCount() == 0) {
            String newReplacement = YADEFileReplacementHelper.replaceVariables(replacement, fileName);
            newName = matcher.replaceAll(newReplacement);
        } else {
            String[] replacements = replacement.split(";");
            StringBuilder result = new StringBuilder();
            int lastEnd = 0;
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                result.append(fileName, lastEnd, matcher.start(i));
                String groupReplacement = i - 1 < replacements.length ? replacements[i - 1] : replacements[replacements.length - 1];
                groupReplacement = YADEFileReplacementHelper.replaceVariables(groupReplacement, fileName);
                groupReplacement = YADEFileReplacementHelper.replaceGroupReferences(groupReplacement, matcher);
                result.append(groupReplacement);
                lastEnd = matcher.end(i);
            }
            result.append(fileName.substring(lastEnd));
            newName = result.toString();
        }
        if (newName.equals(fileName)) {
            return Optional.empty();
        }
        return Optional.of(new YADEFileNameInfo(delegator, newName, true));
    }

    private static String replaceGroupReferences(String replacement, Matcher matcher) {
        Pattern groupPattern = Pattern.compile("\\$(\\d+)");
        Matcher groupMatcher = groupPattern.matcher(replacement);
        StringBuilder result = new StringBuilder();
        while (groupMatcher.find()) {
            int groupIndex = Integer.parseInt(groupMatcher.group(1));
            String replacementValue = matcher.groupCount() >= groupIndex ? matcher.group(groupIndex) : "";
            groupMatcher.appendReplacement(result, replacementValue != null ? Matcher.quoteReplacement(replacementValue) : "");
        }
        groupMatcher.appendTail(result);
        return result.toString();
    }

    private static String replaceVariables(String replacement, String fileName) {
        int end;
        int start;
        while (replacement.contains(VAR_DATE_PREFIX)) {
            start = replacement.indexOf(VAR_DATE_PREFIX) + 6;
            end = replacement.indexOf("]", start);
            String dateFormat = replacement.substring(start, end);
            replacement = replacement.replace(VAR_DATE_PREFIX + dateFormat + "]", new SimpleDateFormat(dateFormat).format(new Date()));
        }
        while (replacement.contains(VAR_FILENAME_PREFIX)) {
            start = replacement.indexOf(VAR_FILENAME_PREFIX) + 10;
            end = replacement.indexOf("]", start);
            String option = replacement.substring(start, end);
            String modifiedFileName = fileName;
            if ("lowercase".equals(option)) {
                modifiedFileName = modifiedFileName.toLowerCase();
            } else if ("uppercase".equals(option)) {
                modifiedFileName = modifiedFileName.toUpperCase();
            }
            replacement = replacement.replace(VAR_FILENAME_PREFIX + option + "]", modifiedFileName);
        }
        return replacement;
    }

    public static void main(String[] args) {
        try {
            LocalProviderArguments pargs = new LocalProviderArguments();
            pargs.applyDefaultIfNullQuietly();
            YADESourceArguments sargs = new YADESourceArguments();
            sargs.applyDefaultIfNullQuietly();
            sargs.setProvider((AProviderArguments)pargs);
            YADESourceProviderDelegator delegator = new YADESourceProviderDelegator((AProvider<?>)new LocalProvider((ISOSLogger)new SLF4JLogger(), pargs), sargs);
            YADEProviderFile file = new YADEProviderFile(delegator, "/tmp/1abc12def123.TXT", 0L, 0L, null, false);
            String regex = "(1)abc(12)def(.*)";
            String replacement = "A;BB;CCC";
            regex = ".*";
            replacement = "[date:yyyy-MM-dd-HH-mm-ss];BB;1.txt";
            replacement = "[filename:uppercase]";
            regex = "(^.*$)";
            replacement = "/sub/$1";
            regex = "a";
            replacement = "b";
            Optional<YADEFileNameInfo> result = YADEFileReplacementHelper.getReplacementResultIfDifferent(delegator, file.getName(), regex, replacement);
            System.out.println("[RESULT]" + (result.isPresent() ? SOSString.toString((Object)result.get()) : "false"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

