/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.source;

import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.SOSComparisonOperator;
import com.sos.commons.util.SOSPath;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelectionConfig;
import com.sos.yade.engine.commons.arguments.YADEArguments;
import com.sos.yade.engine.commons.arguments.YADEClientArguments;
import com.sos.yade.engine.commons.arguments.YADESourceArguments;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADETargetProviderDelegator;
import com.sos.yade.engine.commons.helpers.YADEArgumentsHelper;
import com.sos.yade.engine.exceptions.YADEEngineSourceFilesSelectorException;
import com.sos.yade.engine.exceptions.YADEEngineSourceZeroByteFilesException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class YADESourceFilesSelector {
    public static List<ProviderFile> selectFiles(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, String excludedFileExtension) throws YADEEngineSourceFilesSelectorException {
        return YADESourceFilesSelector.selectFiles(logger, sourceDelegator, excludedFileExtension, false);
    }

    public static List<ProviderFile> selectFiles(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, String excludedFileExtension, boolean polling) throws YADEEngineSourceFilesSelectorException {
        if (sourceDelegator.getArgs().isSingleFilesSelection()) {
            return YADESourceFilesSelector.selectSingleFiles(logger, sourceDelegator, YADESourceFilesSelector.createProviderFileSelection(sourceDelegator, null, true), polling);
        }
        return YADESourceFilesSelector.selectFiles(sourceDelegator, YADESourceFilesSelector.createProviderFileSelection(sourceDelegator, excludedFileExtension, false));
    }

    public static String getExcludedFileExtension(YADEArguments args, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator) {
        if (sourceDelegator.getArgs().getCheckIntegrityHash().isTrue()) {
            return (String)sourceDelegator.getArgs().getIntegrityHashAlgorithm().getValue();
        }
        if (targetDelegator != null && targetDelegator.getArgs().getCreateIntegrityHashFile().isTrue()) {
            return (String)targetDelegator.getArgs().getIntegrityHashAlgorithm().getValue();
        }
        return null;
    }

    public static void checkSelectionResult(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, YADEClientArguments clientArgs, List<ProviderFile> sourceFiles) throws YADEEngineSourceFilesSelectorException {
        StringBuilder sb = new StringBuilder();
        if (sourceDelegator.getDirectory() != null) {
            String sourceDirectory = sourceDelegator.getDirectory().isEmpty() ? sourceDelegator.getProvider().getPathSeparator() : sourceDelegator.getDirectory();
            sb.append("[");
            sb.append(sourceDelegator.getArgs().getDirectory().getName()).append("=").append(sourceDirectory);
            sb.append("]");
        }
        sb.append("[").append(YADEArgumentsHelper.toString(sourceDelegator.getArgs().getRecursive())).append("]");
        if (sourceDelegator.getArgs().isSingleFilesSelection()) {
            if (sourceDelegator.getArgs().isFileListEnabled()) {
                sb.append("[").append(YADEArgumentsHelper.toString(sourceDelegator.getArgs().getFileList())).append("]");
            } else if (sourceDelegator.getArgs().isFilePathEnabled()) {
                sb.append("[").append(YADEArgumentsHelper.toString(sourceDelegator.getArgs().getFilePath().getName(), sourceDelegator.getArgs().getFilePathAsString())).append("]");
            }
        } else {
            sb.append("[").append(YADEArgumentsHelper.toString(sourceDelegator.getArgs().getFileSpec())).append("]");
        }
        if (!sourceDelegator.getArgs().getMaxFiles().isEmpty()) {
            sb.append("[").append(YADEArgumentsHelper.toString(sourceDelegator.getArgs().getMaxFiles())).append("]");
        }
        if (!sourceDelegator.getArgs().getMinFileSize().isEmpty()) {
            sb.append("[").append(YADEArgumentsHelper.toString(sourceDelegator.getArgs().getMinFileSize())).append("]");
        }
        if (!sourceDelegator.getArgs().getMaxFileSize().isEmpty()) {
            sb.append("[").append(YADEArgumentsHelper.toString(sourceDelegator.getArgs().getMaxFileSize())).append("]");
        }
        logger.info("[%s][Selection]%sfound=%s", new Object[]{sourceDelegator.getLabel(), sb, sourceFiles.size()});
        YADESourceFilesSelector.checkZeroByteFiles(logger, sourceDelegator, sourceFiles);
        YADESourceFilesSelector.checkFileListSize(logger, sourceDelegator, clientArgs, sourceFiles);
    }

    private static List<ProviderFile> selectFiles(YADESourceProviderDelegator sourceDelegator, ProviderFileSelection selection) throws YADEEngineSourceFilesSelectorException {
        try {
            return sourceDelegator.getProvider().selectFiles(selection);
        }
        catch (Throwable e) {
            throw new YADEEngineSourceFilesSelectorException(e.toString(), e.getCause() == null ? e : e.getCause());
        }
    }

    private static ProviderFileSelection createProviderFileSelection(YADESourceProviderDelegator sourceDelegator, String excludedFileExtension, boolean singleFiles) {
        YADESourceArguments sourceArgs = sourceDelegator.getArgs();
        ProviderFileSelectionConfig.Builder builder = new ProviderFileSelectionConfig.Builder();
        if (!singleFiles) {
            builder.directory(sourceDelegator.getDirectory());
            builder.fileNamePattern(Pattern.compile((String)sourceArgs.getFileSpec().getValue(), 0));
            if (!SOSString.isEmpty((String)((String)sourceArgs.getExcludedDirectories().getValue()))) {
                builder.excludedDirectoriesPattern(Pattern.compile((String)sourceArgs.getExcludedDirectories().getValue(), 0));
            }
            if (!SOSString.isEmpty((String)excludedFileExtension)) {
                builder.excludedFileExtension((String)(excludedFileExtension.startsWith(".") ? excludedFileExtension : "." + excludedFileExtension));
            }
            builder.recursive(sourceArgs.getRecursive().getValue() == null ? false : (Boolean)sourceArgs.getRecursive().getValue());
        }
        if (sourceArgs.getMaxFiles().getValue() != null) {
            builder.maxFiles(((Integer)sourceArgs.getMaxFiles().getValue()).intValue());
        }
        if (sourceArgs.getMaxFileSize().getValue() != null) {
            builder.maxFileSize(((Long)sourceArgs.getMaxFileSize().getValue()).longValue());
        }
        if (sourceArgs.getMinFileSize().getValue() != null) {
            builder.minFileSize(((Long)sourceArgs.getMinFileSize().getValue()).longValue());
        }
        return new ProviderFileSelection(builder.build());
    }

    private static List<ProviderFile> selectSingleFiles(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, ProviderFileSelection selection, boolean polling) throws YADEEngineSourceFilesSelectorException {
        YADESourceArguments args = sourceDelegator.getArgs();
        String lp = "[" + sourceDelegator.getLabel() + "][selectSingleFiles]";
        List singleFiles = null;
        Object arg = null;
        if (args.isFilePathEnabled()) {
            arg = args.getFilePath();
            singleFiles = (List)args.getFilePath().getValue();
        } else if (args.isFileListEnabled()) {
            arg = args.getFileList();
            if (!Files.exists((Path)args.getFileList().getValue(), new LinkOption[0])) {
                throw new YADEEngineSourceFilesSelectorException(String.format("%s[%s=%s]doesn't exist", lp, args.getFileList().getName(), args.getFileList().getValue()));
            }
            try {
                singleFiles = SOSPath.readFileNonEmptyLines((Path)((Path)args.getFileList().getValue()));
            }
            catch (IOException e) {
                throw new YADEEngineSourceFilesSelectorException(String.format("%s[%s=%s]error reading from file", lp, args.getFileList().getName(), args.getFileList().getValue()), e);
            }
        }
        if (SOSCollection.isEmpty(singleFiles)) {
            logger.info("%s[%s][skip]no singleFiles defined", new Object[]{lp, arg.getName()});
            return List.of();
        }
        ArrayList<ProviderFile> result = new ArrayList<ProviderFile>();
        int counterAdded = 0;
        int counter = 0;
        int maxFiles = selection.getConfig().getMaxFiles();
        for (String singleFile : singleFiles) {
            ++counter;
            if (maxFiles > -1 && counterAdded >= maxFiles) {
                logger.info("%s[%s][%s][break]due to %s=%s", new Object[]{lp, counter, singleFile, args.getMaxFiles().getName(), maxFiles});
                break;
            }
            String path = singleFile;
            if (sourceDelegator.getDirectory() != null && !sourceDelegator.getProvider().isAbsolutePath(singleFile)) {
                path = sourceDelegator.appendPath(sourceDelegator.getDirectory(), singleFile);
            }
            String logPrefix = String.format("%s[%s][%s]", lp, counter, path);
            ProviderFile file = null;
            try {
                file = sourceDelegator.getProvider().getFileIfExists(path);
            }
            catch (Throwable e) {
                Throwable ex = e.getCause() == null ? e : e.getCause();
                throw new YADEEngineSourceFilesSelectorException(logPrefix + ex.toString(), e);
            }
            if (file == null) {
                if (polling) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(logPrefix + "not found"));
                    continue;
                }
                logger.info((Object)(logPrefix + "not found"));
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(logPrefix + "found"));
            }
            if (!YADESourceFilesSelector.addSingleFile(logger, logPrefix, file, selection, polling)) continue;
            file.setIndex(++counterAdded);
            result.add(file);
        }
        return result;
    }

    private static boolean addSingleFile(ISOSLogger logger, String logPrefix, ProviderFile file, ProviderFileSelection selection, boolean polling) {
        if (!selection.checkProviderFileMaxSize(file)) {
            String msg = String.format("%s[skip][fileSize=%sb]fileSize > maxFileSize=%sb", logPrefix, file.getSize(), selection.getConfig().getMaxFileSize());
            if (polling) {
                logger.debug((Object)msg);
            } else {
                logger.info((Object)msg);
            }
            return false;
        }
        if (!selection.checkProviderFileMinSize(file)) {
            String msg = String.format("%s[skip][fileSize=%sb]fileSize < minFileSize=%sb", logPrefix, file.getSize(), selection.getConfig().getMinFileSize());
            if (polling) {
                logger.debug((Object)msg);
            } else {
                logger.info((Object)msg);
            }
            return false;
        }
        return true;
    }

    private static void checkZeroByteFiles(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, List<ProviderFile> sourceFiles) throws YADEEngineSourceZeroByteFilesException {
        if (SOSCollection.isEmpty(sourceFiles)) {
            return;
        }
        int i = 1;
        YADESourceArguments args = sourceDelegator.getArgs();
        switch ((YADESourceArguments.ZeroByteTransfer)((Object)args.getZeroByteTransfer().getValue())) {
            case TRUE: {
                break;
            }
            case FALSE: {
                List<ProviderFile> zeroSizeFiles = YADESourceFilesSelector.getZeroSizeFiles(sourceFiles);
                if (zeroSizeFiles.size() != sourceFiles.size()) break;
                i = 1;
                for (ProviderFile f : zeroSizeFiles) {
                    logger.info("[%s][%s][TransferZeroByteFiles=NO][%s]bytes=%s", new Object[]{sourceDelegator.getLabel(), i, f.getFullPath(), f.getSize()});
                    ++i;
                }
                throw new YADEEngineSourceZeroByteFilesException(String.format("[TransferZeroByteFiles=NO]All %s file(s) have zero byte size, transfer aborted", zeroSizeFiles.size()));
            }
            case RELAXED: {
                break;
            }
            case STRICT: {
                List<ProviderFile> zeroSizeFiles = YADESourceFilesSelector.getZeroSizeFiles(sourceFiles);
                if (zeroSizeFiles.size() <= 0) break;
                i = 1;
                for (ProviderFile f : zeroSizeFiles) {
                    logger.info("[%s][%s][TransferZeroByteFiles=STRICT][%s]bytes=%s", new Object[]{sourceDelegator.getLabel(), i, f.getFullPath(), f.getSize()});
                    ++i;
                }
                throw new YADEEngineSourceZeroByteFilesException(String.format("[TransferZeroByteFiles=STRICT]%s zero byte size file(s) detected", zeroSizeFiles.size()));
            }
        }
    }

    private static List<ProviderFile> getZeroSizeFiles(List<ProviderFile> sourceFiles) {
        ArrayList<ProviderFile> result = new ArrayList<ProviderFile>();
        sourceFiles.stream().filter(f -> {
            if (f.getSize() <= 0L) {
                result.add((ProviderFile)f);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        return result;
    }

    private static int checkFileListSize(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, YADEClientArguments clientArgs, List<ProviderFile> sourceFiles) throws YADEEngineSourceFilesSelectorException {
        int size;
        int n = size = sourceFiles == null ? 0 : sourceFiles.size();
        if (size == 0 && ((Boolean)sourceDelegator.getArgs().getErrorOnNoFilesFound().getValue()).booleanValue()) {
            throw new YADEEngineSourceFilesSelectorException(String.format("[%s][%s=true]No files found", sourceDelegator.getLabel(), sourceDelegator.getArgs().getErrorOnNoFilesFound().getName()));
        }
        if (clientArgs.getExpectedResultSetCount().isEmpty()) {
            return size;
        }
        SOSComparisonOperator op = (SOSComparisonOperator)clientArgs.getRaiseErrorIfResultSetIs().getValue();
        if (op != null) {
            int expectedSize = (Integer)clientArgs.getExpectedResultSetCount().getValue();
            if (op.compare(size, expectedSize)) {
                throw new YADEEngineSourceFilesSelectorException(String.format("[%s][files found=%s][%s]%s %s", sourceDelegator.getLabel(), size, clientArgs.getRaiseErrorIfResultSetIs().getName(), op.getFirstAlias(), expectedSize));
            }
            logger.info("[%s][%s=%s %s][files found=%s]ok", new Object[]{sourceDelegator.getLabel(), clientArgs.getRaiseErrorIfResultSetIs().getName(), op.getFirstAlias(), expectedSize, size});
        }
        return size;
    }
}

