/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SOSCLIArgumentsParser {
    public static Map<String, String> parse(String args) {
        if (args == null || args.trim().isEmpty()) {
            return new LinkedHashMap<String, String>();
        }
        return SOSCLIArgumentsParser.parse(SOSCLIArgumentsParser.tokenize(args).toArray(new String[0]));
    }

    public static Map<String, String> parse(String[] args) {
        LinkedHashMap<String, String> arguments = new LinkedHashMap<String, String>();
        if (args == null || args.length == 0) {
            return arguments;
        }
        for (int i = 0; i < args.length; ++i) {
            String key;
            String arg = args[i];
            if (!arg.startsWith("-")) continue;
            if (arg.contains("=")) {
                String[] parts = arg.split("=", 2);
                key = parts[0].replaceFirst("^--?", "");
                arguments.put(key, SOSCLIArgumentsParser.stripQuotes(parts[1]));
                continue;
            }
            key = arg.replaceFirst("^--?", "");
            ArrayList<String> values = new ArrayList<String>();
            while (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                values.add(SOSCLIArgumentsParser.stripQuotes(args[++i]));
            }
            if (values.isEmpty()) {
                arguments.put(key, "true");
                continue;
            }
            arguments.put(key, String.join((CharSequence)" ", values));
        }
        return arguments;
    }

    private static String stripQuotes(String value) {
        return value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'") ? value.substring(1, value.length() - 1) : value;
    }

    private static List<String> tokenize(String input) {
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher m = Pattern.compile("([^\"]\\S*|\".*?\"|'.*?')\\s*").matcher(input);
        while (m.find()) {
            tokens.add(m.group(1).trim());
        }
        return tokens;
    }

    public static void main(String[] args) {
        for (String a : args) {
            System.out.println("[ARG]" + a);
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add("--age=30");
        l.add("--city=\"Berlin\"");
        l.add("-name");
        l.add("\"Fritz Tester\"");
        l.add("-java-options");
        l.add("\"-Xms32m\"");
        l.add("\"-Xmx64m\"");
        l.add("--flag");
        Map<String, String> result = SOSCLIArgumentsParser.parse(l.toArray(new String[0]));
        System.out.println(result);
        result = SOSCLIArgumentsParser.parse(" --age=30 --city=Berlin -name \"Fritz Tester\" -java-options \"-Xms32m\" \"-Xmx64m\"     --flag");
        System.out.println(result);
    }
}

