/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import com.sos.commons.util.SOSString;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSClassUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSClassUtil.class);
    private static final String NEW_LINE = "\n";

    public static String getMethodName() {
        return SOSClassUtil.getMethodName(1);
    }

    public static String getMethodName(int index) {
        while (index >= 0) {
            try {
                StackTraceElement trace = new Throwable().getStackTrace()[index];
                return SOSClassUtil.getSimpleName(trace.getClassName()) + "." + trace.getMethodName();
            }
            catch (Exception e) {
                --index;
            }
        }
        return "";
    }

    public static String getClassName() throws Exception {
        return new Throwable().getStackTrace()[1].getClassName();
    }

    public static void printStackTrace() {
        SOSClassUtil.printStackTrace(true, null);
    }

    public static void printStackTrace(boolean onlySOS) {
        SOSClassUtil.printStackTrace(onlySOS, null);
    }

    public static void printStackTrace(boolean onlySOS, Logger logger) {
        try {
            Logger log = logger == null ? LOGGER : logger;
            StackTraceElement[] trace = new Throwable().getStackTrace();
            for (int i = 1; i < trace.length; ++i) {
                StackTraceElement el = trace[i];
                if (onlySOS && !el.getClassName().matches("^com\\.sos.*|^sos\\..*")) continue;
                log.info(String.format("[%s][%s:%s]", el.getClassName(), el.getMethodName(), el.getLineNumber()));
            }
        }
        catch (Throwable ee) {
            LOGGER.error(ee.toString(), ee);
        }
    }

    public static String getStackTrace(Throwable e) {
        return SOSClassUtil.getStackTrace(e, NEW_LINE);
    }

    public static String getStackTrace(Throwable e, String newLine) {
        if (e == null) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder();
            StackTraceElement[] trace = e.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                sb.append(trace[i].toString()).append(newLine);
            }
            return sb.toString().trim();
        }
        catch (Throwable ee) {
            LOGGER.error(ee.toString(), ee);
            return null;
        }
    }

    public static String getFullStackTrace(Throwable e) {
        if (e == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(SOSClassUtil.getStackTrace(e));
        for (Throwable ex = e.getCause(); ex != null; ex = ex.getCause()) {
            String s = SOSClassUtil.getStackTrace(ex.getCause());
            if (s == null) continue;
            sb.append(NEW_LINE);
            sb.append("Caused by: ").append(s);
        }
        return sb.toString();
    }

    public static URL getLocation(String fullyQualifiedClassName) throws ClassNotFoundException {
        return SOSClassUtil.getLocation(SOSClassUtil.class.getClassLoader(), fullyQualifiedClassName);
    }

    public static URL getLocation(ClassLoader cl, Class<?> clazz) throws ClassNotFoundException {
        return SOSClassUtil.getLocation(cl, clazz.getName());
    }

    public static URL getLocation(ClassLoader cl, String fullyQualifiedClassName) throws ClassNotFoundException {
        return SOSClassUtil.getLocation(cl.loadClass(fullyQualifiedClassName));
    }

    public static URL getLocation(Class<?> clazz) {
        return clazz.getProtectionDomain().getCodeSource().getLocation();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static long countBytes(InputStream inputStream) throws IOException {
        try (OutputStream nullOutputStream = OutputStream.nullOutputStream();){
            long l = inputStream.transferTo(nullOutputStream);
            return l;
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((nRead = input.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public static InputStream openResourceStream(Class<?> contextClass, String resourcePath) {
        if (contextClass == null || resourcePath == null) {
            return null;
        }
        InputStream is = contextClass.getClassLoader().getResourceAsStream(resourcePath);
        if (is == null) {
            throw new IllegalArgumentException("[" + contextClass.getName() + "]Resource not found: " + resourcePath);
        }
        return is;
    }

    public static String readResourceFile(Class<?> contextClass, String resourcePath) throws Exception {
        if (contextClass == null || resourcePath == null) {
            return null;
        }
        try (InputStream is = SOSClassUtil.openResourceStream(contextClass, resourcePath);){
            String string = SOSString.toString(is);
            return string;
        }
    }

    private static String getSimpleName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }
}

