/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SOSComparisonOperator {
    EQUAL(new String[]{"eq", "equal", "==", "="}){

        @Override
        public boolean compare(int actualValue, int expectedValue) {
            return actualValue == expectedValue;
        }
    }
    ,
    NOT_EQUAL(new String[]{"ne", "not equal", "!=", "<>"}){

        @Override
        public boolean compare(int actualValue, int expectedValue) {
            return actualValue != expectedValue;
        }
    }
    ,
    LESS_THAN(new String[]{"lt", "less than", "<"}){

        @Override
        public boolean compare(int actualValue, int expectedValue) {
            return actualValue < expectedValue;
        }
    }
    ,
    LESS_OR_EQUAL(new String[]{"le", "less or equal", "<="}){

        @Override
        public boolean compare(int actualValue, int expectedValue) {
            return actualValue <= expectedValue;
        }
    }
    ,
    GREATER_OR_EQUAL(new String[]{"ge", "greater or equal", ">="}){

        @Override
        public boolean compare(int actualValue, int expectedValue) {
            return actualValue >= expectedValue;
        }
    }
    ,
    GREATER_THAN(new String[]{"gt", "greater than", ">"}){

        @Override
        public boolean compare(int actualValue, int expectedValue) {
            return actualValue > expectedValue;
        }
    };

    private final Set<String> aliases;

    private SOSComparisonOperator(String ... aliases) {
        this.aliases = new HashSet<String>(Arrays.asList(aliases));
    }

    public String getFirstAlias() {
        return this.aliases.iterator().next();
    }

    public abstract boolean compare(int var1, int var2);

    public static SOSComparisonOperator fromString(String operator) {
        return Arrays.stream(SOSComparisonOperator.values()).filter(op -> op.aliases.contains(operator.toLowerCase())).findFirst().orElse(null);
    }
}

