/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.SOSPath;
import com.sos.commons.util.SOSString;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class SOSPathUtils {
    public static final String PATH_SEPARATOR_UNIX = "/";
    public static final String PATH_SEPARATOR_WINDOWS = "\\";
    public static final String FILENAME_ILLEGAL_CHARS_REGEX_UNIX = "[/]";
    public static final String FILENAME_ILLEGAL_CHARS_REGEX_WINDOWS = "[<>:\"/\\\\|?*]";
    private static final String REGEX_ABSOLUTE_URI_PATH = "^(?![a-zA-Z]:[/\\\\])[a-zA-Z][a-zA-Z0-9+.-]*:/.+";
    private static final String REGEX_ABSOLUTE_UNIX_PATH = "^(\\/|\\$|~\\/).*";
    private static final String REGEX_ABSOLUTE_WINDOWS_STANDARD_PATH = "^[a-zA-Z]:[\\\\/].*";
    private static final String REGEX_ABSOLUTE_WINDOWS_ENV_PATH = "^%[\\p{L}\\p{N}_.-]+%.*";
    private static final String REGEX_ABSOLUTE_WINDOWS_OPENSSH_PATH = "^/[a-zA-Z]:/.*";
    private static final String REGEX_ABSOLUTE_WINDOWS_UNC_PATH = "^\\\\[a-zA-Z0-9._-]+\\\\[a-zA-Z0-9._-]+(\\\\[a-zA-Z0-9._-]+)*$";
    private static final String REGEX_ABSOLUTE_WINDOWS_PATH = "^[a-zA-Z]:[\\\\/].*|^%[\\p{L}\\p{N}_.-]+%.*|^/[a-zA-Z]:/.*|^\\\\[a-zA-Z0-9._-]+\\\\[a-zA-Z0-9._-]+(\\\\[a-zA-Z0-9._-]+)*$";
    private static final String REGEX_ABSOLUTE_FILESYSTEM_PATH = "^(\\/|\\$|~\\/).*|^[a-zA-Z]:[\\\\/].*|^%[\\p{L}\\p{N}_.-]+%.*|^/[a-zA-Z]:/.*|^\\\\[a-zA-Z0-9._-]+\\\\[a-zA-Z0-9._-]+(\\\\[a-zA-Z0-9._-]+)*$";

    public static String toUnixStyle(String path) {
        return SOSString.isEmpty(path) ? null : path.replace(PATH_SEPARATOR_WINDOWS, PATH_SEPARATOR_UNIX);
    }

    public static String toWindowsStyle(String path) {
        return SOSString.isEmpty(path) ? null : path.replace(PATH_SEPARATOR_UNIX, PATH_SEPARATOR_WINDOWS);
    }

    public static boolean isAbsoluteWindowsPath(String path) {
        if (SOSString.isEmpty(path)) {
            return false;
        }
        return path.matches(REGEX_ABSOLUTE_WINDOWS_PATH);
    }

    public static boolean isAbsoluteUnixPath(String path) {
        if (SOSString.isEmpty(path)) {
            return false;
        }
        return path.matches(REGEX_ABSOLUTE_UNIX_PATH);
    }

    public static boolean isAbsoluteFileSystemPath(String path) {
        if (SOSString.isEmpty(path)) {
            return false;
        }
        return path.matches(REGEX_ABSOLUTE_FILESYSTEM_PATH);
    }

    public static boolean isAbsoluteURIPath(String path) {
        if (SOSString.isEmpty(path)) {
            return false;
        }
        return SOSPathUtils.toUnixStyle(path).matches(REGEX_ABSOLUTE_URI_PATH);
    }

    public static boolean isAbsoluteWindowsOpenSSHPath(String path) {
        if (SOSString.isEmpty(path)) {
            return false;
        }
        return SOSPathUtils.toUnixStyle(path).matches(REGEX_ABSOLUTE_WINDOWS_OPENSSH_PATH);
    }

    public static boolean isAbsoluteWindowsStandardPath(String path) {
        if (SOSString.isEmpty(path)) {
            return false;
        }
        return SOSPathUtils.toWindowsStyle(path).matches(REGEX_ABSOLUTE_WINDOWS_STANDARD_PATH);
    }

    public static boolean isAbsoluteWindowsEnvPath(String path) {
        if (SOSString.isEmpty(path)) {
            return false;
        }
        return path.matches(REGEX_ABSOLUTE_WINDOWS_ENV_PATH);
    }

    public static boolean isAbsoluteWindowsUNCPath(String path) {
        if (SOSString.isEmpty(path)) {
            return false;
        }
        return path.matches(REGEX_ABSOLUTE_WINDOWS_UNC_PATH);
    }

    public static String toAbsoluteUnixPath(String path) {
        if (SOSString.isEmpty(path)) {
            return path;
        }
        return SOSPathUtils.toUnixStyle(SOSPath.toAbsoluteNormalizedPath(path).toString());
    }

    public static String toAbsoluteUnixPath() {
        return SOSPathUtils.toUnixStyle(SOSPath.toAbsoluteNormalizedPath("").toString());
    }

    public static String getName(String path) {
        String np = SOSPathUtils.toUnixStyle(path);
        if (np == null) {
            return null;
        }
        int li = np.lastIndexOf(PATH_SEPARATOR_UNIX);
        if (li == 0 && np.equals(PATH_SEPARATOR_UNIX)) {
            return null;
        }
        String tmp = li >= 0 ? np.substring(li + 1) : np;
        return tmp.isEmpty() || SOSString.trimEnd(tmp, PATH_SEPARATOR_UNIX).endsWith(":") ? null : tmp;
    }

    public static String getParentPath(String path) {
        return SOSPathUtils.getParentPath(path, null);
    }

    public static String getParentPath(String path, String pathSeparator) {
        if (path == null) {
            return null;
        }
        String name = SOSPathUtils.getName(path);
        if (name == null) {
            return null;
        }
        String ps = SOSPathUtils.getPathSeparator(path, pathSeparator);
        String tmp = SOSString.trimEnd(path.substring(0, path.lastIndexOf(name)), ps);
        if (tmp.isEmpty()) {
            return ps;
        }
        return tmp.endsWith(":") ? tmp + ps : tmp;
    }

    public static String appendPath(String basePath, String additionalPath) {
        return SOSPathUtils.appendPath(basePath, additionalPath, null);
    }

    public static String appendPath(String basePath, String additionalPath, String pathSeparator) {
        if (SOSString.isEmpty(basePath)) {
            return additionalPath;
        }
        if (SOSString.isEmpty(additionalPath)) {
            return basePath;
        }
        String ps1 = SOSPathUtils.getPathSeparator(basePath, pathSeparator);
        String ps2 = SOSPathUtils.getPathSeparator(additionalPath, pathSeparator);
        return SOSString.trimEnd(basePath, ps1) + ps2 + SOSString.trimStart(additionalPath, ps2);
    }

    public static String getUnixStyleParentPath(String path) {
        return SOSPathUtils.getParentPath(SOSPathUtils.toUnixStyle(path), PATH_SEPARATOR_UNIX);
    }

    public static String getWindowsStyleParentPath(String path) {
        return SOSPathUtils.getParentPath(SOSPathUtils.toWindowsStyle(path), PATH_SEPARATOR_WINDOWS);
    }

    public static String getUnixStyleDirectoryWithoutTrailingSeparator(String path) {
        return SOSPathUtils.getDirectoryWithoutTrailingSeparator(SOSPathUtils.toUnixStyle(path), PATH_SEPARATOR_UNIX);
    }

    public static String getWindowsStyleDirectoryWithoutTrailingSeparator(String path) {
        return SOSPathUtils.getDirectoryWithoutTrailingSeparator(SOSPathUtils.toWindowsStyle(path), PATH_SEPARATOR_WINDOWS);
    }

    public static String getUnixStyleDirectoryWithTrailingSeparator(String path) {
        return SOSPathUtils.getDirectoryWithTrailingSeparator(SOSPathUtils.toUnixStyle(path), PATH_SEPARATOR_UNIX);
    }

    public static String getWindowsStyleDirectoryWithTrailingSeparator(String path) {
        return SOSPathUtils.getDirectoryWithTrailingSeparator(SOSPathUtils.toWindowsStyle(path), PATH_SEPARATOR_WINDOWS);
    }

    public static String getDirectoryWithTrailingSeparator(String path, String pathSeparator) {
        if (path == null) {
            return null;
        }
        return path.endsWith(pathSeparator) ? path : path + pathSeparator;
    }

    public static Set<String> selectTopLevelPaths(Collection<?> paths) {
        return SOSPathUtils.selectTopLevelPaths(paths, null);
    }

    public static Set<String> selectTopLevelPaths(Collection<?> paths, String pathSeparator) {
        if (SOSCollection.isEmpty(paths)) {
            return new TreeSet<String>();
        }
        String ps = SOSPathUtils.getPathSeparator(paths, pathSeparator);
        Set<Object> result = new HashSet();
        HashSet<String> analyzed = new HashSet<String>();
        Set normalized = paths.stream().map(e -> SOSPathUtils.getDirectoryWithoutTrailingSeparator(e.toString(), ps)).collect(Collectors.toSet());
        normalized = new TreeSet(normalized);
        for (String path : normalized) {
            if (analyzed.stream().anyMatch(path::startsWith)) {
                analyzed.add(path);
                continue;
            }
            for (String pathSub : normalized) {
                if (pathSub.equals(path) || analyzed.contains(pathSub)) continue;
                String pathSubStripped = SOSString.removePrefix(pathSub, path);
                if (pathSub.equals(pathSubStripped)) {
                    String p2;
                    String p1 = SOSPathUtils.getParentPath(path, ps);
                    if (p1.equals(p2 = SOSPathUtils.getParentPath(pathSub, ps))) {
                        result.add(p1);
                        analyzed.add(path);
                        analyzed.add(pathSub);
                        continue;
                    }
                    result.add(pathSub);
                    continue;
                }
                analyzed.add(pathSub);
            }
            result = result.stream().filter(e -> !analyzed.stream().anyMatch(e::startsWith)).collect(Collectors.toSet());
        }
        return new TreeSet<String>(result);
    }

    public static Set<String> selectDeepestLevelPaths(Collection<?> paths) {
        return SOSPathUtils.selectDeepestLevelPaths(paths, null);
    }

    public static Set<String> selectDeepestLevelPaths(Collection<?> paths, String pathSeparator) {
        if (SOSCollection.isEmpty(paths)) {
            return new TreeSet<String>();
        }
        String ps = SOSPathUtils.getPathSeparator(paths, pathSeparator);
        Set normalized = paths.stream().map(e -> SOSPathUtils.getDirectoryWithoutTrailingSeparator(e.toString(), ps)).collect(Collectors.toSet());
        return normalized.stream().map(Object::toString).sorted(Comparator.comparingInt(String::length).reversed()).filter(path -> normalized.stream().map(Object::toString).noneMatch(other -> other.startsWith(path + ps) && !other.equals(path))).collect(Collectors.toCollection(TreeSet::new));
    }

    public static boolean isUnixStylePathSeparator(String pathSeparator) {
        return PATH_SEPARATOR_UNIX.equals(pathSeparator);
    }

    public static String getPathSeparator(String path) {
        if (SOSString.isEmpty(path)) {
            return PATH_SEPARATOR_UNIX;
        }
        if (path.contains(PATH_SEPARATOR_WINDOWS)) {
            return PATH_SEPARATOR_WINDOWS;
        }
        return PATH_SEPARATOR_UNIX;
    }

    public static String normalize(String path) {
        return SOSPathUtils.normalize(path, null);
    }

    public static String normalize(String path, String pathSeparator) {
        if (SOSString.isEmpty(path) || !path.contains("..") && !path.contains(".")) {
            return path;
        }
        String ps = SOSPathUtils.getPathSeparator(path, pathSeparator);
        if (path.contains(":")) {
            if (SOSPathUtils.isAbsoluteWindowsOpenSSHPath(path)) {
                String n = ps + Path.of(path.substring(1), new String[0]).normalize().toString();
                return SOSPathUtils.toUnixStyle(n);
            }
            if (SOSPathUtils.isAbsoluteURIPath(path)) {
                try {
                    return new URI(null, path, null).normalize().toString();
                }
                catch (URISyntaxException e) {
                    return path;
                }
            }
            String n = Path.of(path, new String[0]).normalize().toString();
            return SOSPathUtils.isUnixStylePathSeparator(ps) ? SOSPathUtils.toUnixStyle(n) : SOSPathUtils.toWindowsStyle(n);
        }
        String n = Path.of(path, new String[0]).normalize().toString();
        return SOSPathUtils.isUnixStylePathSeparator(ps) ? SOSPathUtils.toUnixStyle(n) : SOSPathUtils.toWindowsStyle(n);
    }

    private static String getPathSeparator(String path, String pathSeparator) {
        if (pathSeparator != null) {
            return pathSeparator;
        }
        return path.contains(PATH_SEPARATOR_UNIX) ? PATH_SEPARATOR_UNIX : PATH_SEPARATOR_WINDOWS;
    }

    private static String getDirectoryWithoutTrailingSeparator(String path, String pathSeparator) {
        if (path == null) {
            return null;
        }
        return SOSString.trimEnd(path, pathSeparator);
    }

    private static String getPathSeparator(Collection<?> paths, String pathSeparator) {
        if (pathSeparator == null) {
            return SOSPathUtils.getPathSeparator(paths.iterator().next().toString());
        }
        return pathSeparator;
    }
}

