/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.arguments.base;

import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class SOSArgument<T> {
    private final String name;
    private boolean required;
    private T defaultValue;
    private DisplayMode displayMode;
    private Boolean dirty;
    private T value;
    private Object payload;
    private Type clazzType;

    public SOSArgument(String name, boolean required) {
        this(name, required, null, DisplayMode.UNMASKED);
    }

    public SOSArgument(String name, boolean required, T defaultValue) {
        this(name, required, defaultValue, DisplayMode.UNMASKED);
    }

    public SOSArgument(String name, boolean required, DisplayMode displayMode) {
        this(name, required, null, displayMode);
    }

    public SOSArgument(SOSArgument<T> arg) {
        this(arg.getName(), arg.isRequired(), arg.getDefaultValue(), arg.getDisplayMode());
    }

    public SOSArgument(String name, boolean required, T defaultValue, DisplayMode displayMode) {
        this.name = name;
        this.required = required;
        this.defaultValue = defaultValue;
        this.displayMode = displayMode;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean val) {
        this.required = val;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(T val) {
        this.defaultValue = val;
    }

    public T getValue() {
        if (this.value == null) {
            return this.defaultValue;
        }
        return this.value;
    }

    public void setValue(T val) {
        this.value = val;
        this.setIsDirty();
    }

    public void applyValue(Object val) {
        this.setValue(val);
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(DisplayMode val) {
        this.displayMode = val;
    }

    public String getDisplayValue() {
        return SOSArgumentHelper.getDisplayValue(this.value, this.displayMode);
    }

    public String getDisplayValueIgnoreUnknown() {
        return SOSArgumentHelper.getDisplayValueIgnoreUnknown(this.value, this.displayMode);
    }

    public boolean isDirty() {
        if (this.dirty == null) {
            this.setIsDirty();
        }
        return this.dirty;
    }

    public void setIsDirty(boolean val) {
        this.dirty = val;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(String val) {
        this.payload = val;
    }

    public boolean isEmpty() {
        if (this.value == null) {
            return true;
        }
        if (this.value instanceof String) {
            return ((String)this.value).isEmpty();
        }
        if (this.value instanceof List) {
            return ((List)this.value).isEmpty();
        }
        if (this.value instanceof Map) {
            return ((Map)this.value).isEmpty();
        }
        if (this.value.getClass().isArray()) {
            return Array.getLength(this.value) == 0;
        }
        return false;
    }

    public boolean isTrue() {
        return this.value != null && this.value instanceof Boolean && (Boolean)this.value != false;
    }

    public void setClazzType(Type val) {
        this.clazzType = val;
    }

    public void setClazzType(Object value) {
        if (value == null) {
            return;
        }
        this.clazzType = value.getClass();
        Type superClass = value.getClass().getGenericSuperclass();
        if (superClass instanceof ParameterizedType) {
            this.clazzType = superClass;
        }
    }

    public Type getClazzType() {
        return this.clazzType;
    }

    private void setIsDirty() {
        if (this.value == null) {
            this.dirty = this.defaultValue != null;
            return;
        }
        if (this.defaultValue == null) {
            this.dirty = true;
            return;
        }
        this.dirty = !this.value.equals(this.defaultValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("[");
        sb.append("value=").append(this.getDisplayValue());
        sb.append(" modified=").append(this.isDirty());
        sb.append("]");
        return sb.toString();
    }

    public static enum DisplayMode {
        NONE("<...>"),
        MASKED("********"),
        UNMASKED,
        UNKNOWN("<hidden>");

        private final String value;

        private DisplayMode() {
            this(null);
        }

        private DisplayMode(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }
    }
}

