/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.loggers.impl;

import com.sos.commons.util.loggers.base.ISOSLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLogger
implements ISOSLogger {
    private final String fqcn;
    private final Logger logger;
    private final LocationAwareLogger locationAwareLogger;
    private final boolean isDebugEnabled;
    private final boolean isTraceEnabled;

    public SLF4JLogger() {
        this(LoggerFactory.getLogger(SLF4JLogger.class), SLF4JLogger.class);
    }

    public SLF4JLogger(Class<?> fqcnClazz) {
        this(LoggerFactory.getLogger(SLF4JLogger.class), fqcnClazz);
    }

    public SLF4JLogger(Logger logger) {
        this(logger, SLF4JLogger.class);
    }

    public SLF4JLogger(Logger logger, Class<?> fqcnClazz) {
        this.fqcn = fqcnClazz == null ? SLF4JLogger.class.getName() : fqcnClazz.getName();
        this.logger = logger;
        this.isDebugEnabled = logger.isDebugEnabled();
        this.isTraceEnabled = logger.isTraceEnabled();
        this.locationAwareLogger = logger instanceof LocationAwareLogger ? (LocationAwareLogger)logger : null;
    }

    @Override
    public void info(Object msg) {
        this.log(20, String.valueOf(msg), null);
    }

    @Override
    public void info(String format, Object ... args) {
        this.log(20, format, args);
    }

    @Override
    public void debug(Object msg) {
        if (!this.isDebugEnabled) {
            return;
        }
        this.log(10, String.valueOf(msg), null);
    }

    @Override
    public void debug(String format, Object ... args) {
        if (!this.isDebugEnabled) {
            return;
        }
        this.log(10, format, args);
    }

    @Override
    public void trace(Object msg) {
        if (!this.isTraceEnabled) {
            return;
        }
        this.log(0, String.valueOf(msg), null);
    }

    @Override
    public void trace(String format, Object ... args) {
        if (!this.isTraceEnabled) {
            return;
        }
        this.log(0, format, args);
    }

    @Override
    public void warn(Object msg) {
        this.log(30, String.valueOf(msg), null);
    }

    @Override
    public void warn(String format, Object ... args) {
        this.log(30, format, args);
    }

    @Override
    public void warn(String msg, Throwable e) {
        this.log(30, msg, null, e);
    }

    @Override
    public void error(Object msg) {
        this.log(40, String.valueOf(msg), null);
    }

    @Override
    public void error(String format, Object ... args) {
        this.log(40, format, args);
    }

    @Override
    public void error(String msg, Throwable e) {
        this.log(40, msg, null, e);
    }

    @Override
    public void error(Throwable e) {
        this.log(40, e.toString(), null, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    private void log(int level, String msg, Object[] args) {
        this.log(level, msg, args, null);
    }

    private void log(int level, String msg, Object[] args, Throwable t) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, this.fqcn, level, this.format(msg, args), null, t);
        } else {
            switch (level) {
                case 0: {
                    if (t != null) {
                        this.logger.trace(this.format(msg, args), t);
                        break;
                    }
                    this.logger.trace(this.format(msg, args));
                    break;
                }
                case 10: {
                    if (t != null) {
                        this.logger.debug(this.format(msg, args), t);
                        break;
                    }
                    this.logger.debug(this.format(msg, args));
                    break;
                }
                case 20: {
                    if (t != null) {
                        this.logger.info(this.format(msg, args), t);
                        break;
                    }
                    this.logger.info(this.format(msg, args));
                    break;
                }
                case 30: {
                    if (t != null) {
                        this.logger.warn(this.format(msg, args), t);
                        break;
                    }
                    this.logger.warn(this.format(msg, args));
                    break;
                }
                case 40: {
                    if (t != null) {
                        this.logger.error(this.format(msg, args), t);
                        break;
                    }
                    this.logger.error(this.format(msg, args));
                }
            }
        }
    }

    private String format(String format, Object[] args) {
        if (args == null || args.length == 0) {
            return format;
        }
        try {
            return String.format(format, args);
        }
        catch (Exception e) {
            return "[" + SLF4JLogger.class.getSimpleName() + "][" + format + "]" + e.getMessage();
        }
    }
}

