/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.proxy.http;

import com.sos.commons.util.proxy.ProxyConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Base64;
import org.apache.commons.io.IOUtils;

public class HttpProxySocket
extends Socket {
    private final ProxyConfig config;

    public HttpProxySocket(ProxyConfig config) throws UnknownHostException, IOException {
        this.config = config;
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        super.connect(this.config.getProxy().address(), this.config.getConnectTimeoutAsMillis());
        String basicAuth = null;
        if (this.config.hasUserAndPassword()) {
            basicAuth = new String(Base64.getEncoder().encode(new String(this.config.getUser() + ":" + this.config.getPassword()).getBytes()));
        }
        InetSocketAddress address = (InetSocketAddress)endpoint;
        OutputStream out = this.getOutputStream();
        IOUtils.write((String)String.format("CONNECT %s:%s HTTP/1.0\r\n", address.getHostName(), address.getPort()), (OutputStream)out, (Charset)this.config.getCharset());
        if (basicAuth != null) {
            IOUtils.write((String)"Proxy-Authorization: Basic ", (OutputStream)out, (Charset)this.config.getCharset());
            IOUtils.write((String)basicAuth, (OutputStream)out, (Charset)this.config.getCharset());
        }
        IOUtils.write((String)"\r\n", (OutputStream)out, (Charset)this.config.getCharset());
        IOUtils.write((String)"\r\n", (OutputStream)out, (Charset)this.config.getCharset());
        out.flush();
        InputStream in = this.getInputStream();
        String response = new LineNumberReader(new InputStreamReader(in)).readLine();
        if (response == null) {
            throw new SocketException(String.format("[%s]missing response", ((InetSocketAddress)this.config.getProxy().address()).getHostName()));
        }
        if (!response.contains("200")) {
            throw new SocketException(String.format("[%s][invalid response]%s", ((InetSocketAddress)this.config.getProxy().address()).getHostName(), response));
        }
        in.skip(in.available());
    }
}

