/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.xml.transform;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SOSXmlCDataIndentingStreamWriter
implements XMLStreamWriter,
AutoCloseable {
    private static final String NEW_LINE = "\n";
    private final XMLStreamWriter delegate;
    private final String indentStep;
    private final boolean indentEnabled;
    private int depth = 0;
    private boolean newLinePending = false;

    public SOSXmlCDataIndentingStreamWriter(XMLStreamWriter delegate, int indentAmount) {
        this.delegate = delegate;
        this.indentStep = indentAmount > 0 ? " ".repeat(indentAmount) : "";
        this.indentEnabled = indentAmount > 0;
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        if (text != null && !text.isEmpty()) {
            this.delegate.writeCData(text);
            this.newLinePending = false;
        } else {
            this.delegate.writeCharacters(text);
        }
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        if (text != null && len > 0) {
            String s = new String(text, start, len);
            this.delegate.writeCData(s);
            this.newLinePending = false;
        } else {
            this.delegate.writeCharacters(text, start, len);
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeIndent();
        this.delegate.writeStartElement(localName);
        ++this.depth;
        this.newLinePending = true;
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeIndent();
        this.delegate.writeStartElement(namespaceURI, localName);
        ++this.depth;
        this.newLinePending = true;
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeIndent();
        this.delegate.writeStartElement(prefix, localName, namespaceURI);
        ++this.depth;
        this.newLinePending = true;
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeIndent();
        this.delegate.writeEmptyElement(namespaceURI, localName);
        this.newLinePending = true;
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeIndent();
        this.delegate.writeEmptyElement(prefix, localName, namespaceURI);
        this.newLinePending = true;
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeIndent();
        this.delegate.writeEmptyElement(localName);
        this.newLinePending = true;
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        --this.depth;
        if (this.indentEnabled && this.newLinePending) {
            this.writeIndent();
        }
        this.delegate.writeEndElement();
        this.newLinePending = true;
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.delegate.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.delegate.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.delegate.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.delegate.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.delegate.writeComment(data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.delegate.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.delegate.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.delegate.writeEntityRef(name);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.delegate.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.delegate.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.delegate.writeStartDocument(encoding, version);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.delegate.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.delegate.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.delegate.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.delegate.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.delegate.getProperty(name);
    }

    private void writeIndent() throws XMLStreamException {
        if (!this.indentEnabled) {
            return;
        }
        this.delegate.writeCharacters(NEW_LINE);
        for (int i = 0; i < this.depth; ++i) {
            this.delegate.writeCharacters(this.indentStep);
        }
    }
}

