/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.xml.transform;

import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.xml.SOSXML;
import com.sos.commons.xml.exception.SOSXMLException;
import com.sos.commons.xml.transform.SOSXmlCDataIndentingStreamWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class SOSXmlTransformer {
    public static String nodeToString(Node node) throws Exception {
        return SOSXmlTransformer.nodeToString(node, true, 4);
    }

    public static String nodeToString(Node node, boolean omitXmlDeclaration, int indentAmount) throws Exception {
        SOSXML.removeWhitespaceNodes(node);
        Transformer t = SOSXmlTransformer.createTransformer(omitXmlDeclaration, indentAmount);
        try (StringWriter sw = new StringWriter();){
            t.transform(new DOMSource(node), new StreamResult(sw));
            String string = sw.toString().trim();
            return string;
        }
    }

    private static String transformXmlWithXsl(String xmlContent, String xslContent) throws Exception {
        Transformer t = SOSXmlTransformer.newTransformer(xslContent);
        try (StringWriter sw = new StringWriter();){
            t.transform(new StreamSource(new StringReader(xmlContent)), new StreamResult(sw));
            String string = sw.toString().trim();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String transformXmlWithXslEncloseTextInCdata(String xmlContent, String xslContent, boolean omitXmlDeclaration, int indentAmount) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Thread transformThread = null;
        AtomicReference transformExceptionRef = new AtomicReference();
        try (PipedOutputStream pipeOut = new PipedOutputStream();
             PipedInputStream pipeIn = new PipedInputStream(pipeOut);
             OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)baos, "UTF-8");){
            transformThread = new Thread(() -> {
                try {
                    Transformer t = SOSXmlTransformer.newTransformer(xslContent);
                    t.transform(new StreamSource(new StringReader(xmlContent)), new StreamResult(pipeOut));
                }
                catch (Exception e) {
                    transformExceptionRef.set(e);
                }
                finally {
                    SOSClassUtil.closeQuietly((Closeable)pipeOut);
                }
            });
            transformThread.start();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            XMLStreamReader reader = null;
            XMLStreamWriter rawWriter = null;
            try {
                reader = inputFactory.createXMLStreamReader(pipeIn);
                rawWriter = outputFactory.createXMLStreamWriter(osWriter);
                try (SOSXmlCDataIndentingStreamWriter cdataWriter = new SOSXmlCDataIndentingStreamWriter(rawWriter, indentAmount);){
                    if (!omitXmlDeclaration) {
                        osWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    }
                    block35: while (reader.hasNext()) {
                        int event = reader.next();
                        switch (event) {
                            case 1: {
                                int i;
                                cdataWriter.writeStartElement(reader.getPrefix(), reader.getLocalName(), reader.getNamespaceURI());
                                for (i = 0; i < reader.getAttributeCount(); ++i) {
                                    String attrPrefix = reader.getAttributePrefix(i);
                                    if (attrPrefix == null || attrPrefix.isEmpty()) {
                                        cdataWriter.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                                        continue;
                                    }
                                    cdataWriter.writeAttribute(attrPrefix, reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                                }
                                for (i = 0; i < reader.getNamespaceCount(); ++i) {
                                    String prefix = reader.getNamespacePrefix(i);
                                    String nsUri = reader.getNamespaceURI(i);
                                    if (prefix == null) {
                                        cdataWriter.writeDefaultNamespace(nsUri);
                                        continue;
                                    }
                                    cdataWriter.writeNamespace(prefix, nsUri);
                                }
                                continue block35;
                            }
                            case 4: {
                                if (reader.isWhiteSpace()) break;
                                cdataWriter.writeCharacters(reader.getText());
                                break;
                            }
                            case 2: {
                                cdataWriter.writeEndElement();
                                break;
                            }
                            case 12: {
                                cdataWriter.writeCData(reader.getText());
                                break;
                            }
                            case 5: {
                                cdataWriter.writeComment(reader.getText());
                                break;
                            }
                        }
                    }
                    if (!omitXmlDeclaration) {
                        cdataWriter.writeEndDocument();
                    }
                    cdataWriter.flush();
                }
            }
            catch (Throwable throwable) {
                SOSXmlTransformer.closeQuietly(reader);
                SOSXmlTransformer.closeQuietly(rawWriter);
                throw throwable;
            }
            SOSXmlTransformer.closeQuietly(reader);
            SOSXmlTransformer.closeQuietly(rawWriter);
        }
        catch (Throwable throwable) {
            try {
                Exception transformException;
                if (transformThread != null) {
                    transformThread.join();
                }
                if ((transformException = (Exception)transformExceptionRef.get()) != null) {
                    throw new SOSXMLException(transformException.getCause() == null ? transformException : transformException.getCause());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
        try {
            Exception transformException;
            if (transformThread != null) {
                transformThread.join();
            }
            if ((transformException = (Exception)transformExceptionRef.get()) != null) {
                throw new SOSXMLException(transformException.getCause() == null ? transformException : transformException.getCause());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return baos.toString("UTF-8").trim();
    }

    public static Transformer createTransformer(boolean omitXmlDeclaration, int indentAmount) throws Exception {
        Transformer t = SOSXmlTransformer.newTransformer(null);
        t.setOutputProperty("omit-xml-declaration", omitXmlDeclaration ? "yes" : "no");
        if (indentAmount > 0) {
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", String.valueOf(indentAmount));
        } else {
            t.setOutputProperty("indent", "no");
        }
        return t;
    }

    private static Transformer newTransformer(String content) throws TransformerConfigurationException {
        TransformerFactory f = TransformerFactory.newInstance();
        return content == null ? f.newTransformer() : f.newTransformer(new StreamSource(new StringReader(content)));
    }

    private static void closeQuietly(XMLStreamReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }

    private static void closeQuietly(XMLStreamWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }
}

