#! /bin/sh
# Purpose : Anonymize log files
# Date    : 2025-04-14


JS7_YADE_BINDIR="$(dirname "$0")"
JS7_YADE_LIBDIR="$(cd "${JS7_YADE_BINDIR}/../lib" >/dev/null && pwd)"

RETURN_CODE=0
JAVA_BIN="${JAVA_HOME}/bin/java"
test -x "${JAVA_BIN}" || JAVA_BIN="java"

# set_classpath
CP="${JS7_YADE_LIBDIR}/stdout:${JS7_YADE_LIBDIR}/patches/*:${JS7_YADE_LIBDIR}/user_lib/*:${JS7_YADE_LIBDIR}/3rd-party/*:${JS7_YADE_LIBDIR}/sos/*"

echo "... executing"
"${JAVA_BIN}" ${JAVA_OPTIONS} -classpath "${CP}" com.sos.loganonymizer.SOSLogAnonymizer $*
RETURN_CODE=$?
echo "... done"

exit $RETURN_CODE
