/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.azure;

import com.sos.commons.exception.SOSNoSuchFileException;
import com.sos.commons.exception.SOSRequiredArgumentMissingException;
import com.sos.commons.httpclient.azure.AzureBlobStorageClient;
import com.sos.commons.httpclient.azure.commons.AzureBlobStorageOutputStream;
import com.sos.commons.httpclient.azure.commons.auth.AAzureStorageAuthProvider;
import com.sos.commons.httpclient.azure.commons.auth.blob.AzureBlobPublicAuthProvider;
import com.sos.commons.httpclient.azure.commons.auth.blob.AzureBlobSASAuthProvider;
import com.sos.commons.httpclient.azure.commons.auth.blob.AzureBlobSharedKeyAuthProvider;
import com.sos.commons.httpclient.azure.commons.auth.blob.AzureBlobStorageClientAuthMethod;
import com.sos.commons.httpclient.commons.HttpExecutionResult;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.azure.commons.AzureBlobStorageProviderArguments;
import com.sos.commons.vfs.azure.commons.AzureBlobStorageProviderUtils;
import com.sos.commons.vfs.azure.commons.AzureBlobStorageResource;
import com.sos.commons.vfs.commons.AProvider;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.exceptions.ProviderClientNotInitializedException;
import com.sos.commons.vfs.exceptions.ProviderConnectException;
import com.sos.commons.vfs.exceptions.ProviderException;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class AzureBlobStorageProvider
extends AProvider<AzureBlobStorageProviderArguments> {
    private AzureBlobStorageClient client;
    private String containerName;

    public AzureBlobStorageProvider(ISOSLogger logger, AzureBlobStorageProviderArguments args) throws ProviderInitializationException {
        super(logger, args, args == null ? null : args.getAccountKey(), args == null ? null : args.getSASToken());
        try {
            ((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getServiceEndpoint().setValue((Object)((String)((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getHost().getValue()));
            this.setAccessInfo(((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getAccessInfo());
        }
        catch (Exception e) {
            throw new ProviderInitializationException(e);
        }
    }

    @Override
    public String getPathSeparator() {
        return "/";
    }

    @Override
    public boolean isAbsolutePath(String path) {
        return SOSPathUtils.isAbsoluteURIPath((String)path);
    }

    @Override
    public String normalizePath(String path) {
        if (SOSString.isEmpty((String)path)) {
            return path;
        }
        String containerName = this.getContainerName(path);
        String blobPath = this.getBlobPath(path, containerName);
        Object p = containerName;
        if (!SOSString.isEmpty((String)blobPath)) {
            p = (String)p + this.getPathSeparator() + blobPath;
        }
        return p;
    }

    @Override
    public void connect() throws ProviderConnectException {
        if (SOSString.isEmpty((String)((String)((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getServiceEndpoint().getValue()))) {
            throw new ProviderConnectException((Throwable)new SOSRequiredArgumentMissingException("ServiceEndpoint"));
        }
        try {
            AzureBlobStorageClient.Builder builder = AzureBlobStorageClient.withBuilder();
            builder = (AzureBlobStorageClient.Builder)builder.withLogger(this.getLogger());
            builder = (AzureBlobStorageClient.Builder)builder.withConnectTimeout(Duration.ofSeconds(((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getConnectTimeoutAsSeconds()));
            builder = (AzureBlobStorageClient.Builder)builder.withHeaders((List)((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getHttpHeaders().getValue());
            builder = (AzureBlobStorageClient.Builder)builder.withProxyConfig(this.getProxyConfig());
            builder = (AzureBlobStorageClient.Builder)builder.withSSL(((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getSsl());
            builder = builder.withServiceEndpoint((String)((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getServiceEndpoint().getValue());
            String accountName = (String)((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getUser().getValue();
            String accountKey = (String)((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getAccountKey().getValue();
            String apiVersion = (String)((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getApiVersion().getValue();
            switch ((AzureBlobStorageClientAuthMethod)((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getAuthMethod().getValue()) {
                case SAS_TOKEN: {
                    builder = builder.withAuthProvider((AAzureStorageAuthProvider)new AzureBlobSASAuthProvider(this.getLogger(), accountName, accountKey, apiVersion, (String)((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getSASToken().getValue()));
                    break;
                }
                case SHARED_KEY: {
                    builder = builder.withAuthProvider((AAzureStorageAuthProvider)new AzureBlobSharedKeyAuthProvider(this.getLogger(), accountName, accountKey, apiVersion));
                    break;
                }
                default: {
                    builder = builder.withAuthProvider((AAzureStorageAuthProvider)new AzureBlobPublicAuthProvider(this.getLogger(), accountName, accountKey, apiVersion));
                }
            }
            this.logIfHostnameVerificationDisabled(((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getSsl());
            this.client = (AzureBlobStorageClient)builder.build();
            this.getLogger().info((Object)this.getConnectMsg());
            HttpExecutionResult result = this.client.executeGETStorage();
            result.formatWithResponseBody(true);
            int code = result.response().statusCode();
            if (!(HttpUtils.isSuccessful((int)code) || HttpUtils.isForbidden((int)code) || HttpUtils.isNotFound((int)code) && this.client.getAuthProvider().isPublic())) {
                throw new IOException(this.client.formatExecutionResultForException(result));
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("%s[connected]%s", new Object[]{this.getLogPrefix(), AzureBlobStorageClient.formatExecutionResult((HttpExecutionResult)result)});
            }
            this.getLogger().info((Object)this.getConnectedMsg());
        }
        catch (Throwable e) {
            this.disconnect();
            throw new ProviderConnectException(String.format("[%s]", this.getAccessInfo()), e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.client != null;
    }

    @Override
    public void disconnect() {
        if (this.client == null) {
            return;
        }
        SOSClassUtil.closeQuietly((AutoCloseable)this.client);
        this.client = null;
        this.getLogger().info((Object)this.getDisconnectedMsg());
    }

    @Override
    public List<ProviderFile> selectFiles(ProviderFileSelection selection) throws ProviderException {
        this.validatePrerequisites("selectFiles");
        selection = ProviderFileSelection.createIfNull(selection);
        String directory = selection.getConfig().getDirectory() == null ? "" : selection.getConfig().getDirectory();
        try {
            String containerName = this.getContainerName(directory);
            String blobPath = this.getBlobFilePath(directory, containerName);
            ArrayList<ProviderFile> result = new ArrayList<ProviderFile>();
            AzureBlobStorageProviderUtils.selectFiles(this, selection, containerName, blobPath, result);
            return result;
        }
        catch (Exception e) {
            throw new ProviderException(this.getPathOperationPrefix(directory), e);
        }
    }

    @Override
    public boolean exists(String path) throws ProviderException {
        this.validatePrerequisites("exists", path, "path");
        try {
            String containerName = this.getContainerName(path);
            String blobPath = this.getBlobFilePath(path, containerName);
            HttpExecutionResult result = this.client.executeHEADBlob(containerName, blobPath);
            result.formatWithResponseBody(true);
            int code = result.response().statusCode();
            if (!HttpUtils.isSuccessful((int)code)) {
                if (HttpUtils.isNotFound((int)code)) {
                    return false;
                }
                throw new IOException(this.client.formatExecutionResultForException(result));
            }
            return true;
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean createDirectoriesIfNotExists(String path) throws ProviderException {
        return true;
    }

    @Override
    public boolean deleteIfExists(String path) throws ProviderException {
        this.validatePrerequisites("deleteIfExists", path, "path");
        try {
            String containerName = this.getContainerName(path);
            String blobPath = this.getBlobFilePath(path, containerName);
            return this.deleteIfExists(path, containerName, blobPath);
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean deleteFileIfExists(String path) throws ProviderException {
        return this.deleteIfExists(path);
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean renameFileIfSourceExists(String source, String target) throws ProviderException {
        this.validatePrerequisites("renameFileIfSourceExists", source, "source");
        this.validateArgument("renameFileIfSourceExists", target, "target");
        InputStream is = null;
        try {
            String sourceContainerName = this.getContainerName(source);
            String sourceBlobPath = this.getBlobFilePath(source, sourceContainerName);
            String targetContainerName = sourceContainerName;
            String targetBlobPath = this.getBlobFilePath(target, targetContainerName);
            HttpExecutionResult resultSource = this.client.executeHEADBlob(sourceContainerName, sourceBlobPath);
            resultSource.formatWithResponseBody(true);
            int code = resultSource.response().statusCode();
            if (!HttpUtils.isSuccessful((int)code)) {
                throw new IOException(this.client.formatExecutionResultForException(resultSource));
            }
            long sourceSize = this.client.getFileSize(resultSource.response());
            is = this.getInputStream(source, sourceContainerName, sourceBlobPath);
            this.deleteIfExists(target, targetContainerName, targetBlobPath);
            Long targetFileSize = this.upload(sourceBlobPath, targetContainerName, targetBlobPath, is, sourceSize);
            this.deleteIfExists(source, sourceContainerName, sourceBlobPath);
            boolean bl = true;
            SOSClassUtil.closeQuietly((Closeable)is);
            return bl;
        }
        catch (SOSNoSuchFileException e) {
            boolean bl = false;
            return bl;
        }
        catch (Throwable e2) {
            throw new ProviderException(this.getPathOperationPrefix(source + "->" + target), e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            SOSClassUtil.closeQuietly(is);
        }
    }

    @Override
    public ProviderFile getFileIfExists(String path) throws ProviderException {
        this.validatePrerequisites("getFileIfExists", path, "path");
        try {
            String containerName = this.getContainerName(path);
            String blobPath = this.getBlobFilePath(path, containerName);
            return this.createProviderFile(AzureBlobStorageProviderUtils.getResource(this, containerName, blobPath, false, false));
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public String getFileContentIfExists(String path) throws ProviderException {
        this.validatePrerequisites("getFileContentIfExists", path, "path");
        try {
            String containerName = this.getContainerName(path);
            String blobPath = this.getBlobFilePath(path, containerName);
            HttpExecutionResult result = this.client.executeGETBlobContent(containerName, blobPath);
            result.formatWithResponseBody(true);
            int code = result.response().statusCode();
            if (!HttpUtils.isSuccessful((int)code)) {
                if (HttpUtils.isNotFound((int)code)) {
                    return null;
                }
                throw new Exception(this.client.formatExecutionResultForException(result));
            }
            return (String)result.response().body();
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public void writeFile(String path, String content) throws ProviderException {
        this.validatePrerequisites("uploadContent", path, "path");
        try {
            String containerName = this.getContainerName(path);
            String blobPath = this.getBlobFilePath(path, containerName);
            HttpExecutionResult result = this.client.executePUTBlob(containerName, blobPath, content.getBytes(StandardCharsets.UTF_8), "application/octet-stream");
            result.formatWithResponseBody(true);
            int code = result.response().statusCode();
            if (!HttpUtils.isSuccessful((int)code)) {
                throw new Exception(this.client.formatExecutionResultForException(result));
            }
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public void setFileLastModifiedFromMillis(String path, long milliseconds) throws ProviderException {
        this.logNotImpementedMethod("setFileLastModifiedFromMillis", "path=" + path + ",milliseconds=" + milliseconds);
    }

    @Override
    public InputStream getInputStream(String path) throws ProviderException {
        this.validatePrerequisites("getInputStream", path, "path");
        try {
            String containerName = this.getContainerName(path);
            String blobPath = this.getBlobFilePath(path, containerName);
            return this.getInputStream(path, containerName, blobPath);
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public OutputStream getOutputStream(String path, boolean append) throws ProviderException {
        this.validatePrerequisites("getOutputStream", path, "path");
        try {
            String containerName = this.getContainerName(path);
            String blobPath = this.getBlobFilePath(path, containerName);
            return new AzureBlobStorageOutputStream(this.client, containerName, blobPath);
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    public long upload(String path, InputStream source, long sourceSize) throws ProviderException {
        this.validatePrerequisites("upload", path, "path");
        this.validateArgument("upload", source, "InputStream source");
        try {
            String containerName = this.getContainerName(path);
            String blobPath = this.getBlobFilePath(path, containerName);
            return this.upload(path, containerName, blobPath, source, sourceSize);
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public void validatePrerequisites(String method) throws ProviderException {
        if (this.client == null) {
            throw new ProviderClientNotInitializedException(this.getLogPrefix() + method + "HTTPPClient");
        }
    }

    public void validatePrerequisites(String method, String argValue, String msg) throws ProviderException {
        this.validatePrerequisites(method);
        this.validateArgument(method, argValue, msg);
    }

    public AzureBlobStorageClient getClient() {
        return this.client;
    }

    public ProviderFile createProviderFile(AzureBlobStorageResource resource) throws Exception {
        if (resource == null) {
            return null;
        }
        if (resource.getSize() < 0L) {
            return null;
        }
        return this.createProviderFile(resource.getFullPath(), resource.getSize(), resource.getLastModifiedInMillis());
    }

    private String getContainerName(String path) {
        if (this.containerName == null) {
            if (!((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getContainerName().isEmpty()) {
                this.containerName = (String)((AzureBlobStorageProviderArguments)((Object)this.getArguments())).getContainerName().getValue();
            } else if (SOSString.isEmpty((String)path)) {
                this.containerName = "";
            } else {
                String[] pathParts = path.replaceAll("^[/\\\\]+", "").split("[/\\\\]", 2);
                this.containerName = pathParts[0];
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("%s[containerName]%s", new Object[]{this.getLogPrefix(), this.containerName});
            }
        }
        return this.containerName;
    }

    private String getBlobFilePath(String path, String containerName) {
        String blobPath = this.getBlobPath(path, containerName);
        if (SOSString.isEmpty((String)blobPath)) {
            return blobPath;
        }
        return SOSString.trimEnd((String)blobPath, (String[])new String[]{this.getPathSeparator()});
    }

    private String getBlobPath(String path, String containerName) {
        String blobPath = this.toPathStyle(path);
        if (SOSString.isEmpty((String)blobPath)) {
            return "";
        }
        blobPath = SOSString.trimStart((String)blobPath, (String[])new String[]{this.getPathSeparator()});
        if (!SOSString.isEmpty((String)containerName)) {
            if (containerName.equalsIgnoreCase(blobPath)) {
                return "";
            }
            int containerIndex = blobPath.indexOf(containerName + this.getPathSeparator());
            if (containerIndex != -1) {
                blobPath = blobPath.substring(containerIndex + containerName.length() + 1);
            }
        }
        return blobPath;
    }

    private boolean deleteIfExists(String path, String containerName, String blobPath) throws Exception {
        HttpExecutionResult result = this.client.executeDELETEBlob(containerName, blobPath);
        result.formatWithResponseBody(true);
        int code = result.response().statusCode();
        if (!HttpUtils.isSuccessful((int)code)) {
            if (HttpUtils.isNotFound((int)code)) {
                return false;
            }
            throw new IOException(this.client.formatExecutionResultForException(result));
        }
        return true;
    }

    private InputStream getInputStream(String path, String containerName, String blobPath) throws Exception {
        HttpExecutionResult result = this.client.executeGETBlobInputStream(containerName, blobPath);
        result.formatWithResponseBody(true);
        int code = result.response().statusCode();
        if (!HttpUtils.isSuccessful((int)code)) {
            if (HttpUtils.isNotFound((int)code)) {
                throw new SOSNoSuchFileException(path, (Throwable)new Exception(this.client.formatExecutionResultForException(result)));
            }
            throw new Exception(this.client.formatExecutionResultForException(result));
        }
        return (InputStream)result.response().body();
    }

    private long upload(String path, String targetContainerName, String targetBlobPath, InputStream source, long sourceSize) throws Exception {
        HttpExecutionResult resultExists;
        HttpExecutionResult result = this.client.executePUTBlob(targetContainerName, targetBlobPath, source, "application/octet-stream");
        result.formatWithResponseBody(true);
        int code = result.response().statusCode();
        if (!HttpUtils.isSuccessful((int)code)) {
            throw new Exception(this.client.formatExecutionResultForException(result));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("%s[upload]%s", new Object[]{this.getLogPrefix(), AzureBlobStorageClient.formatExecutionResult((HttpExecutionResult)result)});
        }
        if (!HttpUtils.isSuccessful((int)(code = (resultExists = this.client.executeHEADBlob(targetContainerName, targetBlobPath)).response().statusCode()))) {
            throw new IOException(this.client.formatExecutionResultForException(resultExists));
        }
        return this.client.getFileSize(resultExists.response());
    }
}

