/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ftp.commons;

import com.sos.commons.util.SOSCollection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FTPProtocolReply {
    private final int code;
    private final String text;

    public FTPProtocolReply(FTPClient client) {
        this.code = client.getReplyCode();
        this.text = this.getText(client);
    }

    public boolean isSystemStatusReply() {
        return this.code == 211;
    }

    public boolean isFileStatusReply() {
        return this.code == 213;
    }

    public boolean isFileUnavailableReply() {
        return this.code == 550;
    }

    public boolean isPositiveReply() {
        return FTPReply.isPositiveCompletion((int)this.code);
    }

    public int getCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return "[" + this.code + "]" + this.text;
    }

    private String getText(FTPClient client) {
        Object[] replies = client.getReplyStrings();
        if (SOSCollection.isEmpty((Object[])replies)) {
            return "";
        }
        return IntStream.range(0, replies.length).mapToObj(arg_0 -> FTPProtocolReply.lambda$getText$0((String[])replies, arg_0)).collect(Collectors.joining(""));
    }

    private static /* synthetic */ String lambda$getText$0(String[] replies, int i) {
        return i < replies.length - 1 ? "[" + replies[i].trim() + "]" : replies[i].trim();
    }
}

