/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ftp.commons;

import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.ssl.SslArguments;
import com.sos.commons.util.ssl.SslContextFactory;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.commons.vfs.ftp.commons.FTPProviderArguments;
import com.sos.commons.vfs.ftp.commons.FTPSSecurityMode;

public class FTPSProviderArguments
extends FTPProviderArguments {
    private SslArguments ssl;
    private SOSArgument<FTPSSecurityMode> securityMode = new SOSArgument("security_mode", false, (Object)FTPSSecurityMode.EXPLICIT);

    public FTPSProviderArguments() {
        super(null);
        this.getProtocol().setValue((Object)AProviderArguments.Protocol.FTPS);
    }

    public SslArguments getSsl() {
        if (this.ssl == null) {
            this.ssl = new SslArguments();
            this.ssl.applyDefaultIfNullQuietly();
        }
        return this.ssl;
    }

    public void setSSL(SslArguments val) {
        this.ssl = val;
    }

    @Override
    public SOSArgument<Integer> getPort() {
        if (super.getPort().isEmpty()) {
            super.getPort().setValue((Object)(this.isSecurityModeImplicit() ? Integer.valueOf(990) : Integer.valueOf(21)));
        }
        return super.getPort();
    }

    @Override
    public String getAccessInfo() throws ProviderInitializationException {
        StringBuilder ftpsInfo = new StringBuilder();
        ftpsInfo.append("TLS");
        CharSequence[] sslEnabledPrtocols = SslContextFactory.getFilteredEnabledProtocols((SslArguments)this.getSsl());
        if (sslEnabledPrtocols.length > 0) {
            ftpsInfo.append("(").append(String.join((CharSequence)", ", sslEnabledPrtocols)).append(")");
        }
        ftpsInfo.append(" ").append(this.getSecurityModeValue());
        return String.format("%s %s", super.getAccessInfo(), ftpsInfo);
    }

    @Override
    public String getAdvancedAccessInfo() {
        return this.getSsl().getTrustedSslInfo();
    }

    public boolean isSecurityModeImplicit() {
        return FTPSSecurityMode.IMPLICIT.equals(this.securityMode.getValue());
    }

    public SOSArgument<FTPSSecurityMode> getSecurityMode() {
        return this.securityMode;
    }

    public String getSecurityModeValue() {
        return this.securityMode.getValue() == null ? null : ((FTPSSecurityMode)((Object)this.securityMode.getValue())).name().toLowerCase();
    }
}

