/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.http;

import com.sos.commons.exception.SOSNoSuchFileException;
import com.sos.commons.exception.SOSRequiredArgumentMissingException;
import com.sos.commons.httpclient.BaseHttpClient;
import com.sos.commons.httpclient.commons.HttpExecutionResult;
import com.sos.commons.httpclient.commons.HttpOutputStream;
import com.sos.commons.httpclient.commons.auth.HttpClientAuthConfig;
import com.sos.commons.httpclient.commons.auth.HttpClientAuthMethod;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.AProvider;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.exceptions.ProviderClientNotInitializedException;
import com.sos.commons.vfs.exceptions.ProviderConnectException;
import com.sos.commons.vfs.exceptions.ProviderException;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.commons.vfs.http.commons.HTTPProviderArguments;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collections;
import java.util.List;

public class HTTPProvider
extends AProvider<HTTPProviderArguments> {
    private BaseHttpClient client;

    public HTTPProvider(ISOSLogger logger, HTTPProviderArguments args) throws ProviderInitializationException {
        super(logger, args, new SOSArgument[0]);
        try {
            this.setAccessInfo(((HTTPProviderArguments)((Object)this.getArguments())).getAccessInfo());
        }
        catch (Exception e) {
            throw new ProviderInitializationException(e);
        }
    }

    @Override
    public String getPathSeparator() {
        return "/";
    }

    @Override
    public boolean isAbsolutePath(String path) {
        return SOSPathUtils.isAbsoluteURIPath((String)path);
    }

    @Override
    public String normalizePath(String path) {
        return HttpUtils.normalizePath((URI)((HTTPProviderArguments)((Object)this.getArguments())).getBaseURI(), (String)path);
    }

    @Override
    public void connect() throws ProviderConnectException {
        if (SOSString.isEmpty((String)((String)((HTTPProviderArguments)((Object)this.getArguments())).getHost().getValue()))) {
            throw new ProviderConnectException((Throwable)new SOSRequiredArgumentMissingException("host"));
        }
        try {
            BaseHttpClient.Builder builder = BaseHttpClient.withBuilder();
            builder = (BaseHttpClient.Builder)builder.withLogger(this.getLogger());
            builder = (BaseHttpClient.Builder)builder.withConnectTimeout(Duration.ofSeconds(((HTTPProviderArguments)((Object)this.getArguments())).getConnectTimeoutAsSeconds()));
            builder = (BaseHttpClient.Builder)builder.withHeaders((List)((HTTPProviderArguments)((Object)this.getArguments())).getHttpHeaders().getValue());
            builder = (BaseHttpClient.Builder)builder.withAuth(this.getAuthConfig());
            builder = (BaseHttpClient.Builder)builder.withProxyConfig(this.getProxyConfig());
            if (this.isSecureConnectionEnabled()) {
                builder = (BaseHttpClient.Builder)builder.withSSL(((HTTPProviderArguments)((Object)this.getArguments())).getSsl());
                this.logIfHostnameVerificationDisabled(((HTTPProviderArguments)((Object)this.getArguments())).getSsl());
            }
            this.client = (BaseHttpClient)builder.build();
            this.getLogger().info((Object)this.getConnectMsg());
            this.connect(((HTTPProviderArguments)((Object)this.getArguments())).getBaseURI());
            this.getLogger().info((Object)this.getConnectedMsg());
        }
        catch (Throwable e) {
            this.disconnect();
            throw new ProviderConnectException(String.format("[%s]", this.getAccessInfo()), e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.client != null;
    }

    @Override
    public void disconnect() {
        if (this.client == null) {
            return;
        }
        SOSClassUtil.closeQuietly((AutoCloseable)this.client);
        this.client = null;
        this.getLogger().info((Object)this.getDisconnectedMsg());
    }

    @Override
    public List<ProviderFile> selectFiles(ProviderFileSelection selection) throws ProviderException {
        throw new ProviderException(this.getPathOperationPrefix(SOSString.toString((Object)selection, Collections.singletonList("result"), (boolean)true)) + "not supported via " + ((HTTPProviderArguments)((Object)this.getArguments())).getProtocol().getValue());
    }

    @Override
    public boolean exists(String path) throws ProviderException {
        this.validatePrerequisites("exists", path, "path");
        URI uri = null;
        try {
            uri = new URI(this.normalizePath(path));
            HttpExecutionResult result = this.client.executeHEADOrGETNoResponseBody(uri);
            int code = result.response().statusCode();
            if (!HttpUtils.isSuccessful((int)code)) {
                if (HttpUtils.isNotFound((int)code)) {
                    return false;
                }
                throw new IOException(BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
            }
            return true;
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(uri == null ? path : uri.toString()), e);
        }
    }

    @Override
    public boolean createDirectoriesIfNotExists(String path) throws ProviderException {
        if (this.exists(SOSPathUtils.getUnixStyleDirectoryWithTrailingSeparator((String)path))) {
            return false;
        }
        throw new ProviderException(this.getPathOperationPrefix(path) + "[does not exist]a directory cannot be created via " + ((HTTPProviderArguments)((Object)this.getArguments())).getProtocol().getValue());
    }

    @Override
    public boolean deleteIfExists(String path) throws ProviderException {
        this.validatePrerequisites("deleteIfExists", path, "path");
        try {
            URI uri = new URI(this.normalizePath(path));
            HttpExecutionResult result = this.client.executeDELETENoResponseBody(uri);
            int code = result.response().statusCode();
            if (!HttpUtils.isSuccessful((int)code)) {
                if (HttpUtils.isNotFound((int)code)) {
                    return false;
                }
                throw new IOException(BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
            }
            return true;
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public boolean deleteFileIfExists(String path) throws ProviderException {
        return this.deleteIfExists(path);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean renameFileIfSourceExists(String source, String target) throws ProviderException {
        this.validatePrerequisites("renameFileIfSourceExists", source, "source");
        this.validateArgument("renameFileIfSourceExists", target, "target");
        InputStream is = null;
        try {
            int code;
            HttpExecutionResult result;
            this.deleteIfExists(target);
            URI sourceURI = new URI(this.normalizePath(source));
            URI targetURI = new URI(this.normalizePath(target));
            long sourceSize = -1L;
            if (!this.client.isChunkedTransfer()) {
                result = this.client.executeHEADOrGETNoResponseBody(sourceURI);
                code = result.response().statusCode();
                if (!HttpUtils.isSuccessful((int)code)) {
                    boolean bl = false;
                    SOSClassUtil.closeQuietly((Closeable)is);
                    return bl;
                }
                sourceSize = this.client.getFileSize(result.response());
            }
            if (!HttpUtils.isSuccessful((int)(code = (result = this.client.executePUTNoResponseBody(targetURI, is = this.client.getHTTPInputStream(sourceURI), sourceSize, false)).response().statusCode()))) {
                if (!HttpUtils.isNotFound((int)code)) throw new IOException(BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
                boolean bl = false;
                SOSClassUtil.closeQuietly((Closeable)is);
                return bl;
            }
            this.deleteIfExists(source);
            boolean bl = true;
            SOSClassUtil.closeQuietly((Closeable)is);
            return bl;
        }
        catch (SOSNoSuchFileException e) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Throwable e2) {
                throw new ProviderException(this.getPathOperationPrefix(source + "->" + target), e2);
            }
        }
        finally {
            SOSClassUtil.closeQuietly(is);
        }
    }

    @Override
    public ProviderFile getFileIfExists(String path) throws ProviderException {
        this.validatePrerequisites("getFileIfExists", path, "path");
        try {
            URI uri = new URI(this.normalizePath(path));
            HttpExecutionResult result = this.client.executeGETNoResponseBody(uri);
            int code = result.response().statusCode();
            if (!HttpUtils.isSuccessful((int)code)) {
                if (HttpUtils.isNotFound((int)code)) {
                    return null;
                }
                throw new IOException(BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
            }
            return this.createProviderFile(uri, result.response());
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getFileContentIfExists(String path) throws ProviderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void writeFile(String path, String content) throws ProviderException {
        this.uploadContent(path, content, false);
    }

    @Override
    public void setFileLastModifiedFromMillis(String path, long milliseconds) throws ProviderException {
        this.logNotImpementedMethod("setFileLastModifiedFromMillis", "path=" + path + ",milliseconds=" + milliseconds);
    }

    @Override
    public InputStream getInputStream(String path) throws ProviderException {
        this.validatePrerequisites("getInputStream", path, "path");
        try {
            return this.client.getHTTPInputStream(new URI(this.normalizePath(path)));
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    @Override
    public OutputStream getOutputStream(String path, boolean append) throws ProviderException {
        this.validatePrerequisites("getOutputStream", path, "path");
        try {
            return new HttpOutputStream(this.client, new URI(this.normalizePath(path)), false);
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    public long upload(String path, InputStream source, long sourceSize) throws ProviderException {
        return this.upload(path, source, sourceSize, false);
    }

    public long upload(String path, InputStream source, long sourceSize, boolean isWebDAV) throws ProviderException {
        this.validatePrerequisites("upload", path, "path");
        this.validateArgument("upload", source, "InputStream source");
        URI uri = null;
        try {
            uri = new URI(this.normalizePath(path));
            HttpExecutionResult result = this.client.executePUTNoResponseBody(uri, source, sourceSize, isWebDAV);
            int code = result.response().statusCode();
            if (!HttpUtils.isSuccessful((int)code)) {
                throw new IOException(BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
            }
            result = this.client.executeHEADOrGETNoResponseBody(uri);
            code = result.response().statusCode();
            if (!HttpUtils.isSuccessful((int)code)) {
                throw new IOException(BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
            }
            return this.client.getFileSize(result.response());
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(uri == null ? path : uri.toString()), e);
        }
    }

    @Override
    public void validatePrerequisites(String method) throws ProviderException {
        if (this.client == null) {
            throw new ProviderClientNotInitializedException(this.getLogPrefix() + method + "HTTPPClient");
        }
    }

    public void uploadContent(String path, String content, boolean isWebDAV) throws ProviderException {
        this.validatePrerequisites("uploadContent", path, "path");
        try {
            URI uri = new URI(this.normalizePath(path));
            HttpExecutionResult result = this.client.executePUTNoResponseBody(uri, content, isWebDAV);
            int code = result.response().statusCode();
            if (!HttpUtils.isSuccessful((int)code)) {
                throw new IOException(BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
            }
        }
        catch (Throwable e) {
            throw new ProviderException(this.getPathOperationPrefix(path), e);
        }
    }

    public BaseHttpClient getClient() {
        return this.client;
    }

    public void validatePrerequisites(String method, String argValue, String msg) throws ProviderException {
        this.validatePrerequisites(method);
        this.validateArgument(method, argValue, msg);
    }

    public boolean isSecureConnectionEnabled() {
        return AProviderArguments.Protocol.HTTPS.equals(((HTTPProviderArguments)((Object)this.getArguments())).getProtocol().getValue()) || AProviderArguments.Protocol.WEBDAVS.equals(((HTTPProviderArguments)((Object)this.getArguments())).getProtocol().getValue());
    }

    private void connect(URI uri) throws Exception {
        String notFoundMsg = null;
        HttpExecutionResult result = this.client.executeHEADOrGETNoResponseBody(uri);
        int code = result.response().statusCode();
        if (HttpUtils.isServerError((int)code)) {
            throw new Exception(BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
        }
        if (HttpUtils.isNotFound((int)code)) {
            notFoundMsg = BaseHttpClient.formatExecutionResult((HttpExecutionResult)result);
        }
        if (notFoundMsg != null) {
            if (SOSString.isEmpty((String)uri.getPath())) {
                throw new Exception(notFoundMsg);
            }
            URI parentURI = HttpUtils.getParentURI((URI)uri);
            if (parentURI == null || parentURI.equals(uri)) {
                throw new Exception(notFoundMsg);
            }
            this.getLogger().info("%s[connect][%s]using parent path %s ...", new Object[]{this.getLogPrefix(), notFoundMsg, parentURI});
            ((HTTPProviderArguments)((Object)this.getArguments())).setBaseURI(parentURI);
            this.setAccessInfo(((HTTPProviderArguments)((Object)this.getArguments())).getAccessInfo());
            this.connect(((HTTPProviderArguments)((Object)this.getArguments())).getBaseURI());
        }
    }

    private ProviderFile createProviderFile(URI uri, HttpResponse<?> response) throws Exception {
        long size = this.client.getFileSize(response);
        if (size < 0L) {
            return null;
        }
        return this.createProviderFile(uri.toString(), size, BaseHttpClient.getLastModifiedInMillis(response));
    }

    private HttpClientAuthConfig getAuthConfig() {
        if (((HTTPProviderArguments)((Object)this.getArguments())).getUser().isEmpty()) {
            ((HTTPProviderArguments)((Object)this.getArguments())).getAuthMethod().setValue((Object)HttpClientAuthMethod.NONE);
            return null;
        }
        return new HttpClientAuthConfig((String)((HTTPProviderArguments)((Object)this.getArguments())).getUser().getValue(), (String)((HTTPProviderArguments)((Object)this.getArguments())).getPassword().getValue());
    }
}

