/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.http.commons;

import com.sos.commons.httpclient.commons.auth.HttpClientAuthMethod;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.util.ssl.SslArguments;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.commons.vfs.http.commons.HTTPProviderUtils;
import java.net.URI;
import java.util.List;

public class HTTPProviderArguments
extends AProviderArguments {
    public static final int DEFAULT_PORT = 80;
    public static final int DEFAULT_CONNECT_TIMEOUT_IN_SECONDS = 30;
    private SslArguments ssl;
    private SOSArgument<HttpClientAuthMethod> authMethod = new SOSArgument("auth_method", false, (Object)HttpClientAuthMethod.NONE);
    private SOSArgument<List<String>> httpHeaders = new SOSArgument("http_headers", false);
    private SOSArgument<String> domain = new SOSArgument("domain", false);
    private SOSArgument<String> workstation = new SOSArgument("workstation", false);
    private SOSArgument<URI> baseURI = new SOSArgument(null, false);

    public HTTPProviderArguments() {
        this.getProtocol().setValue((Object)AProviderArguments.Protocol.HTTP);
        this.getPort().setDefaultValue((Object)80);
        this.getConnectTimeout().setDefaultValue((Object)"30s");
    }

    @Override
    public String getAccessInfo() throws ProviderInitializationException {
        if (this.baseURI.getValue() == null) {
            try {
                this.setBaseURI(HTTPProviderUtils.getBaseURI(this.getHost(), this.getPort()));
            }
            catch (Exception e) {
                throw new ProviderInitializationException(e);
            }
        }
        return HttpUtils.getAccessInfo((URI)((URI)this.baseURI.getValue()), (String)((String)this.getUser().getValue()));
    }

    @Override
    public String getAdvancedAccessInfo() {
        return null;
    }

    public SslArguments getSsl() {
        if (this.ssl == null) {
            this.ssl = new SslArguments();
            this.ssl.applyDefaultIfNullQuietly();
        }
        return this.ssl;
    }

    public void setSsl(SslArguments val) {
        this.ssl = val;
    }

    public int getConnectTimeoutAsSeconds() {
        return (int)SOSArgumentHelper.asSeconds(this.getConnectTimeout(), (long)30L);
    }

    public SOSArgument<HttpClientAuthMethod> getAuthMethod() {
        return this.authMethod;
    }

    public SOSArgument<List<String>> getHttpHeaders() {
        return this.httpHeaders;
    }

    public SOSArgument<String> getDomain() {
        return this.domain;
    }

    public SOSArgument<String> getWorkstation() {
        return this.workstation;
    }

    public void setBaseURI(URI val) {
        this.baseURI.setValue((Object)val);
    }

    public URI getBaseURI() {
        return (URI)this.baseURI.getValue();
    }
}

