/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.smb.commons;

public enum SMBAuthMethod {
    ANONYMOUS(null, null, null),
    GUEST(null, null, null),
    NTLM(null, null, null),
    KERBEROS("Kerberos", "1.2.840.113554.1.2.2", "KerberosLogin"),
    SPNEGO("SPNEGO", "1.3.6.1.5.5.2", "SPNEGOLogin");

    private final String name;
    private final String oid;
    private final String loginContextName;

    private SMBAuthMethod(String name, String oid, String loginContextName) {
        this.name = name;
        this.oid = oid;
        this.loginContextName = loginContextName;
    }

    public String getName() {
        return this.name;
    }

    public String getOid() {
        return this.oid;
    }

    public String getLoginContextName() {
        return this.loginContextName;
    }

    public String toString() {
        return this.name + (String)(this.oid == null ? "" : " (" + this.oid + ")");
    }
}

