/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ssh.commons;

import com.sos.commons.util.SOSString;
import com.sos.commons.util.beans.SOSCommandResult;
import com.sos.commons.vfs.ssh.SSHProvider;
import java.lang.invoke.CallSite;
import java.util.ArrayList;

public class SSHServerInfo {
    private static final String COMMANDO = "uname";
    private final String serverVersion;
    private final SOSCommandResult commandResult;
    private String os = OS.UNKNOWN.name();
    private Shell shell = Shell.UNKNOWN;

    public SSHServerInfo(SSHProvider provider, String serverVersion) {
        this.serverVersion = serverVersion;
        this.commandResult = provider.executeCommand(COMMANDO);
        if (provider.getLogger().isDebugEnabled()) {
            provider.getLogger().debug("[SSHServerInfo]%s", new Object[]{SOSString.replaceNewLines((String)this.commandResult.toString(), (String)" ")});
        }
        this.analyze(provider);
    }

    private void analyze(SSHProvider provider) {
        if (this.commandResult == null) {
            return;
        }
        if (this.commandResult.getExitCode() == null) {
            if (this.commandResult.getStdErr().length() > 0) {
                this.os = OS.WINDOWS.name();
            } else {
                this.trySetOSFromServerVersion();
            }
            return;
        }
        String stdOut = this.commandResult.getStdOut().trim();
        String stdOutLowerCase = stdOut.toLowerCase();
        String stdErrLowerCase = this.commandResult.getStdErr().trim().toLowerCase();
        boolean isSFTPOnly = stdOutLowerCase.contains("sftp") && stdOutLowerCase.contains("only") && stdErrLowerCase.isEmpty();
        switch (this.commandResult.getExitCode()) {
            case 0: {
                if (stdOutLowerCase.matches("(?i).*(linux|darwin|aix|hp-ux|solaris|sunos|freebsd).*")) {
                    this.os = stdOut;
                    this.setShell(isSFTPOnly, Shell.UNIX);
                    break;
                }
                if (stdOutLowerCase.matches("(?i).*cygwin.*")) {
                    this.os = OS.WINDOWS.name();
                    this.setShell(isSFTPOnly, Shell.CYGWIN);
                    break;
                }
                this.trySetOSFromServerVersion();
                this.setShell(isSFTPOnly, Shell.UNIX);
                break;
            }
            case 9009: {
                this.os = OS.WINDOWS.name();
                this.setShell(isSFTPOnly, Shell.WINDOWS);
                break;
            }
            case 1: {
                this.trySetOSFromServerVersion();
                if (isSFTPOnly) {
                    this.shell = Shell.UNKNOWN;
                    break;
                }
                if (stdOutLowerCase.isEmpty() && stdErrLowerCase.contains(COMMANDO.toLowerCase())) {
                    this.os = OS.WINDOWS.name();
                    this.shell = Shell.WINDOWS;
                    break;
                }
                SOSCommandResult ver = provider.executeCommand("ver");
                if (provider.getLogger().isDebugEnabled()) {
                    provider.getLogger().debug("[SSHServerInfo]%s", new Object[]{this.commandResult});
                }
                if (!ver.getStdOut().toUpperCase().contains(OS.WINDOWS.name())) break;
                this.os = OS.WINDOWS.name();
                this.shell = Shell.WINDOWS;
                break;
            }
            case 127: {
                this.os = OS.WINDOWS.name();
                this.setShell(isSFTPOnly, Shell.CYGWIN);
                break;
            }
            default: {
                this.trySetOSFromServerVersion();
                this.shell = Shell.UNKNOWN;
            }
        }
    }

    private void trySetOSFromServerVersion() {
        if (!SOSString.isEmpty((String)this.serverVersion) && this.serverVersion.toUpperCase().contains(OS.WINDOWS.name())) {
            this.os = OS.WINDOWS.name();
        }
    }

    private void setShell(boolean isSFTPOnly, Shell shell) {
        this.shell = isSFTPOnly ? Shell.UNKNOWN : shell;
    }

    public String getOS() {
        return this.os;
    }

    public Shell getShell() {
        return this.shell;
    }

    public SOSCommandResult getCommandResult() {
        return this.commandResult;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public boolean isWindowsShell() {
        return this.shell.equals((Object)Shell.WINDOWS);
    }

    public String toString() {
        ArrayList<CallSite> l = new ArrayList<CallSite>();
        if (this.serverVersion != null) {
            l.add((CallSite)((Object)("Identity=" + this.serverVersion)));
        }
        l.add((CallSite)((Object)("OS=" + this.os)));
        l.add((CallSite)((Object)("Shell=" + this.shell.name())));
        StringBuilder result = new StringBuilder("Server ");
        result.append(String.join((CharSequence)", ", l));
        if (this.commandResult.hasError(false)) {
            result.append(" (");
            result.append(this.commandResult.getCommand());
            if (this.commandResult.getExitCode() != null && this.commandResult.getExitCode() > 0) {
                result.append(" exitCode=").append(this.commandResult.getExitCode());
            }
            if (this.commandResult.getException() != null) {
                result.append(" ").append(this.commandResult.getException().toString());
            }
            result.append(")");
        }
        return result.toString();
    }

    public static enum OS {
        UNKNOWN,
        UNIX,
        WINDOWS;

    }

    public static enum Shell {
        UNKNOWN,
        UNIX,
        WINDOWS,
        CYGWIN;

    }
}

