/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.webdav.commons;

import com.sos.commons.httpclient.BaseHttpClient;
import com.sos.commons.httpclient.commons.HttpExecutionResult;
import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.commons.vfs.commons.file.selection.ProviderFileSelection;
import com.sos.commons.vfs.webdav.WebDAVProvider;
import com.sos.commons.vfs.webdav.commons.WebDAVResource;
import com.sos.commons.xml.SOSXML;
import com.sos.commons.xml.transform.SOSXmlTransformer;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebDAVProviderUtils {
    public static List<ProviderFile> selectFiles(WebDAVProvider provider, ProviderFileSelection selection, String directoryPath, List<ProviderFile> result) throws Exception {
        int counterAdded = 0;
        WebDAVProviderUtils.list(provider, selection, directoryPath, result, counterAdded);
        return result;
    }

    public static boolean exists(BaseHttpClient client, URI uri) throws Exception {
        HttpExecutionResult result = client.executeWithResponseBody(WebDAVProviderUtils.createPROPFINDRequest(client, uri, "0"));
        int code = result.response().statusCode();
        if (!HttpUtils.isSuccessful((int)code)) {
            if (HttpUtils.isNotFound((int)code)) {
                return false;
            }
            throw new IOException(BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
        }
        return true;
    }

    public static void createDirectory(WebDAVProvider provider, URI uri) throws Exception {
        HttpRequest.Builder builder = provider.getClient().createRequestBuilder(uri);
        HttpExecutionResult result = provider.getClient().executeNoResponseBody(builder.method("MKCOL", HttpRequest.BodyPublishers.noBody()).build());
        if (!HttpUtils.isSuccessful((int)result.response().statusCode())) {
            throw new IOException(BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
        }
        if (provider.getLogger().isDebugEnabled()) {
            provider.getLogger().debug("%s[createDirectory][%s]created", new Object[]{provider.getLogPrefix(), uri});
        }
    }

    public static boolean directoryExists(WebDAVProvider provider, URI uri) throws Exception {
        WebDAVResource resource = WebDAVProviderUtils.getResource(provider, uri);
        return resource == null ? false : resource.isDirectory();
    }

    public static WebDAVResource getResource(WebDAVProvider provider, URI uri) throws Exception {
        String depth = "0";
        HttpExecutionResult result = provider.getClient().executeWithResponseBody(WebDAVProviderUtils.createPROPFINDRequest(provider.getClient(), uri, depth));
        int code = result.response().statusCode();
        if (!HttpUtils.isSuccessful((int)code)) {
            if (HttpUtils.isNotFound((int)code)) {
                return null;
            }
            throw new IOException(BaseHttpClient.formatExecutionResult((HttpExecutionResult)result));
        }
        List<WebDAVResource> resources = WebDAVProviderUtils.parseWebDAVResources(provider, uri, depth, (HttpExecutionResult<String>)result);
        return resources.isEmpty() ? null : resources.get(0);
    }

    private static int list(WebDAVProvider provider, ProviderFileSelection selection, String directoryPath, List<ProviderFile> result, int counterAdded) throws Exception {
        URI directoryURI = HttpUtils.ensureDirectoryURI((URI)new URI(provider.normalizePath(directoryPath)));
        String depth = "1";
        HttpExecutionResult executeResult = provider.getClient().executeWithResponseBody(WebDAVProviderUtils.createPROPFINDRequest(provider.getClient(), directoryURI, depth));
        int code = executeResult.response().statusCode();
        if (!HttpUtils.isSuccessful((int)code)) {
            throw new IOException(BaseHttpClient.formatExecutionResult((HttpExecutionResult)executeResult));
        }
        HashSet<String> subDirectories = new HashSet<String>();
        for (WebDAVResource resource : WebDAVProviderUtils.parseWebDAVResources(provider, directoryURI, depth, (HttpExecutionResult<String>)executeResult)) {
            if (selection.maxFilesExceeded(counterAdded)) {
                return counterAdded;
            }
            if (resource.isDirectory()) {
                if (!selection.getConfig().isRecursive() || !selection.checkDirectory(resource.getURI())) continue;
                subDirectories.add(resource.getURI());
                continue;
            }
            if (!selection.checkFileName(SOSPathUtils.getName((String)resource.getURI())) || !selection.isValidFileType(resource)) continue;
            ProviderFile file = provider.createProviderFile(resource);
            if (file == null) {
                if (!provider.getLogger().isDebugEnabled()) continue;
                provider.getLogger().debug((Object)(provider.getPathOperationPrefix(resource.getURI()) + "[skip]" + resource));
                continue;
            }
            if (!selection.checkProviderFileMinMaxSize(file)) continue;
            file.setIndex(++counterAdded);
            result.add(file);
            if (!provider.getLogger().isDebugEnabled()) continue;
            provider.getLogger().debug((Object)(provider.getPathOperationPrefix(file.getFullPath()) + "added"));
        }
        for (String subDirectory : subDirectories) {
            if (selection.maxFilesExceeded(counterAdded)) {
                return counterAdded;
            }
            counterAdded = WebDAVProviderUtils.list(provider, selection, subDirectory, result, counterAdded);
        }
        return counterAdded;
    }

    private static HttpRequest createPROPFINDRequest(BaseHttpClient client, URI uri, String depth) {
        HttpRequest.Builder builder = client.createRequestBuilder(uri).header("Depth", depth).header("Content-Type", "application/xml").method("PROPFIND", HttpRequest.BodyPublishers.ofString(WebDAVProviderUtils.getPROPFINDRequestBody()));
        return builder.build();
    }

    private static String getPROPFINDRequestBody() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<d:propfind xmlns:d=\"DAV:\">\n    <d:prop>\n        <d:resourcetype/>\n        <d:getcontentlength/>\n        <d:getlastmodified/>\n    </d:prop>\n</d:propfind>\n";
        return xml;
    }

    private static List<WebDAVResource> parseWebDAVResources(WebDAVProvider provider, URI uri, String depth, HttpExecutionResult<String> result) throws Exception {
        boolean isDebugEnabled = provider.getLogger().isDebugEnabled();
        NodeList responseNodes = SOSXML.parse((String)((String)result.response().body()), (boolean)true).getElementsByTagNameNS("*", "response");
        if (isDebugEnabled) {
            provider.getLogger().debug("%s[parseWebDAVResources][%s][D:response]size=%s", new Object[]{provider.getLogPrefix(), uri, responseNodes.getLength()});
        }
        ArrayList<WebDAVResource> resources = new ArrayList<WebDAVResource>();
        boolean responseOfURISelfChecked = false;
        for (int i = 0; i < responseNodes.getLength(); ++i) {
            String resourceHref;
            Element response = (Element)responseNodes.item(i);
            if (isDebugEnabled) {
                provider.getLogger().debug("%s[parseWebDAVResources][%s]%s", new Object[]{provider.getLogPrefix(), i, SOSXmlTransformer.nodeToString((Node)response)});
            }
            if ((resourceHref = WebDAVProviderUtils.extractHref(response)) == null) {
                provider.getLogger().debug("[parseWebDAVResources][%s][skip]missing href", new Object[]{i});
                continue;
            }
            URI resourceURI = URI.create(HttpUtils.normalizePath((URI)uri, (String)resourceHref));
            boolean resourceIsDirectory = WebDAVProviderUtils.extractIsDirectory(response);
            if (!responseOfURISelfChecked && !depth.equals("0") && resourceIsDirectory && HttpUtils.ensureDirectoryURI((URI)uri).equals(HttpUtils.ensureDirectoryURI((URI)resourceURI))) {
                responseOfURISelfChecked = true;
                continue;
            }
            resources.add(new WebDAVResource(resourceURI, resourceIsDirectory, WebDAVProviderUtils.extractSize(response, "getcontentlength"), WebDAVProviderUtils.extractLastModified(response)));
        }
        return resources;
    }

    private static String extractHref(Element response) {
        NodeList nodes = response.getElementsByTagNameNS("*", "href");
        if (nodes.getLength() > 0) {
            return nodes.item(0).getTextContent();
        }
        return null;
    }

    private static boolean extractIsDirectory(Element response) {
        NodeList resourceTypeNodes = response.getElementsByTagNameNS("*", "resourcetype");
        if (resourceTypeNodes.getLength() > 0) {
            NodeList collectionNodes = ((Element)resourceTypeNodes.item(0)).getElementsByTagNameNS("*", "collection");
            return collectionNodes.getLength() > 0;
        }
        return false;
    }

    private static long extractSize(Element response, String tagName) {
        NodeList nodes = response.getElementsByTagNameNS("*", tagName);
        if (nodes.getLength() > 0) {
            try {
                return Long.parseLong(nodes.item(0).getTextContent());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    private static long extractLastModified(Element response) {
        NodeList nodes = response.getElementsByTagNameNS("*", "getlastmodified");
        if (nodes.getLength() > 0) {
            return HttpUtils.httpDateToMillis((String)nodes.item(0).getTextContent());
        }
        return -1L;
    }
}

