/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine;

import com.sos.commons.util.SOSCLIArgumentsParser;
import com.sos.commons.util.SOSPath;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.util.loggers.impl.SLF4JLogger;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.yade.engine.YADEEngine;
import com.sos.yade.engine.commons.YADEOutcomeHistory;
import com.sos.yade.engine.commons.arguments.YADEArguments;
import com.sos.yade.engine.commons.arguments.YADESourceArguments;
import com.sos.yade.engine.commons.arguments.loaders.AYADEArgumentsLoader;
import com.sos.yade.engine.commons.arguments.loaders.xml.YADEXMLArgumentsLoader;
import com.sos.yade.engine.exceptions.YADEEngineSettingsLoadException;
import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class YADEEngineMain {
    private static final String STARTUP_SWITCH_HELP_1 = "h";
    private static final String STARTUP_SWITCH_HELP_2 = "help";
    private static final String STARTUP_ARG_RETURN_VALUES = "return_values";
    private static final int ERROR_EXIT_CODE = 99;
    private YADEEngine engine;
    private ISOSLogger logger;

    public static void main(String[] args) {
        YADEEngineMain main = new YADEEngineMain();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                if (main.engine != null) {
                    main.engine.cancel(main.logger);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }));
        System.exit(main.execute(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(String[] args) {
        int n;
        block10: {
            Map<String, String> normalizedArgs;
            Throwable exception;
            List<ProviderFile> files;
            YADEXMLArgumentsLoader argsLoader;
            String historyReturnValuesFile;
            block8: {
                int n2;
                block9: {
                    this.logger = new SLF4JLogger();
                    historyReturnValuesFile = null;
                    argsLoader = null;
                    files = null;
                    exception = null;
                    Map cliArgs = SOSCLIArgumentsParser.parse((String[])args);
                    normalizedArgs = YADEEngineMain.normalizeArguments(cliArgs, Set.of("file_spec", "file_path", "file_list", "recursive"));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("[cliArgs]" + cliArgs));
                        this.logger.debug((Object)("[normalizedArgs]" + normalizedArgs));
                    }
                    if (YADEEngineMain.checkArguments(normalizedArgs)) break block8;
                    n2 = 0;
                    if (historyReturnValuesFile == null) break block9;
                    YADEEngineMain.writeHistoryToReturnValuesFile(this.logger, historyReturnValuesFile, argsLoader, files, exception);
                }
                this.engine = null;
                return n2;
            }
            try {
                historyReturnValuesFile = normalizedArgs.get(STARTUP_ARG_RETURN_VALUES);
                Path settings = SOSPath.toAbsoluteNormalizedPath((String)this.getRequiredArgumentValue(normalizedArgs, "settings"));
                String profile = this.getRequiredArgumentValue(normalizedArgs, "profile");
                Boolean settingsReplacerCaseSensitive = this.getBooleanValue(normalizedArgs, "settings_replacer_case_sensitive", YADEArguments.STARTUP_ARG_SETTINGS_REPLACER_CASE_SENSITIVE_DEFAULT);
                Boolean settingsReplacerKeepUnresolved = this.getBooleanValue(normalizedArgs, "settings_replacer_keep_unresolved", YADEArguments.STARTUP_ARG_SETTINGS_REPLACER_KEEP_UNRESOLVED_DEFAULT);
                argsLoader = new YADEXMLArgumentsLoader().load(this.logger, settings, profile, System.getenv(), settingsReplacerCaseSensitive, settingsReplacerKeepUnresolved);
                argsLoader.getArgs().getParallelism().setValue((Object)this.getIntegerValue(normalizedArgs, "parallelism", String.valueOf(1)));
                this.applyOverrides(argsLoader, normalizedArgs);
                YADEEngine engine = new YADEEngine();
                files = engine.execute(this.logger, argsLoader, true);
                n = 0;
                if (historyReturnValuesFile == null) break block10;
            }
            catch (Throwable e) {
                try {
                    exception = e;
                    this.logger.error(e.toString(), e);
                    int n3 = 99;
                    return n3;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (historyReturnValuesFile != null) {
                        YADEEngineMain.writeHistoryToReturnValuesFile(this.logger, historyReturnValuesFile, argsLoader, files, exception);
                    }
                    this.engine = null;
                }
            }
            YADEEngineMain.writeHistoryToReturnValuesFile(this.logger, historyReturnValuesFile, argsLoader, files, exception);
        }
        this.engine = null;
        return n;
    }

    private static boolean checkArguments(Map<String, String> args) throws YADEEngineSettingsLoadException {
        if (args.size() > 0 && (args.containsKey(STARTUP_SWITCH_HELP_1) || args.containsKey(STARTUP_SWITCH_HELP_2))) {
            YADEEngineMain.printUsage();
            return false;
        }
        ArrayList<String> missingRequired = new ArrayList<String>();
        if (!args.containsKey("settings")) {
            missingRequired.add("settings");
        }
        if (!args.containsKey("profile")) {
            missingRequired.add("profile");
        }
        if (missingRequired.size() > 0) {
            YADEEngineMain.printUsage();
            throw new YADEEngineSettingsLoadException("[missing required arguments]" + String.join((CharSequence)",", missingRequired));
        }
        return true;
    }

    private static Map<String, String> normalizeArguments(Map<String, String> cliArgs, Set<String> sourceArgsWithoutPrefix) {
        LinkedHashMap<String, String> r = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : cliArgs.entrySet()) {
            Object newKey = entry.getKey().toLowerCase().replace('-', '_');
            if (sourceArgsWithoutPrefix.contains(newKey)) {
                newKey = "source_" + (String)newKey;
            }
            r.put((String)newKey, entry.getValue());
        }
        return r;
    }

    private void applyOverrides(AYADEArgumentsLoader argsLoader, Map<String, String> args) {
        this.setOptionalStringArgument(argsLoader.getSourceArgs().getDirectory(), args, "source_dir");
        this.setOptionalStringArgument(argsLoader.getSourceArgs().getExcludedDirectories(), args, "source_excluded_directories");
        this.setOptionalSourceFileList(argsLoader.getSourceArgs(), args, "source_file_list");
        this.setOptionalSourceFilePath(argsLoader.getSourceArgs(), args, "source_file_path");
        this.setOptionalSourceFileSpec(argsLoader.getSourceArgs(), args, "source_file_spec");
        this.setOptionalBooleanArgument(argsLoader.getSourceArgs().getRecursive(), args, "source_recursive");
        if (argsLoader.getTargetArgs() != null) {
            this.setOptionalStringArgument(argsLoader.getTargetArgs().getDirectory(), args, "target_dir");
        }
    }

    private static void writeHistoryToReturnValuesFile(ISOSLogger logger, String historyReturnValuesFile, AYADEArgumentsLoader argsLoader, List<ProviderFile> files, Throwable exception) {
        if (argsLoader == null || argsLoader.getArgs() == null) {
            return;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("[writeHistoryToReturnValuesFile][%s]...", new Object[]{historyReturnValuesFile});
            }
            String serialized = YADEOutcomeHistory.get(argsLoader, files, exception);
            try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(historyReturnValuesFile, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
                writer.write("yade_return_values" + "=" + serialized + System.lineSeparator());
                writer.flush();
            }
        }
        catch (Exception e) {
            logger.error("[writeHistoryToReturnValuesFile]" + e.toString(), (Throwable)e);
        }
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println("  Options:");
        System.out.println("    Transfer Options (required):");
        YADEEngineMain.printArgumentUsage("settings", "<location of the settings xml file>", "");
        YADEEngineMain.printArgumentUsage("profile", "<profile id>", "");
        System.out.println("    Transfer Options:");
        YADEEngineMain.printArgumentUsage("source_dir", "<...>", null);
        YADEEngineMain.printArgumentUsage("source_excluded_directories", "<...>", null);
        YADEEngineMain.printArgumentUsage("source_file_path", "<...>", null);
        YADEEngineMain.printArgumentUsage("source_file_spec", "<...>", null);
        YADEEngineMain.printArgumentUsage("source_file_list", "<...>", null);
        YADEEngineMain.printArgumentUsage("source_recursive", "<true|false>", null);
        YADEEngineMain.printArgumentUsage("target_dir", "<...>", null);
        System.out.println("    Processing Options:");
        YADEEngineMain.printArgumentUsage("settings_replacer_case_sensitive", "<boolean>", "default: " + YADEArguments.STARTUP_ARG_SETTINGS_REPLACER_CASE_SENSITIVE_DEFAULT);
        YADEEngineMain.printArgumentUsage("settings_replacer_keep_unresolved", "<boolean>", "default: " + YADEArguments.STARTUP_ARG_SETTINGS_REPLACER_KEEP_UNRESOLVED_DEFAULT);
        YADEEngineMain.printArgumentUsage("parallelism", "<integer>", "default: 1");
        System.out.println("    Switches:");
        YADEEngineMain.printArgumentUsage("-h | --help", null, "displays usage", false);
        YADEEngineMain.printArgumentUsage("-source_recursive", null, "true", false);
    }

    private static void printArgumentUsage(String name, String valueDescription, String description) {
        YADEEngineMain.printArgumentUsage(name, valueDescription, description, true);
    }

    private static void printArgumentUsage(String name, String valueDescription, String description, boolean useNamePrefix) {
        String namePrefix;
        Object value = SOSString.isEmpty((String)valueDescription) ? "" : "=" + valueDescription;
        Object desc = "";
        String string = namePrefix = useNamePrefix ? "--" : "";
        if (!SOSString.isEmpty((String)description)) {
            desc = "| " + description;
        }
        System.out.println(String.format("      %-46s%s", namePrefix + YADEEngineMain.formatAsShellOption(name) + (String)value, desc));
    }

    private static String formatAsShellOption(String arg) {
        return arg.replace("_", "-");
    }

    private String getRequiredArgumentValue(Map<String, String> args, String name) throws YADEEngineSettingsLoadException {
        String val = args.get(name);
        if (SOSString.isEmpty((String)val)) {
            throw new YADEEngineSettingsLoadException("missing -" + name);
        }
        return val;
    }

    private void setOptionalStringArgument(SOSArgument<String> arg, Map<String, String> args, String name) {
        String val = args.get(name);
        if (!SOSString.isEmpty((String)val)) {
            arg.setValue((Object)val);
        }
    }

    private void setOptionalBooleanArgument(SOSArgument<Boolean> arg, Map<String, String> args, String name) {
        String val = args.get(name);
        if (!SOSString.isEmpty((String)val)) {
            arg.setValue((Object)Boolean.valueOf(val));
        }
    }

    private void setOptionalSourceFilePath(YADESourceArguments sourceArgs, Map<String, String> args, String name) {
        String val = args.get(name);
        if (!SOSString.isEmpty((String)val)) {
            sourceArgs.applyFilePath(val);
        }
    }

    private void setOptionalSourceFileList(YADESourceArguments sourceArgs, Map<String, String> args, String name) {
        String val = args.get(name);
        if (!SOSString.isEmpty((String)val)) {
            sourceArgs.applyFileList(Path.of(val, new String[0]));
        }
    }

    private void setOptionalSourceFileSpec(YADESourceArguments sourceArgs, Map<String, String> args, String name) {
        String val = args.get(name);
        if (!SOSString.isEmpty((String)val)) {
            sourceArgs.applyFileSpec(val);
        }
    }

    private Boolean getBooleanValue(Map<String, String> args, String name, Boolean defaultValue) throws YADEEngineSettingsLoadException {
        return Boolean.valueOf(args.getOrDefault(name, "" + defaultValue));
    }

    private Integer getIntegerValue(Map<String, String> args, String name, String defaultValue) throws YADEEngineSettingsLoadException {
        return Integer.valueOf(args.getOrDefault(name, defaultValue));
    }
}

