/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.arguments;

import com.sos.commons.util.arguments.base.ASOSArguments;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.yade.commons.Yade;
import java.nio.file.Path;
import java.time.Instant;

public class YADEArguments
extends ASOSArguments {
    public static final String STARTUP_ARG_SETTINGS = "settings";
    public static final String STARTUP_ARG_PROFILE = "profile";
    public static final String STARTUP_ARG_PARALLELISM = "parallelism";
    public static final int STARTUP_ARG_PARALLELISM_DEFAULT = 1;
    public static final String STARTUP_ARG_SOURCE_DIR = "source_dir";
    public static final String STARTUP_ARG_SOURCE_EXCLUDED_DIRECTORIES = "source_excluded_directories";
    public static final String STARTUP_ARG_SOURCE_FILE_PATH = "source_file_path";
    public static final String STARTUP_ARG_SOURCE_FILE_SPEC = "source_file_spec";
    public static final String STARTUP_ARG_SOURCE_FILE_LIST = "source_file_list";
    public static final String STARTUP_ARG_SOURCE_RECURSIVE = "source_recursive";
    public static final String STARTUP_ARG_TARGET_DIR = "target_dir";
    public static final String STARTUP_ARG_SETTINGS_REPLACER_CASE_SENSITIVE = "settings_replacer_case_sensitive";
    public static final Boolean STARTUP_ARG_SETTINGS_REPLACER_CASE_SENSITIVE_DEFAULT = true;
    public static final String STARTUP_ARG_SETTINGS_REPLACER_KEEP_UNRESOLVED = "settings_replacer_keep_unresolved";
    public static final Boolean STARTUP_ARG_SETTINGS_REPLACER_KEEP_UNRESOLVED_DEFAULT = true;
    public static final String LABEL = "Transfer";
    private SOSArgument<Path> settings = new SOSArgument("settings", false);
    private SOSArgument<String> profile = new SOSArgument("profile", false);
    private SOSArgument<Yade.TransferOperation> operation = new SOSArgument("Operation", true);
    private SOSArgument<Integer> parallelism = new SOSArgument("parallelism", false, (Object)1);
    private SOSArgument<Boolean> transactional = new SOSArgument("Transactional", false, (Object)false);
    private SOSArgument<Integer> bufferSize = new SOSArgument("BufferSize", false, (Object)32768);
    private SOSArgument<Instant> start = new SOSArgument(null, false);
    private SOSArgument<Instant> end = new SOSArgument(null, false);

    public boolean isOperationGETLIST() {
        return Yade.TransferOperation.GETLIST.equals(this.operation.getValue());
    }

    public boolean isOperationMOVE() {
        return Yade.TransferOperation.MOVE.equals(this.operation.getValue());
    }

    public boolean isOperationREMOVE() {
        return Yade.TransferOperation.REMOVE.equals(this.operation.getValue());
    }

    public SOSArgument<Path> getSettings() {
        return this.settings;
    }

    public SOSArgument<String> getProfile() {
        return this.profile;
    }

    public SOSArgument<Yade.TransferOperation> getOperation() {
        return this.operation;
    }

    public SOSArgument<Integer> getParallelism() {
        return this.parallelism;
    }

    public boolean isParallelismEnabled() {
        return !this.parallelism.isEmpty() && (Integer)this.parallelism.getValue() > 1;
    }

    public SOSArgument<Boolean> getTransactional() {
        return this.transactional;
    }

    public SOSArgument<Integer> getBufferSize() {
        return this.bufferSize;
    }

    public SOSArgument<Instant> getStart() {
        return this.start;
    }

    public SOSArgument<Instant> getEnd() {
        return this.end;
    }
}

