/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.arguments.loaders.xml;

import com.sos.commons.util.SOSComparisonOperator;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.keystore.KeyStoreType;
import com.sos.commons.util.proxy.ProxyConfigArguments;
import com.sos.commons.util.ssl.SslArguments;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.ftp.commons.FTPProviderArguments;
import com.sos.commons.vfs.ftp.commons.FTPSProviderArguments;
import com.sos.commons.vfs.http.commons.HTTPProviderArguments;
import com.sos.commons.vfs.http.commons.HTTPSProviderArguments;
import com.sos.commons.vfs.smb.commons.SMBAuthMethod;
import com.sos.commons.vfs.smb.commons.SMBProviderArguments;
import com.sos.commons.vfs.ssh.commons.SSHProviderArguments;
import com.sos.commons.vfs.webdav.commons.WebDAVProviderArguments;
import com.sos.yade.engine.addons.YADEEngineJumpHostAddon;
import com.sos.yade.engine.commons.arguments.YADEArguments;
import com.sos.yade.engine.commons.arguments.YADEClientArguments;
import com.sos.yade.engine.commons.arguments.YADESourceArguments;
import com.sos.yade.engine.commons.arguments.YADESourceTargetArguments;
import com.sos.yade.engine.commons.arguments.YADETargetArguments;
import com.sos.yade.engine.commons.arguments.loaders.AYADEArgumentsLoader;
import java.nio.file.Path;
import java.util.List;

public class YADEXMLJumpHostSettingsWriter {
    private static final String FRAGMENT_NAME = "fragment";
    private static final String CS_FRAMENT_REF = "<CredentialStoreFragmentRef ref=\"cs\"/>";

    public static String sourceToJumpHostCOPY(AYADEArgumentsLoader argsLoader, YADEEngineJumpHostAddon.JumpHostConfig config) {
        YADESourceArguments sourceArgs = argsLoader.getSourceArgs();
        StringBuilder fragments = YADEXMLJumpHostSettingsWriter.generateFragments(sourceArgs.getProvider());
        StringBuilder profile = YADEXMLJumpHostSettingsWriter.generateProfileSourceToJumpHost(argsLoader.getArgs(), argsLoader.getClientArgs(), sourceArgs, argsLoader.getTargetArgs(), config, "Copy", true);
        return YADEXMLJumpHostSettingsWriter.generateConfiguration(fragments, profile).toString();
    }

    public static String sourceToJumpHostGETLIST(AYADEArgumentsLoader argsLoader, YADEEngineJumpHostAddon.JumpHostConfig config) {
        YADESourceArguments sourceArgs = argsLoader.getSourceArgs();
        StringBuilder fragments = YADEXMLJumpHostSettingsWriter.generateFragments(sourceArgs.getProvider());
        StringBuilder profile = YADEXMLJumpHostSettingsWriter.generateProfileSourceToJumpHost(argsLoader.getArgs(), argsLoader.getClientArgs(), sourceArgs, argsLoader.getTargetArgs(), config, "GetList", false);
        return YADEXMLJumpHostSettingsWriter.generateConfiguration(fragments, profile).toString();
    }

    public static String sourceToJumpHostREMOVE(AYADEArgumentsLoader argsLoader, YADEEngineJumpHostAddon.JumpHostConfig config) {
        YADESourceArguments sourceArgs = argsLoader.getSourceArgs();
        StringBuilder fragments = YADEXMLJumpHostSettingsWriter.generateFragments(sourceArgs.getProvider());
        StringBuilder profile = YADEXMLJumpHostSettingsWriter.generateProfileSourceToJumpHost(argsLoader.getArgs(), argsLoader.getClientArgs(), sourceArgs, argsLoader.getTargetArgs(), config, "Remove", false);
        return YADEXMLJumpHostSettingsWriter.generateConfiguration(fragments, profile).toString();
    }

    public static String sourceToJumpHostMOVERemove(AYADEArgumentsLoader argsLoader, YADEEngineJumpHostAddon.JumpHostConfig config, String profileId) {
        YADESourceArguments sourceArgs = argsLoader.getSourceArgs();
        StringBuilder fragments = YADEXMLJumpHostSettingsWriter.generateFragments(sourceArgs.getProvider());
        StringBuilder profile = YADEXMLJumpHostSettingsWriter.generateProfileSourceToJumpHostMOVERemove(sourceArgs, config, profileId);
        return YADEXMLJumpHostSettingsWriter.generateConfiguration(fragments, profile).toString();
    }

    public static String jumpHostToTargetCOPY(AYADEArgumentsLoader argsLoader, YADEEngineJumpHostAddon.JumpHostConfig config) {
        YADETargetArguments targetArgs = argsLoader.getTargetArgs();
        StringBuilder fragments = YADEXMLJumpHostSettingsWriter.generateFragments(targetArgs.getProvider());
        StringBuilder profile = YADEXMLJumpHostSettingsWriter.generateProfileJumpHostToTargetCOPY(argsLoader.getArgs(), targetArgs, config);
        return YADEXMLJumpHostSettingsWriter.generateConfiguration(fragments, profile).toString();
    }

    private static StringBuilder generateConfiguration(StringBuilder fragments, StringBuilder profile) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<Configurations>");
        sb.append("<Fragments>").append((CharSequence)fragments).append("</Fragments>");
        sb.append("<Profiles>").append((CharSequence)profile).append("</Profiles>");
        sb.append("</Configurations>");
        return sb;
    }

    private static StringBuilder generateFragments(AProviderArguments providerArgs) {
        boolean generateCS = false;
        if (providerArgs.getCredentialStore() != null && providerArgs.getCredentialStore().getFile().isDirty()) {
            generateCS = true;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<ProtocolFragments>");
        switch ((AProviderArguments.Protocol)providerArgs.getProtocol().getValue()) {
            case SFTP: {
                sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentSFTP((SSHProviderArguments)providerArgs, generateCS));
                break;
            }
            case FTP: {
                sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentFTP((FTPProviderArguments)providerArgs, generateCS, false));
                break;
            }
            case FTPS: {
                sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentFTP((FTPProviderArguments)((FTPSProviderArguments)providerArgs), generateCS, true));
                break;
            }
            case HTTP: {
                sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentHTTP((HTTPProviderArguments)providerArgs, generateCS, false));
                break;
            }
            case HTTPS: {
                sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentHTTP((HTTPProviderArguments)((HTTPSProviderArguments)providerArgs), generateCS, true));
                break;
            }
            case WEBDAV: {
                sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentWEBDAV((HTTPProviderArguments)((WebDAVProviderArguments)providerArgs), generateCS, false));
                break;
            }
            case WEBDAVS: {
                sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentWEBDAV((HTTPProviderArguments)((WebDAVProviderArguments)providerArgs), generateCS, true));
                break;
            }
            case SMB: {
                sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentSMB((SMBProviderArguments)providerArgs, generateCS));
                break;
            }
            default: {
                sb.append("</ProtocolFragments>");
                return sb;
            }
        }
        sb.append("</ProtocolFragments>");
        if (generateCS) {
            sb.append("<CredentialStoreFragments>");
            sb.append("<CredentialStoreFragment name=\"cs\">");
            sb.append("<CSFile>").append(YADEXMLJumpHostSettingsWriter.cdata((String)providerArgs.getCredentialStore().getFile().getValue())).append("</CSFile>");
            sb.append("<CSAuthentication>");
            if (providerArgs.getCredentialStore().getKeyFile().isDirty()) {
                sb.append("<KeyFileAuthentication>");
                sb.append("<CSKeyFile>").append(YADEXMLJumpHostSettingsWriter.cdata((String)providerArgs.getCredentialStore().getKeyFile().getValue())).append("</CSKeyFile>");
                if (providerArgs.getCredentialStore().getPassword().isDirty()) {
                    sb.append("<CSPassword>").append(YADEXMLJumpHostSettingsWriter.cdata((String)providerArgs.getCredentialStore().getPassword().getValue())).append("</CSPassword>");
                }
                sb.append("</KeyFileAuthentication>");
            } else if (providerArgs.getCredentialStore().getPassword().isDirty()) {
                sb.append("<PasswordAuthentication>");
                sb.append("<CSPassword>").append(YADEXMLJumpHostSettingsWriter.cdata((String)providerArgs.getCredentialStore().getPassword().getValue())).append("</CSPassword>");
                sb.append("</PasswordAuthentication>");
            }
            sb.append("</CSAuthentication>");
            sb.append("</CredentialStoreFragment>");
            sb.append("</CredentialStoreFragments>");
        }
        return sb;
    }

    private static StringBuilder generateProtocolFragmentSFTP(SSHProviderArguments args, boolean generateCSRef) {
        StringBuilder sb = new StringBuilder();
        sb.append("<SFTPFragment name=").append(YADEXMLJumpHostSettingsWriter.attrValue(FRAGMENT_NAME)).append(">");
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartBasicConnection((SOSArgument<String>)args.getHost(), (SOSArgument<Integer>)args.getPort(), (SOSArgument<String>)args.getConnectTimeout()));
        sb.append("<SSHAuthentication>");
        sb.append("<Account>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getUser().getValue())).append("</Account>");
        if (!args.getPreferredAuthentications().isEmpty()) {
            sb.append("<PreferredAuthentications>");
            sb.append(YADEXMLJumpHostSettingsWriter.cdata(args.getPreferredAuthenticationsAsString()));
            sb.append("</PreferredAuthentications>");
        }
        if (!args.getRequiredAuthentications().isEmpty()) {
            sb.append("<RequiredAuthentications>");
            sb.append(YADEXMLJumpHostSettingsWriter.cdata(args.getRequiredAuthenticationsAsString()));
            sb.append("</RequiredAuthentications>");
        }
        if (!args.getPassword().isEmpty()) {
            sb.append("<AuthenticationMethodPassword>");
            sb.append("<Password>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getPassword().getValue())).append("</Password>");
            sb.append("</AuthenticationMethodPassword>");
        }
        if (!args.getAuthFile().isEmpty()) {
            sb.append("<AuthenticationMethodPublickey>");
            sb.append("<AuthenticationFile>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getAuthFile().getValue())).append("</AuthenticationFile>");
            if (!args.getPassphrase().isEmpty()) {
                sb.append("<Passphrase>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getPassphrase().getValue())).append("</Passphrase>");
            }
            sb.append("</AuthenticationMethodPublickey>");
        }
        sb.append("</SSHAuthentication>");
        if (generateCSRef) {
            sb.append(CS_FRAMENT_REF);
        }
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartProxy(args.getProxy(), "ProxyForSFTP"));
        if (args.getStrictHostkeyChecking().isDirty()) {
            sb.append("<StrictHostkeyChecking>").append(args.getStrictHostkeyChecking().getValue()).append("</StrictHostkeyChecking>");
        }
        if (args.getConfigurationFiles().isDirty()) {
            sb.append("<ConfigurationFiles>");
            for (Path configurationFile : (List)args.getConfigurationFiles().getValue()) {
                sb.append("<ConfigurationFile>").append(YADEXMLJumpHostSettingsWriter.cdata(configurationFile.toString())).append("</ConfigurationFile>");
            }
            sb.append("</ConfigurationFiles>");
        }
        if (args.getServerAliveInterval().isDirty()) {
            sb.append("<ServerAliveInterval>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getServerAliveInterval().getValue())).append("</ServerAliveInterval>");
        }
        if (args.getServerAliveCountMax().isDirty()) {
            sb.append("<ServerAliveCountMax>").append(args.getServerAliveCountMax().getValue()).append("</ServerAliveCountMax>");
        }
        if (args.getConnectTimeout().isDirty()) {
            sb.append("<ConnectTimeout>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getConnectTimeout().getValue())).append("</ConnectTimeout>");
        }
        if (args.getSocketTimeout().isDirty()) {
            sb.append("<ChannelConnectTimeout>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getSocketTimeout().getValue())).append("</ChannelConnectTimeout>");
        }
        sb.append("</SFTPFragment>");
        return sb;
    }

    private static StringBuilder generateProtocolFragmentFTP(FTPProviderArguments args, boolean generateCSRef, boolean isFTPS) {
        String fragmentElementName = isFTPS ? "FTPSFragment" : "FTPFragment";
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(fragmentElementName).append(" name=").append(YADEXMLJumpHostSettingsWriter.attrValue(FRAGMENT_NAME)).append(">");
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartBasicConnection((SOSArgument<String>)args.getHost(), (SOSArgument<Integer>)args.getPort(), (SOSArgument<String>)args.getConnectTimeout()));
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartBasicAuthentication((SOSArgument<String>)args.getUser(), (SOSArgument<String>)args.getPassword()));
        if (generateCSRef) {
            sb.append(CS_FRAMENT_REF);
        }
        if (isFTPS) {
            FTPSProviderArguments ftps = (FTPSProviderArguments)args;
            SslArguments ssl = ftps.getSsl();
            sb.append("<FTPSClientSecurity>");
            sb.append("<SecurityMode>").append(YADEXMLJumpHostSettingsWriter.cdata(ftps.getSecurityModeValue())).append("</SecurityMode>");
            if (ftps.getSsl().getTrustedSsl().isCustomTrustStoreEnabled()) {
                sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartYADE1KeyStore(ssl));
            }
            sb.append("<FTPSClientSecurity>");
            sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartSsl(ssl));
        } else {
            sb.append("<PassiveMode>").append(args.getPassiveMode().getValue()).append("</PassiveMode>");
            if (args.getTransferMode().getValue() != null) {
                sb.append("<TransferMode>").append(YADEXMLJumpHostSettingsWriter.cdata(args.getTransferModeValue())).append("</TransferMode>");
            }
        }
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartProxy(args.getProxy(), isFTPS ? "ProxyForFTPS" : "ProxyForFTP"));
        if (args.getConnectTimeout().isDirty()) {
            sb.append("<ConnectTimeout>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getConnectTimeout().getValue())).append("</ConnectTimeout>");
        }
        sb.append("</").append(fragmentElementName).append(">");
        return sb;
    }

    private static StringBuilder generateProtocolFragmentHTTP(HTTPProviderArguments args, boolean generateCSRef, boolean isHTTPS) {
        String fragmentElementName = isHTTPS ? "HTTPSFragment" : "HTTPFragment";
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(fragmentElementName).append(" name=").append(YADEXMLJumpHostSettingsWriter.attrValue(FRAGMENT_NAME)).append(">");
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartURLConnection((SOSArgument<String>)args.getHost(), (SOSArgument<String>)args.getConnectTimeout()));
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartBasicAuthentication((SOSArgument<String>)args.getUser(), (SOSArgument<String>)args.getPassword()));
        if (generateCSRef) {
            sb.append(CS_FRAMENT_REF);
        }
        if (isHTTPS) {
            SslArguments ssl = ((HTTPSProviderArguments)args).getSsl();
            if (ssl.getUntrustedSsl().isTrue()) {
                sb.append("<AcceptUntrustedCertificate>true</AcceptUntrustedCertificate>");
                sb.append("<DisableCertificateHostnameVerification>");
                sb.append(YADEXMLJumpHostSettingsWriter.getOppositeValue((SOSArgument<Boolean>)ssl.getUntrustedSslVerifyCertificateHostname()));
                sb.append("</DisableCertificateHostnameVerification>");
            }
            if (ssl.getTrustedSsl().isCustomTrustStoreEnabled()) {
                sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartYADE1KeyStore(ssl));
            }
            sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartSsl(ssl));
        }
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartProxy(args.getProxy(), "ProxyForHTTP"));
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartHTTPHeaders((SOSArgument<List<String>>)args.getHttpHeaders()));
        sb.append("</").append(fragmentElementName).append(">");
        return sb;
    }

    private static StringBuilder generateProtocolFragmentWEBDAV(HTTPProviderArguments args, boolean generateCSRef, boolean isWEBDAVS) {
        String fragmentElementName = isWEBDAVS ? "WebDAVFragment" : "WebDAVFragment";
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(fragmentElementName).append(" name=").append(YADEXMLJumpHostSettingsWriter.attrValue(FRAGMENT_NAME)).append(">");
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartURLConnection((SOSArgument<String>)args.getHost(), (SOSArgument<String>)args.getConnectTimeout()));
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartBasicAuthentication((SOSArgument<String>)args.getUser(), (SOSArgument<String>)args.getPassword()));
        if (generateCSRef) {
            sb.append(CS_FRAMENT_REF);
        }
        if (isWEBDAVS) {
            SslArguments ssl = ((HTTPSProviderArguments)args).getSsl();
            if (ssl.getUntrustedSsl().isTrue()) {
                sb.append("<AcceptUntrustedCertificate>true</AcceptUntrustedCertificate>");
                sb.append("<DisableCertificateHostnameVerification>");
                sb.append(YADEXMLJumpHostSettingsWriter.getOppositeValue((SOSArgument<Boolean>)ssl.getUntrustedSslVerifyCertificateHostname()));
                sb.append("</DisableCertificateHostnameVerification>");
            }
            if (ssl.getTrustedSsl().isCustomTrustStoreEnabled()) {
                sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartYADE1KeyStore(ssl));
            }
            sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartSsl(ssl));
        }
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartProxy(args.getProxy(), "ProxyForWebDAV"));
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartHTTPHeaders((SOSArgument<List<String>>)args.getHttpHeaders()));
        sb.append("</").append(fragmentElementName).append(">");
        return sb;
    }

    private static StringBuilder generateProtocolFragmentSMB(SMBProviderArguments args, boolean generateCSRef) {
        StringBuilder sb = new StringBuilder();
        sb.append("<SMBFragment name=").append(YADEXMLJumpHostSettingsWriter.attrValue(FRAGMENT_NAME)).append(">");
        sb.append("<Hostname>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getHost().getValue())).append("</Hostname>");
        if (args.getPort().isDirty() || !args.getShareName().isEmpty()) {
            sb.append("<SMBConnection>");
            sb.append("<Hostname>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getHost().getValue())).append("</Hostname>");
            if (args.getPort().isDirty()) {
                sb.append("<Port>").append(args.getPort().getValue()).append("</Port>");
            }
            sb.append("<Sharename>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getShareName().getValue())).append("</Sharename>");
            sb.append("</SMBConnection>");
        }
        sb.append("<SMBAuthentication>");
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartSMBAuthChildren(args));
        switch ((SMBAuthMethod)args.getAuthMethod().getValue()) {
            case ANONYMOUS: {
                sb.append("<SMBAuthenticationMethodAnonymous />");
                break;
            }
            case GUEST: {
                sb.append("<SMBAuthenticationMethodGuest />");
                break;
            }
            case NTLM: {
                sb.append("<SMBAuthenticationMethodNTLM>");
                sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartSMBAuthChildren(args));
                sb.append("</SMBAuthenticationMethodNTLM>");
                break;
            }
            case KERBEROS: {
                sb.append("<SMBAuthenticationMethodKerberos>");
                sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartSMBAuthChildren(args));
                sb.append("</SMBAuthenticationMethodKerberos>");
                break;
            }
            case SPNEGO: {
                sb.append("<SMBAuthenticationMethodSPNEGO>");
                sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartSMBAuthChildren(args));
                sb.append("</SMBAuthenticationMethodSPNEGO>");
                break;
            }
        }
        sb.append("</SMBAuthentication>");
        if (generateCSRef) {
            sb.append(CS_FRAMENT_REF);
        }
        if (args.getConfigurationFiles().isDirty()) {
            sb.append("<ConfigurationFiles>");
            for (Path configurationFile : (List)args.getConfigurationFiles().getValue()) {
                sb.append("<ConfigurationFile>").append(YADEXMLJumpHostSettingsWriter.cdata(configurationFile.toString())).append("</ConfigurationFile>");
            }
            sb.append("</ConfigurationFiles>");
        }
        sb.append("</SMBFragment>");
        return sb;
    }

    private static StringBuilder generateProtocolFragmentPartSMBAuthChildren(SMBProviderArguments args) {
        StringBuilder sb = new StringBuilder();
        if (!args.getUser().isEmpty()) {
            sb.append("<Account>");
            sb.append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getUser().getValue()));
            sb.append("</Account>");
        }
        if (!args.getDomain().isEmpty()) {
            sb.append("<Domain>");
            sb.append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getDomain().getValue()));
            sb.append("</Domain>");
        }
        if (!args.getPassword().isEmpty()) {
            sb.append("<Password>");
            sb.append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getPassword().getValue()));
            sb.append("</Password>");
        }
        if (!args.getLoginContextName().isEmpty()) {
            sb.append("<LoginContextName>");
            sb.append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getLoginContextName().getValue()));
            sb.append("</LoginContextName>");
        }
        return sb;
    }

    private static StringBuilder generateProtocolFragmentPartHTTPHeaders(SOSArgument<List<String>> headers) {
        StringBuilder sb = new StringBuilder();
        if (headers.getValue() == null || ((List)headers.getValue()).size() == 0) {
            return sb;
        }
        sb.append("<HTTPHeaders>");
        for (String header : (List)headers.getValue()) {
            sb.append("<HTTPHeader >").append(YADEXMLJumpHostSettingsWriter.cdata(header)).append("</HTTPHeader>");
        }
        sb.append("</HTTPHeaders>");
        return sb;
    }

    private static StringBuilder generateProtocolFragmentPartProxy(ProxyConfigArguments args, String elementName) {
        StringBuilder sb = new StringBuilder();
        if (args == null) {
            return sb;
        }
        sb.append("<").append(elementName).append(">");
        if (args.isHTTP()) {
            sb.append("<HTTPProxy>");
            sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartBasicConnection((SOSArgument<String>)args.getHost(), (SOSArgument<Integer>)args.getPort(), (SOSArgument<String>)args.getConnectTimeout()));
            sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartBasicAuthentication((SOSArgument<String>)args.getUser(), (SOSArgument<String>)args.getPassword()));
            sb.append("</HTTPProxy>");
        } else {
            sb.append("<SOCKS5Proxy>");
            sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartBasicConnection((SOSArgument<String>)args.getHost(), (SOSArgument<Integer>)args.getPort(), (SOSArgument<String>)args.getConnectTimeout()));
            sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProtocolFragmentPartBasicAuthentication((SOSArgument<String>)args.getUser(), (SOSArgument<String>)args.getPassword()));
            sb.append("</SOCKS5Proxy>");
        }
        sb.append("</").append(elementName).append(">");
        return sb;
    }

    private static StringBuilder generateProtocolFragmentPartYADE1KeyStore(SslArguments args) {
        StringBuilder sb = new StringBuilder();
        sb.append("<KeyStoreType>");
        sb.append(YADEXMLJumpHostSettingsWriter.cdata(((KeyStoreType)args.getTrustedSsl().getTrustStoreType().getValue()).name()));
        sb.append("</KeyStoreType>");
        sb.append("<KeyStoreFile>");
        sb.append(YADEXMLJumpHostSettingsWriter.cdata(((Path)args.getTrustedSsl().getTrustStoreFile().getValue()).toString()));
        sb.append("</KeyStoreFile>");
        if (!args.getTrustedSsl().getTrustStorePassword().isEmpty()) {
            sb.append("<KeyStorePassword >");
            sb.append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getTrustedSsl().getTrustStorePassword().getValue()));
            sb.append("</KeyStorePassword>");
        }
        return sb;
    }

    private static StringBuilder generateProtocolFragmentPartSsl(SslArguments args) {
        StringBuilder sb = new StringBuilder();
        sb.append("<SSL>");
        if (args.getUntrustedSsl().isTrue()) {
            sb.append("<UntrustedSSL>");
            sb.append("<DisableCertificateHostnameVerification>");
            sb.append(YADEXMLJumpHostSettingsWriter.getOppositeValue((SOSArgument<Boolean>)args.getUntrustedSslVerifyCertificateHostname()));
            sb.append("</DisableCertificateHostnameVerification>");
            sb.append("</UntrustedSSL>");
        } else {
            sb.append("<TrustedSSL>");
            if (args.getTrustedSsl().isCustomTrustStoreEnabled()) {
                sb.append("<TrustStore>");
                sb.append("<TrustStoreType>");
                sb.append(YADEXMLJumpHostSettingsWriter.cdata(((KeyStoreType)args.getTrustedSsl().getTrustStoreType().getValue()).name()));
                sb.append("</TrustStoreType>");
                sb.append("<TrustStoreFile>");
                sb.append(YADEXMLJumpHostSettingsWriter.cdata(((Path)args.getTrustedSsl().getTrustStoreFile().getValue()).toString()));
                sb.append("</TrustStoreFile>");
                if (!args.getTrustedSsl().getTrustStorePassword().isEmpty()) {
                    sb.append("<TrustStorePassword >");
                    sb.append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getTrustedSsl().getTrustStorePassword().getValue()));
                    sb.append("</TrustStorePassword>");
                }
                sb.append("</TrustStore>");
            }
            if (args.getTrustedSsl().isCustomKeyStoreEnabled()) {
                sb.append("<KeyStore>");
                sb.append("<KeyStoreType>");
                sb.append(YADEXMLJumpHostSettingsWriter.cdata(((KeyStoreType)args.getTrustedSsl().getTrustStoreType().getValue()).name()));
                sb.append("</KeyStoreType>");
                sb.append("<KeyStoreFile>");
                sb.append(YADEXMLJumpHostSettingsWriter.cdata(((Path)args.getTrustedSsl().getTrustStoreFile().getValue()).toString()));
                sb.append("</KeyStoreFile>");
                if (!args.getTrustedSsl().getTrustStorePassword().isEmpty()) {
                    sb.append("<KeyStorePassword >");
                    sb.append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getTrustedSsl().getTrustStorePassword().getValue()));
                    sb.append("</KeyStorePassword>");
                }
                sb.append("</KeyStore>");
            }
            sb.append("<TrustedSSL>");
        }
        if (!args.getEnabledProtocols().isEmpty()) {
            sb.append("<EnabledProtocols>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getEnabledProtocols().getValue())).append("</EnabledProtocols>");
        }
        sb.append("</SSL>");
        return sb;
    }

    private static StringBuilder generateProtocolFragmentPartURLConnection(SOSArgument<String> host, SOSArgument<String> connectTimeout) {
        StringBuilder sb = new StringBuilder();
        sb.append("<URLConnection>");
        sb.append("<URL>").append(YADEXMLJumpHostSettingsWriter.cdata((String)host.getValue())).append("</URL>");
        if (connectTimeout.isDirty()) {
            sb.append("<ConnectTimeout>").append(YADEXMLJumpHostSettingsWriter.cdata((String)connectTimeout.getValue())).append("</ConnectTimeout>");
        }
        sb.append("</URLConnection>");
        return sb;
    }

    private static StringBuilder generateProtocolFragmentPartBasicConnection(SOSArgument<String> host, SOSArgument<Integer> port, SOSArgument<String> connectTimeout) {
        StringBuilder sb = new StringBuilder();
        sb.append("<BasicConnection>");
        sb.append("<Hostname>").append(YADEXMLJumpHostSettingsWriter.cdata((String)host.getValue())).append("</Hostname>");
        if (port.isDirty()) {
            sb.append("<Port>").append(YADEXMLJumpHostSettingsWriter.cdata(String.valueOf(port.getValue()))).append("</Port>");
        }
        if (connectTimeout.isDirty()) {
            sb.append("<ConnectTimeout>").append(YADEXMLJumpHostSettingsWriter.cdata((String)connectTimeout.getValue())).append("</ConnectTimeout>");
        }
        sb.append("</BasicConnection>");
        return sb;
    }

    private static StringBuilder generateProtocolFragmentPartBasicAuthentication(SOSArgument<String> user, SOSArgument<String> password) {
        StringBuilder sb = new StringBuilder();
        if (user.isEmpty()) {
            return sb;
        }
        sb.append("<BasicAuthentication>");
        sb.append("<Account>").append(YADEXMLJumpHostSettingsWriter.cdata((String)user.getValue())).append("</Account>");
        if (password.isDirty()) {
            sb.append("<Password>").append(YADEXMLJumpHostSettingsWriter.cdata((String)password.getValue())).append("</Password>");
        }
        sb.append("</BasicAuthentication>");
        return sb;
    }

    private static StringBuilder generateProfileSourceToJumpHost(YADEArguments args, YADEClientArguments clientArgs, YADESourceArguments sourceArgs, YADETargetArguments targetArgs, YADEEngineJumpHostAddon.JumpHostConfig config, String operation, boolean useTarget) {
        StringBuilder sb = new StringBuilder();
        sb.append("<Profile profile_id=").append(YADEXMLJumpHostSettingsWriter.attrValue(config.getProfileId())).append(">");
        sb.append("<Operation>");
        sb.append("<").append(operation).append(">");
        String sourcePrefix = operation + "Source";
        sb.append("<").append(sourcePrefix).append(">");
        sb.append("<").append(sourcePrefix).append("FragmentRef>");
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProfilePartTargetFragmentRef(sourceArgs));
        sb.append("</").append(sourcePrefix).append("FragmentRef>");
        sb.append("<SourceFileOptions>");
        sb.append("<Selection>");
        if (config.getSourceToJumpHost().getFileList() != null) {
            sb.append("<FileListSelection>");
            sb.append("<FileList>").append(YADEXMLJumpHostSettingsWriter.cdata(config.getSourceToJumpHost().getFileList().getJumpHostFile())).append("</FileList>");
            if (!sourceArgs.getDirectory().isEmpty()) {
                sb.append("<Directory>").append(YADEXMLJumpHostSettingsWriter.cdata((String)sourceArgs.getDirectory().getValue())).append("</Directory>");
            }
            if (sourceArgs.getRecursive().isTrue()) {
                sb.append("<Recursive>true</Recursive>");
            }
            sb.append("</FileListSelection>");
        } else if (sourceArgs.isFilePathEnabled()) {
            sb.append("<FilePathSelection>");
            sb.append("<FilePath>").append(YADEXMLJumpHostSettingsWriter.cdata(sourceArgs.getFilePathAsString())).append("</FilePath>");
            if (!sourceArgs.getDirectory().isEmpty()) {
                sb.append("<Directory>").append(YADEXMLJumpHostSettingsWriter.cdata((String)sourceArgs.getDirectory().getValue())).append("</Directory>");
            }
            if (sourceArgs.getRecursive().isTrue()) {
                sb.append("<Recursive>true</Recursive>");
            }
            sb.append("</FilePathSelection>");
        } else {
            sb.append("<FileSpecSelection>");
            sb.append("<FileSpec>").append(YADEXMLJumpHostSettingsWriter.cdata((String)sourceArgs.getFileSpec().getValue())).append("</FileSpec>");
            if (!sourceArgs.getDirectory().isEmpty()) {
                sb.append("<Directory>").append(YADEXMLJumpHostSettingsWriter.cdata((String)sourceArgs.getDirectory().getValue())).append("</Directory>");
            }
            if (!sourceArgs.getExcludedDirectories().isEmpty()) {
                sb.append("<ExcludedDirectories>").append(YADEXMLJumpHostSettingsWriter.cdata((String)sourceArgs.getExcludedDirectories().getValue())).append("</ExcludedDirectories>");
            }
            if (sourceArgs.getRecursive().isTrue()) {
                sb.append("<Recursive>true</Recursive>");
            }
            sb.append("</FileSpecSelection>");
        }
        sb.append("</Selection>");
        if (sourceArgs.isCheckSteadyStateEnabled()) {
            sb.append("<CheckSteadyState>");
            sb.append("<CheckSteadyStateInterval>");
            sb.append(YADEXMLJumpHostSettingsWriter.cdata((String)sourceArgs.getCheckSteadyStateInterval().getValue()));
            sb.append("</CheckSteadyStateInterval>");
            if (!sourceArgs.getCheckSteadyCount().isEmpty()) {
                sb.append("<CheckSteadyStateCount>");
                sb.append(sourceArgs.getCheckSteadyCount().getValue());
                sb.append("</CheckSteadyStateCount>");
            }
            sb.append("</CheckSteadyState>");
        }
        if (sourceArgs.isDirectivesEnabled()) {
            sb.append("<Directives>");
            if (sourceArgs.getErrorOnNoFilesFound().isDirty()) {
                sb.append("<DisableErrorOnNoFilesFound>");
                sb.append(YADEXMLJumpHostSettingsWriter.getOppositeValue(sourceArgs.getErrorOnNoFilesFound()));
                sb.append("</DisableErrorOnNoFilesFound>");
            }
            if (sourceArgs.getZeroByteTransfer().isDirty()) {
                sb.append("<TransferZeroByteFiles>");
                sb.append(YADEXMLJumpHostSettingsWriter.cdata(((YADESourceArguments.ZeroByteTransfer)((Object)sourceArgs.getZeroByteTransfer().getValue())).name()));
                sb.append("</TransferZeroByteFiles>");
            }
            sb.append("</Directives>");
        }
        if (sourceArgs.isPollingEnabled()) {
            sb.append("<Polling>");
            if (sourceArgs.getPolling().getPollInterval().isDirty()) {
                sb.append("<PollInterval>");
                sb.append(YADEXMLJumpHostSettingsWriter.cdata((String)sourceArgs.getPolling().getPollInterval().getValue()));
                sb.append("</PollInterval>");
            }
            if (sourceArgs.getPolling().getPollTimeout().isDirty()) {
                sb.append("<PollTimeout>");
                sb.append(sourceArgs.getPolling().getPollTimeout().getValue());
                sb.append("</PollTimeout>");
            }
            if (sourceArgs.getPolling().getPollMinFiles().isDirty()) {
                sb.append("<MinFiles>");
                sb.append(sourceArgs.getPolling().getPollMinFiles().getValue());
                sb.append("</MinFiles>");
            }
            if (sourceArgs.getPolling().getWaitingForLateComers().isDirty()) {
                sb.append("<WaitForSourceFolder>");
                sb.append(sourceArgs.getPolling().getWaitingForLateComers().getValue());
                sb.append("</WaitForSourceFolder>");
            }
            if (sourceArgs.getPolling().getPollingServer().isDirty()) {
                sb.append("<PollingServer>");
                sb.append(sourceArgs.getPolling().getPollingServer().getValue());
                sb.append("</PollingServer>");
            }
            if (sourceArgs.getPolling().getPollingServerDuration().isDirty()) {
                sb.append("<PollingServerDuration>");
                sb.append(YADEXMLJumpHostSettingsWriter.cdata((String)sourceArgs.getPolling().getPollingServerDuration().getValue()));
                sb.append("</PollingServerDuration>");
            }
            if (sourceArgs.getPolling().getPollingServerPollForever().isDirty()) {
                sb.append("<PollForever>");
                sb.append(sourceArgs.getPolling().getPollingServerPollForever().getValue());
                sb.append("</PollForever>");
            }
            sb.append("</Polling>");
        }
        if (config.getSourceToJumpHost().getResultSetFile() != null) {
            sb.append("<ResultSet>");
            sb.append("<ResultSetFile>").append(YADEXMLJumpHostSettingsWriter.cdata(config.getSourceToJumpHost().getResultSetFile().getJumpHostFile())).append("</ResultSetFile>");
            if (clientArgs.isCheckResultSetCountEnabled()) {
                sb.append("<CheckResultSetCount>");
                if (clientArgs.getExpectedResultSetCount().isDirty()) {
                    sb.append("<ExpectedResultSetCount>");
                    sb.append(clientArgs.getExpectedResultSetCount().getValue());
                    sb.append("</ExpectedResultSetCount>");
                }
                if (clientArgs.getRaiseErrorIfResultSetIs().isDirty()) {
                    sb.append("<RaiseErrorIfResultSetIs>");
                    sb.append(YADEXMLJumpHostSettingsWriter.cdata(((SOSComparisonOperator)clientArgs.getRaiseErrorIfResultSetIs().getValue()).getFirstAlias()));
                    sb.append("</RaiseErrorIfResultSetIs>");
                }
                sb.append("</CheckResultSetCount>");
            }
            sb.append("</ResultSet>");
        }
        if (sourceArgs.getMaxFiles().isDirty()) {
            sb.append("<MaxFiles>").append(sourceArgs.getMaxFiles().getValue()).append("</MaxFiles>");
        }
        if (sourceArgs.getCheckIntegrityHash().isTrue()) {
            sb.append("<CheckIntegrityHash>");
            sb.append("<HashAlgorithm>").append(YADEXMLJumpHostSettingsWriter.cdata((String)sourceArgs.getIntegrityHashAlgorithm().getValue())).append("</HashAlgorithm>");
            sb.append("</CheckIntegrityHash>");
        }
        sb.append("</SourceFileOptions>");
        sb.append("</").append(sourcePrefix).append(">");
        if (useTarget) {
            sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProfilePartJumpHostLocalCopyTarget(targetArgs, config));
            sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProfilePartTransferOptions(args, sourceArgs, config));
        }
        sb.append("</").append(operation).append(">");
        sb.append("</Operation>");
        sb.append("</Profile>");
        return sb;
    }

    private static StringBuilder generateProfileSourceToJumpHostMOVERemove(YADESourceArguments sourceArgs, YADEEngineJumpHostAddon.JumpHostConfig config, String profileId) {
        StringBuilder sb = new StringBuilder();
        sb.append("<Profile profile_id=").append(YADEXMLJumpHostSettingsWriter.attrValue(profileId)).append(">");
        sb.append("<Operation>");
        sb.append("<Remove>");
        sb.append("<RemoveSource>");
        sb.append("<RemoveSourceFragmentRef>");
        sb.append("<").append(YADEXMLJumpHostSettingsWriter.getFragmentNamePrefix((SOSArgument<AProviderArguments.Protocol>)sourceArgs.getProvider().getProtocol())).append("FragmentRef ref=");
        sb.append(YADEXMLJumpHostSettingsWriter.attrValue(FRAGMENT_NAME)).append(" />");
        sb.append("</RemoveSourceFragmentRef>");
        sb.append("<SourceFileOptions>");
        sb.append("<Selection>");
        sb.append("<FileListSelection>");
        sb.append("<FileList>").append(YADEXMLJumpHostSettingsWriter.cdata(config.getSourceToJumpHost().getResultSetFile().getJumpHostFile())).append("</FileList>");
        sb.append("<Directory>").append(YADEXMLJumpHostSettingsWriter.cdata(config.getDataDirectory())).append("</Directory>");
        sb.append("</FileListSelection>");
        sb.append("</Selection>");
        sb.append("</SourceFileOptions>");
        sb.append("</RemoveSource>");
        sb.append("</Remove>");
        sb.append("</Operation>");
        sb.append("</Profile>");
        return sb;
    }

    private static StringBuilder generateProfileJumpHostToTargetCOPY(YADEArguments args, YADETargetArguments targetArgs, YADEEngineJumpHostAddon.JumpHostConfig config) {
        StringBuilder sb = new StringBuilder();
        sb.append("<Profile profile_id=").append(YADEXMLJumpHostSettingsWriter.attrValue(config.getProfileId())).append(">");
        sb.append("<Operation>");
        sb.append("<Copy>");
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProfilePartJumpHostLocalCopySource(config));
        sb.append("<CopyTarget>");
        sb.append("<CopyTargetFragmentRef>");
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProfilePartTargetFragmentRef(targetArgs));
        sb.append("</CopyTargetFragmentRef>");
        if (targetArgs.getDirectory().isDirty()) {
            sb.append("<Directory>").append(YADEXMLJumpHostSettingsWriter.cdata((String)targetArgs.getDirectory().getValue())).append("</Directory>");
        }
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProfilePartTargetFileOptions(targetArgs, config));
        sb.append("</CopyTarget>");
        sb.append((CharSequence)YADEXMLJumpHostSettingsWriter.generateProfilePartTransferOptions(args, targetArgs, config));
        sb.append("</Copy>");
        sb.append("</Operation>");
        sb.append("</Profile>");
        return sb;
    }

    private static StringBuilder generateProfilePartJumpHostLocalCopySource(YADEEngineJumpHostAddon.JumpHostConfig config) {
        StringBuilder sb = new StringBuilder();
        sb.append("<CopySource>");
        sb.append("<CopySourceFragmentRef>");
        sb.append("<LocalSource ").append(YADEXMLJumpHostSettingsWriter.generateJumpAttribute()).append("/>");
        sb.append("</CopySourceFragmentRef>");
        sb.append("<SourceFileOptions>");
        sb.append("<Selection>");
        sb.append("<FileSpecSelection>");
        sb.append("<FileSpec><![CDATA[.*]]></FileSpec>");
        sb.append("<Directory>").append(YADEXMLJumpHostSettingsWriter.cdata(config.getDataDirectory())).append("</Directory>");
        sb.append("<Recursive>true</Recursive>");
        sb.append("</FileSpecSelection>");
        sb.append("</Selection>");
        sb.append("</SourceFileOptions>");
        sb.append("</CopySource>");
        return sb;
    }

    private static StringBuilder generateProfilePartJumpHostLocalCopyTarget(YADETargetArguments targetArgs, YADEEngineJumpHostAddon.JumpHostConfig config) {
        StringBuilder sb = new StringBuilder();
        sb.append("<CopyTarget>");
        sb.append("<CopyTargetFragmentRef>");
        sb.append("<LocalTarget ").append(YADEXMLJumpHostSettingsWriter.generateJumpAttribute()).append("/>");
        sb.append("</CopyTargetFragmentRef>");
        sb.append("<Directory>").append(YADEXMLJumpHostSettingsWriter.cdata(config.getDataDirectory())).append("</Directory>");
        sb.append("<TargetFileOptions>");
        sb.append("<KeepModificationDate>").append(targetArgs.getKeepModificationDate().getValue()).append("</KeepModificationDate>");
        sb.append("</TargetFileOptions>");
        sb.append("</CopyTarget>");
        return sb;
    }

    private static StringBuilder generateProfilePartTargetFragmentRef(YADESourceTargetArguments args) {
        String fragmentPrefix = YADEXMLJumpHostSettingsWriter.getFragmentNamePrefix((SOSArgument<AProviderArguments.Protocol>)args.getProvider().getProtocol());
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(fragmentPrefix).append("FragmentRef ref=").append(YADEXMLJumpHostSettingsWriter.attrValue(FRAGMENT_NAME)).append(">");
        if (args.getCommands().isPreProcessingEnabled()) {
            sb.append("<").append(fragmentPrefix).append("PreProcessing>");
            if (args.getCommands().getCommandsBeforeFile().isDirty()) {
                sb.append("<CommandBeforeFile enable_for_skipped_transfer=");
                sb.append(YADEXMLJumpHostSettingsWriter.attrValue("" + args.getCommands().getCommandsBeforeFileEnableForSkipped().getValue()));
                sb.append(">");
                sb.append(YADEXMLJumpHostSettingsWriter.cdata(args.getCommands().getCommandsBeforeFileAsString()));
                sb.append("</CommandBeforeFile>");
            }
            if (args.getCommands().getCommandsBeforeOperation().isDirty()) {
                sb.append("<CommandBeforeOperation>");
                sb.append(YADEXMLJumpHostSettingsWriter.cdata(args.getCommands().getCommandsBeforeOperationAsString()));
                sb.append("</CommandBeforeOperation>");
            }
            sb.append("</").append(fragmentPrefix).append("PreProcessing>");
        }
        if (args.getCommands().isPostProcessingEnabled()) {
            sb.append("<").append(fragmentPrefix).append("PostProcessing>");
            if (args.getCommands().getCommandsAfterFile().isDirty()) {
                sb.append("<CommandAfterFile disable_for_skipped_transfer=");
                sb.append(YADEXMLJumpHostSettingsWriter.attrValue("" + args.getCommands().getCommandsAfterFileDisableForSkipped().getValue()));
                sb.append(">");
                sb.append(YADEXMLJumpHostSettingsWriter.cdata(args.getCommands().getCommandsAfterFileAsString()));
                sb.append("</CommandAfterFile>");
            }
            if (args.getCommands().getCommandsAfterOperationOnSuccess().isDirty()) {
                sb.append("<CommandAfterOperationOnSuccess>");
                sb.append(YADEXMLJumpHostSettingsWriter.cdata(args.getCommands().getCommandsAfterOperationOnSuccessAsString()));
                sb.append("</CommandAfterOperationOnSuccess>");
            }
            if (args.getCommands().getCommandsAfterOperationOnError().isDirty()) {
                sb.append("<CommandAfterOperationOnError>");
                sb.append(YADEXMLJumpHostSettingsWriter.cdata(args.getCommands().getCommandsAfterOperationOnErrorAsString()));
                sb.append("</CommandAfterOperationOnError>");
            }
            if (args.getCommands().getCommandsAfterOperationFinal().isDirty()) {
                sb.append("<CommandAfterOperationFinal>");
                sb.append(YADEXMLJumpHostSettingsWriter.cdata(args.getCommands().getCommandsAfterOperationFinalAsString()));
                sb.append("</CommandAfterOperationFinal>");
            }
            if (args.getCommands().getCommandsBeforeRename().isDirty()) {
                sb.append("<CommandBeforeRename>");
                sb.append(YADEXMLJumpHostSettingsWriter.cdata(args.getCommands().getCommandsBeforeRenameAsString()));
                sb.append("</CommandBeforeRename>");
            }
            sb.append("</").append(fragmentPrefix).append("PostProcessing>");
        }
        if (args.getCommands().getCommandDelimiter().isDirty()) {
            sb.append("<ProcessingCommandDelimiter>");
            sb.append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getCommands().getCommandDelimiter().getValue()));
            sb.append("</ProcessingCommandDelimiter>");
        }
        if (args.isReplacementEnabled()) {
            sb.append("<Rename>");
            sb.append("<ReplaceWhat>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getReplacing().getValue())).append("</ReplaceWhat>");
            sb.append("<ReplaceWith>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getReplacement().getValue())).append("</ReplaceWith>");
            sb.append("</Rename>");
        }
        sb.append("</").append(fragmentPrefix).append("FragmentRef>");
        return sb;
    }

    private static StringBuilder generateProfilePartTargetFileOptions(YADETargetArguments args, YADEEngineJumpHostAddon.JumpHostConfig config) {
        StringBuilder sb = new StringBuilder();
        sb.append("<TargetFileOptions>");
        if (args.getAppendFiles().isDirty()) {
            sb.append("<AppendFiles>").append(args.getAppendFiles().getValue()).append("</AppendFiles>");
        }
        if (config.isAtomicEnabled()) {
            sb.append("<Atomicity>");
            if (config.getAtomicPrefix() != null) {
                sb.append("<AtomicPrefix>").append(YADEXMLJumpHostSettingsWriter.cdata(config.getAtomicPrefix())).append("</AtomicPrefix>");
            }
            if (config.getAtomicSuffix() != null) {
                sb.append("<AtomicSuffix>").append(YADEXMLJumpHostSettingsWriter.cdata(config.getAtomicSuffix())).append("</AtomicSuffix>");
            }
            sb.append("</Atomicity>");
        }
        if (args.getCheckSize().isDirty()) {
            sb.append("<CheckSize>").append(args.getCheckSize().getValue()).append("</CheckSize>");
        }
        if (args.isCumulateFilesEnabled()) {
            sb.append("<CumulateFiles>");
            sb.append("<CumulativeFileSeparator>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getCumulativeFileSeparator().getValue())).append("</CumulativeFileSeparator>");
            sb.append("<CumulativeFilename>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getCumulativeFileName().getValue())).append("</CumulativeFilename>");
            sb.append("<CumulativeFileDelete>").append(args.getCumulativeFileDelete().getValue()).append("</CumulativeFileDelete>");
            sb.append("</CumulateFiles>");
        }
        if (args.isCompressFilesEnabled()) {
            sb.append("<CompressFiles>");
            sb.append("<CompressedFileExtension>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getCompressedFileExtension().getValue())).append("</CompressedFileExtension>");
            sb.append("</CompressFiles>");
        }
        if (args.getCreateIntegrityHashFile().isTrue()) {
            sb.append("<CreateIntegrityHashFile>");
            sb.append("<HashAlgorithm>").append(YADEXMLJumpHostSettingsWriter.cdata((String)args.getIntegrityHashAlgorithm().getValue())).append("</HashAlgorithm>");
            sb.append("</CreateIntegrityHashFile>");
        }
        sb.append("<KeepModificationDate>").append(args.getKeepModificationDate().getValue()).append("</KeepModificationDate>");
        sb.append("<DisableMakeDirectories>").append(YADEXMLJumpHostSettingsWriter.getOppositeValue(args.getCreateDirectories())).append("</DisableMakeDirectories>");
        sb.append("<DisableOverwriteFiles>").append(YADEXMLJumpHostSettingsWriter.getOppositeValue(args.getOverwriteFiles())).append("</DisableOverwriteFiles>");
        sb.append("</TargetFileOptions>");
        return sb;
    }

    private static StringBuilder generateProfilePartTransferOptions(YADEArguments args, YADESourceTargetArguments sourceTargetArgs, YADEEngineJumpHostAddon.JumpHostConfig config) {
        StringBuilder sb = new StringBuilder();
        sb.append("<TransferOptions>");
        sb.append("<Transactional>").append(config.isTransactional()).append("</Transactional>");
        if (args.getBufferSize().isDirty()) {
            sb.append("<BufferSize>").append(args.getBufferSize().getValue()).append("</BufferSize>");
        }
        if (sourceTargetArgs.isRetryOnConnectionErrorEnabled()) {
            sb.append("<RetryOnConnectionError>");
            sb.append("<RetryCountMax>").append(sourceTargetArgs.getConnectionErrorRetryCountMax().getValue()).append("</RetryCountMax>");
            sb.append("<RetryInterval>").append(YADEXMLJumpHostSettingsWriter.cdata((String)sourceTargetArgs.getConnectionErrorRetryInterval().getValue())).append("</RetryInterval>");
            sb.append("</RetryOnConnectionError>");
        }
        sb.append("</TransferOptions>");
        return sb;
    }

    private static String getFragmentNamePrefix(SOSArgument<AProviderArguments.Protocol> protocol) {
        switch ((AProviderArguments.Protocol)protocol.getValue()) {
            case LOCAL: {
                return "Local";
            }
            case WEBDAV: 
            case WEBDAVS: {
                return "WebDAV";
            }
        }
        return ((AProviderArguments.Protocol)protocol.getValue()).name();
    }

    private static String generateJumpAttribute() {
        return "label=" + YADEXMLJumpHostSettingsWriter.attrValue("Jump");
    }

    private static String attrValue(String val) {
        return "\"" + val + "\"";
    }

    private static String cdata(String val) {
        return "<![CDATA[" + val + "]]>";
    }

    private static boolean getOppositeValue(SOSArgument<Boolean> arg) {
        return !arg.isTrue();
    }
}

