/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.operations.copymove.file.commons;

import com.sos.commons.util.SOSPathUtils;
import com.sos.yade.engine.commons.delegators.AYADEProviderDelegator;

public class YADEFileNameInfo {
    private String name;
    private String parent;
    private String path;
    private boolean absolutePath;
    private boolean replaced;

    public YADEFileNameInfo(AYADEProviderDelegator delegator, String fileNameOrPath, boolean wasReplaced) {
        String formatted = delegator.getProvider().toPathStyle(fileNameOrPath);
        if (delegator.containsParentPath(formatted)) {
            this.name = SOSPathUtils.getName((String)formatted);
            this.parent = delegator.getParentPath(formatted);
            this.path = delegator.appendPath(this.parent, this.name);
            this.absolutePath = delegator.getProvider().isAbsolutePath(this.parent);
        } else {
            this.name = formatted;
            this.parent = null;
            this.path = null;
            this.absolutePath = false;
        }
        this.replaced = wasReplaced;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public boolean needsParent() {
        return this.parent != null;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isAbsolutePath() {
        return this.absolutePath;
    }

    public boolean isReplaced() {
        return this.replaced;
    }
}

