/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.operations.copymove.file.helpers;

import com.sos.commons.util.SOSGzip;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.commons.YADEProviderFile;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADETargetProviderDelegator;
import com.sos.yade.engine.exceptions.YADEEngineTransferFileIntegrityHashViolationException;
import com.sos.yade.engine.handlers.operations.copymove.YADECopyMoveOperationsConfig;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class YADEChecksumFileHelper {
    public static MessageDigest initializeMessageDigest(YADECopyMoveOperationsConfig config, boolean create) {
        if (!create) {
            return null;
        }
        try {
            return MessageDigest.getInstance(config.getIntegrityHashAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static void updateMessageDigest(MessageDigest digest, byte[] data, boolean compressed) throws Exception {
        if (digest == null) {
            return;
        }
        if (compressed) {
            byte[] b = SOSGzip.compressBytes((byte[])data, (int)data.length);
            digest.update(b, 0, b.length);
        } else {
            digest.update(data);
        }
    }

    public static void updateMessageDigest(MessageDigest digest, byte[] data, int len, boolean compressed) throws Exception {
        if (digest == null) {
            return;
        }
        if (compressed) {
            byte[] b = SOSGzip.compressBytes((byte[])data, (int)len);
            digest.update(b, 0, b.length);
        } else {
            digest.update(data, 0, len);
        }
    }

    public static void checkSourceIntegrityHash(ISOSLogger logger, String fileTransferLogPrefix, YADECopyMoveOperationsConfig config, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, YADEProviderFile sourceFile, MessageDigest sourceMessageDigest) throws Exception {
        if (sourceMessageDigest == null) {
            return;
        }
        String sourceIntegrityHashFile = sourceFile.getFullPath() + config.getIntegrityHashFileExtensionWithDot();
        sourceFile.setIntegrityHash(sourceDelegator.getProvider().getFileContentIfExists(sourceIntegrityHashFile));
        String msg = String.format("%s][%s][%s][%s", fileTransferLogPrefix, sourceDelegator.getLabel(), sourceDelegator.getArgs().getCheckIntegrityHash().getName(), sourceIntegrityHashFile);
        if (sourceFile.getIntegrityHash() == null) {
            logger.info("[%s]file not found", new Object[]{msg});
            return;
        }
        String checksum = YADEChecksumFileHelper.toHexString(sourceMessageDigest);
        if (!sourceFile.getIntegrityHash().equals(checksum)) {
            targetDelegator.getProvider().deleteFileIfExists(sourceFile.getTarget().getFullPath());
            sourceFile.getTarget().setState(Yade.TransferEntryState.ROLLED_BACK);
            logger.info("[%s][%s][calculated=%s][integrity hash does not match]target file %s deleted", new Object[]{msg, sourceFile.getIntegrityHash(), checksum, sourceFile.getTarget().getFullPath()});
            throw new YADEEngineTransferFileIntegrityHashViolationException(String.format("[%s][%s][calculated]%s", msg, sourceFile.getIntegrityHash(), checksum));
        }
        logger.info("[%s]matches", new Object[]{msg});
    }

    public static void setTargetIntegrityHash(YADEProviderFile sourceFile, MessageDigest targetMessageDigest) {
        if (sourceFile.getTarget() == null || targetMessageDigest == null) {
            return;
        }
        sourceFile.getTarget().setIntegrityHash(YADEChecksumFileHelper.toHexString(targetMessageDigest));
    }

    private static String toHexString(MessageDigest digest) {
        if (digest == null) {
            return null;
        }
        byte[] b = digest.digest();
        char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int length = b.length * 2;
        StringBuilder sb = new StringBuilder(length);
        for (byte element : b) {
            sb.append(hexChar[(element & 0xF0) >>> 4]);
            sb.append(hexChar[element & 0xF]);
        }
        return sb.toString();
    }
}

