/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.handlers.operations.remove;

import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.commons.YADEProviderFile;
import com.sos.yade.engine.commons.arguments.YADEArguments;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.helpers.YADEClientBannerWriter;
import com.sos.yade.engine.commons.helpers.YADEParallelExecutorFactory;
import com.sos.yade.engine.exceptions.YADEEngineOperationException;
import com.sos.yade.engine.exceptions.YADEEngineRemoveFileException;
import com.sos.yade.engine.handlers.command.YADECommandExecutor;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class YADERemoveOperationHandler {
    public static void process(Yade.TransferOperation operation, ISOSLogger logger, YADEArguments args, YADESourceProviderDelegator sourceDelegator, List<ProviderFile> sourceFiles, AtomicBoolean cancel) throws YADEEngineOperationException {
        int sourceFilesSize = sourceFiles.size();
        int parallelism = YADEParallelExecutorFactory.getParallelism(args, sourceFilesSize);
        try {
            if (parallelism == 1) {
                YADERemoveOperationHandler.processFilesSequentially(logger, sourceDelegator, sourceFiles, cancel);
            } else {
                YADERemoveOperationHandler.processFilesInParallel(logger, sourceDelegator, sourceFiles, parallelism, sourceFilesSize, cancel);
            }
        }
        catch (Exception e) {
            throw new YADEEngineOperationException(e.getCause());
        }
    }

    private static void processFilesSequentially(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, List<ProviderFile> sourceFiles, AtomicBoolean cancel) throws Exception {
        for (ProviderFile sourceFile : sourceFiles) {
            if (cancel.get()) {
                return;
            }
            YADERemoveOperationHandler.run(logger, sourceDelegator, (YADEProviderFile)sourceFile, false);
        }
    }

    private static void processFilesInParallel(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, List<ProviderFile> sourceFiles, int parallelism, int sourceFilesSize, AtomicBoolean cancel) throws Exception {
        sourceDelegator.getProvider().disableReusableResource();
        ForkJoinPool threadPool = YADEParallelExecutorFactory.create(parallelism, sourceFilesSize);
        try {
            ((ForkJoinTask)threadPool.submit(() -> sourceFiles.parallelStream().forEach(sourceFile -> {
                if (cancel.get()) {
                    return;
                }
                try {
                    YADERemoveOperationHandler.run(logger, sourceDelegator, (YADEProviderFile)((Object)((Object)sourceFile)), true);
                }
                catch (Exception e) {
                    cancel.set(true);
                    throw new RuntimeException(e);
                }
            }))).join();
        }
        catch (Exception e) {
            throw new YADEEngineOperationException(YADERemoveOperationHandler.getRemoveFileException(e.getCause()));
        }
        finally {
            YADEParallelExecutorFactory.shutdown(threadPool);
        }
    }

    private static void run(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, YADEProviderFile sourceFile, boolean isParallelismEnabled) throws YADEEngineRemoveFileException {
        sourceFile.resetSteady();
        String fileTransferLogPrefix = !isParallelismEnabled ? String.valueOf(sourceFile.getIndex()) : sourceFile.getIndex() + "][" + Thread.currentThread().getName();
        try {
            YADECommandExecutor.executeBeforeFile(logger, sourceDelegator, sourceFile);
            if (!sourceDelegator.getProvider().deleteFileIfExists(sourceFile.getFullPath()) && logger.isDebugEnabled()) {
                logger.debug("[%s][%s][%s][%s]not exists", new Object[]{fileTransferLogPrefix, YADEClientBannerWriter.formatState(sourceFile.getState()), sourceDelegator.getLabel(), sourceFile.getFullPath()});
            }
            sourceFile.setState(Yade.TransferEntryState.DELETED);
            logger.info("[%s][%s][%s]%s", new Object[]{fileTransferLogPrefix, YADEClientBannerWriter.formatState(sourceFile.getState()), sourceDelegator.getLabel(), sourceFile.getFullPath()});
            YADECommandExecutor.executeAfterFile(logger, sourceDelegator, sourceFile);
        }
        catch (Throwable e) {
            sourceFile.setState(Yade.TransferEntryState.FAILED);
            String msg = String.format("[%s][%s][%s][%s]%s", fileTransferLogPrefix, YADEClientBannerWriter.formatState(sourceFile.getState()), sourceDelegator.getLabel(), sourceFile.getFullPath(), e);
            logger.error((Object)msg);
            throw new YADEEngineRemoveFileException(msg, e);
        }
    }

    private static Throwable getRemoveFileException(Throwable ex) {
        Throwable e;
        if (ex == null) {
            return ex;
        }
        for (e = ex; e != null; e = e.getCause()) {
            if (!(e instanceof YADEEngineRemoveFileException)) continue;
            return e;
        }
        return e;
    }
}

