/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class SOSCheckJavaVariableName {
    private static final List<String> javaReservedWords = Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");
    private static final Pattern controlCharsPattern = Pattern.compile("[\\x00-\\x1F\\x7F\\x80-\\x9F]");
    private static final Predicate<String> controlChars = controlCharsPattern.asPredicate();
    private static final Pattern spaceCharsPattern = Pattern.compile("\\s");
    private static final Predicate<String> spaceChars = spaceCharsPattern.asPredicate();
    private static final Pattern punctuationAndSymbolCharsPattern = Pattern.compile("[\\x21-\\x2C\\x2F\\x3A-\\x40\\x5B-\\x5E\\x60\\x7B-\\x7E\\xA0-\\xBF\\xD7\\xF7]");
    private static final Predicate<String> punctuationAndSymbolChars = punctuationAndSymbolCharsPattern.asPredicate();
    private static final Pattern halfFullWidthPunctuationAndSymbolCharsPattern = Pattern.compile("[\\uFF01-\\uFF0C\\uFFFF\\uFF1A-\\uFF20\\uFF3B-\\uFF3E\\uFF40\\uFF5B-\\uFF60\\uFF62-\\uFF65\\uFFE0-\\uFFEE]");
    private static final Predicate<String> halfFullWidthPunctuationAndSymbolChars = halfFullWidthPunctuationAndSymbolCharsPattern.asPredicate();
    private static final Pattern leadingHyphensDotsAndUnderlinesPattern = Pattern.compile("^[_.-]");
    private static final Predicate<String> leadingHyphensDotsAndUnderlines = leadingHyphensDotsAndUnderlinesPattern.asPredicate();
    private static final Pattern trailingHyphensAndDotsPattern = Pattern.compile("[.-]$");
    private static final Predicate<String> trailingHyphensAndDots = trailingHyphensAndDotsPattern.asPredicate();
    private static final Pattern consecutiveHyphensAndDotsPattern = Pattern.compile("\\.\\.+|--+");
    private static final Predicate<String> consecutiveHyphensAndDots = consecutiveHyphensAndDotsPattern.asPredicate();
    private static final Map<Result, String> errorMessages = Collections.unmodifiableMap(new HashMap<Result, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Result.CONTROL, "Control characters are not allowed in '%s': '%s'");
            this.put(Result.PUNCTUATION, "Punctuations (except '_', '-' and '.') or symbols are not allowed in '%s': '%s'");
            this.put(Result.RESERVED, "'%s': '%s' is a reserved word and must not be used");
            this.put(Result.EMPTY, "'%s' must not be empty");
            this.put(Result.LEADING, "'%s': '%s' must not begin with a hyphen, dot or underline");
            this.put(Result.TRAILING, "'%s': '%s' must not end with a hyphen or dot");
            this.put(Result.IN_A_ROW, "'%s': '%s' must not contain consecutive hyphens or dots");
            this.put(Result.SPACE, "Spaces are not allowed in '%s': '%s'");
        }
    });

    public static boolean test(String value) {
        return SOSCheckJavaVariableName.check(value) == null;
    }

    public static String check(String value) {
        if (value == null || value.isEmpty()) {
            return errorMessages.get((Object)Result.EMPTY);
        }
        if (spaceChars.test(value)) {
            return errorMessages.get((Object)Result.SPACE);
        }
        if (punctuationAndSymbolChars.test(value)) {
            return errorMessages.get((Object)Result.PUNCTUATION);
        }
        if (halfFullWidthPunctuationAndSymbolChars.test(value)) {
            return errorMessages.get((Object)Result.PUNCTUATION);
        }
        if (leadingHyphensDotsAndUnderlines.test(value)) {
            return errorMessages.get((Object)Result.LEADING);
        }
        if (trailingHyphensAndDots.test(value)) {
            return errorMessages.get((Object)Result.TRAILING);
        }
        if (consecutiveHyphensAndDots.test(value)) {
            return errorMessages.get((Object)Result.IN_A_ROW);
        }
        if (controlChars.test(value)) {
            return errorMessages.get((Object)Result.CONTROL);
        }
        if (javaReservedWords.contains(value)) {
            return errorMessages.get((Object)Result.RESERVED);
        }
        return null;
    }

    public static String checkFolder(String value) {
        String v;
        if (value != null && !value.isEmpty() && !(v = value.replaceAll("[\\\\/]", "")).isEmpty()) {
            return SOSCheckJavaVariableName.check(v);
        }
        return null;
    }

    public static String makeStringRuleConform(String value) {
        if (value == null || ((String)value).isEmpty()) {
            return "";
        }
        value = controlCharsPattern.matcher((CharSequence)value).replaceAll("");
        value = punctuationAndSymbolCharsPattern.matcher((CharSequence)value).replaceAll("");
        value = halfFullWidthPunctuationAndSymbolCharsPattern.matcher((CharSequence)value).replaceAll("");
        value = ((String)value).replaceAll("\\s+", "-");
        value = ((String)value).replaceAll("--+", "-");
        value = ((String)value).replaceAll("\\.\\.+", ".");
        value = leadingHyphensDotsAndUnderlinesPattern.matcher((CharSequence)value).replaceAll("");
        if (javaReservedWords.contains(value = trailingHyphensAndDotsPattern.matcher((CharSequence)value).replaceAll(""))) {
            value = ((String)value).substring(0, 1).toUpperCase() + ((String)value).substring(1);
        }
        return value;
    }

    public static void test(String key, String value) throws IllegalArgumentException {
        String errorMessage = SOSCheckJavaVariableName.check(value);
        if (errorMessage != null) {
            throw new IllegalArgumentException(String.format(errorMessage, key, value));
        }
    }

    public static void testFolder(String key, String value) throws IllegalArgumentException {
        String errorMessage = SOSCheckJavaVariableName.checkFolder(value);
        if (errorMessage != null) {
            throw new IllegalArgumentException(String.format(errorMessage, key, value));
        }
    }

    private static enum Result {
        CONTROL,
        PUNCTUATION,
        DIGIT,
        SPACE,
        LEADING,
        TRAILING,
        IN_A_ROW,
        RESERVED,
        EMPTY,
        OK;

    }
}

