/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import com.sos.commons.util.SOSDate;
import com.sos.commons.util.SOSPath;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSGzip {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSGzip.class);
    private static final int BUFFER_SIZE = 8192;

    public static SOSGzipResult compress(Path source, boolean setAllFileAttributes) throws Exception {
        if (source == null) {
            throw new Exception("missing path");
        }
        if (SOSPath.toFile(source).isFile()) {
            return SOSGzip.gzipCompressFile(source);
        }
        return SOSGzip.gzipTarCompressDirectory(source, setAllFileAttributes);
    }

    private static SOSGzipResult gzipCompressFile(Path source) throws Exception {
        SOSGzipResult result = new SOSGzip().new SOSGzipResult();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             InputStream fis = Files.newInputStream(source, new OpenOption[0]);
             GZIPOutputStream gos = new GZIPOutputStream(bos);){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = fis.read(buffer)) > 0) {
                gos.write(buffer, 0, len);
            }
            gos.finish();
            result.addFile(source);
            result.setCompressed(bos.toByteArray());
            result.finisch();
        }
        return result;
    }

    public static byte[] compressBytes(byte[] data, int len) throws Exception {
        if (data == null) {
            return null;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(len);){
            byte[] byArray;
            try (GZIPOutputStream gos = new GZIPOutputStream(bos);){
                gos.write(data, 0, len);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    private static SOSGzipResult gzipTarCompressDirectory(Path source, boolean setAllFileAttributes) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static SOSGzipResult decompress(Path source, Path targetDir, boolean setLastModifiedTime) throws Exception {
        if (source == null || !SOSPath.toFile(source).isFile()) {
            throw new Exception(String.format("[%s]is not a file", source));
        }
        return SOSGzip.decompress(Files.newInputStream(source, new OpenOption[0]), targetDir, setLastModifiedTime);
    }

    public static SOSGzipResult decompress(byte[] source, Path targetDir, boolean setLastModifiedTime) throws Exception {
        return SOSGzip.decompress(new ByteArrayInputStream(source), targetDir, setLastModifiedTime);
    }

    public static SOSGzipResult decompress(InputStream source, Path targetDir, boolean setLastModifiedTime) throws Exception {
        InputStream inputStream = null;
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        SOSGzipResult result = new SOSGzip().new SOSGzipResult();
        try {
            Path target = targetDir.toAbsolutePath();
            inputStream = new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(source)));
            result.addDirectory(target);
            try (TarArchiveInputStream tis = new TarArchiveInputStream(inputStream);){
                TarArchiveEntry entry = tis.getNextEntry();
                while (entry != null) {
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[decompress][entry]%s", entry.getName()));
                    }
                    Path outputPath = target.resolve(entry.getName());
                    if (entry.isDirectory()) {
                        Files.createDirectories(outputPath, new FileAttribute[0]);
                        result.addDirectory(outputPath);
                    } else {
                        Path parent = outputPath.getParent();
                        if (parent != null) {
                            String p = parent.toString();
                            if (!result.getDirectories().contains(p)) {
                                Files.createDirectories(parent, new FileAttribute[0]);
                                result.addDirectory(parent);
                            }
                        }
                        try (OutputStream out = Files.newOutputStream(outputPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                            tis.transferTo(out);
                        }
                        result.addFile(outputPath);
                        if (setLastModifiedTime) {
                            try {
                                SOSPath.setLastModifiedTime(outputPath, entry.getLastModifiedDate());
                            }
                            catch (Throwable e) {
                                LOGGER.warn(String.format("[decompress][setLastModifiedTime][%s=%s]%s", entry.getName(), entry.getLastModifiedDate(), e.toString()), e);
                            }
                        }
                    }
                    entry = tis.getNextEntry();
                }
            }
            result.getDirectories().remove(target.toString());
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn(e.toString(), (Throwable)e);
                }
            }
            if (source != null) {
                try {
                    source.close();
                }
                catch (Throwable throwable) {}
            }
        }
        result.finisch();
        return result;
    }

    public class SOSGzipResult {
        private final Instant start;
        private Instant end;
        private byte[] compressed = null;
        private Set<String> files = new HashSet<String>();
        private Set<String> directories = new HashSet<String>();

        protected SOSGzipResult() {
            this.start = Instant.now();
        }

        protected void finisch() {
            this.end = Instant.now();
        }

        protected void setCompressed(byte[] val) {
            this.compressed = val;
        }

        public byte[] getCompressed() {
            return this.compressed;
        }

        protected void addFile(Path p) {
            this.files.add(p.toString());
        }

        public Set<String> getFiles() {
            return this.files;
        }

        protected void addDirectory(Path p) {
            this.directories.add(p.toString());
        }

        public Set<String> getDirectories() {
            return this.directories;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("directories=").append(this.directories.size());
            sb.append(",files=").append(this.files.size());
            if (this.compressed != null) {
                sb.append(",compressed=").append(this.compressed.length).append("b");
            }
            if (this.end != null) {
                sb.append(",duration=").append(SOSDate.getDuration(this.start, this.end));
            }
            return sb.toString();
        }
    }
}

