/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import com.sos.commons.exception.SOSNoSuchFileException;
import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.SOSDate;
import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.SOSString;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSPath {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSPath.class);
    static final int BUFF_SIZE = 100000;
    static final byte[] buffer = new byte[100000];

    public static boolean canReadFile(Path file) throws IOException, InterruptedException {
        boolean rep = true;
        int repeatCount = 5;
        while (rep && repeatCount >= 0) {
            try {
                if (!Files.exists(file, new LinkOption[0])) {
                    throw new FileNotFoundException("..file does not exist: " + file.toString());
                }
                OutputStream f = Files.newOutputStream(file, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
                f.close();
                rep = false;
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                if (repeatCount == 0) {
                    throw e;
                }
                LOGGER.debug("trial " + (5 - --repeatCount) + " of 5 to access file: " + file.toString());
                Thread.sleep(1000L);
            }
        }
        return !rep;
    }

    public static boolean isWritable(Path path) {
        if (path == null) {
            return false;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return Files.isWritable(path) && Files.isExecutable(path);
        }
        return Files.isWritable(path);
    }

    public static void appendFile(Path source, Path dest) throws IOException {
        SOSPath.copyFile(source, dest, true);
    }

    public static void copyFile(Path source, Path dest) throws IOException {
        SOSPath.copyFile(source, dest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void copyFile(Path source, Path dest, boolean append) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            LOGGER.debug("Copying file " + source.toString() + " with buffer of 100000 bytes");
            in = Files.newInputStream(source, new OpenOption[0]);
            out = append ? Files.newOutputStream(dest, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND) : Files.newOutputStream(dest, new OpenOption[0]);
            while (true) {
                byte[] byArray = buffer;
                // MONITORENTER : buffer
                int amountRead = in.read(buffer);
                if (amountRead == -1) {
                    // MONITOREXIT : byArray
                    return;
                }
                out.write(buffer, 0, amountRead);
                // MONITOREXIT : byArray
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void copyFile(String source, String dest) throws IOException {
        SOSPath.copyFile(source, dest, false);
    }

    public static void copyFile(String source, String dest, boolean append) throws IOException {
        SOSPath.copyFile(Paths.get(source, new String[0]), Paths.get(dest, new String[0]), append);
    }

    public static void delete(Path path) throws IOException, SOSNoSuchFileException {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            throw new SOSNoSuchFileException(path);
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                for (Path p : stream.sorted(Comparator.reverseOrder()).collect(Collectors.toList())) {
                    Files.delete(p);
                }
            }
        } else {
            Files.delete(path);
        }
    }

    public static boolean deleteIfExists(Path path) throws Exception {
        try {
            SOSPath.delete(path);
            return true;
        }
        catch (SOSNoSuchFileException e) {
            return false;
        }
    }

    public static SOSPathResult cleanupDirectory(Path dir) throws IOException {
        SOSPathResult result = new SOSPath().new SOSPathResult();
        if (dir == null) {
            return result;
        }
        Path sourceDir = dir.toAbsolutePath();
        if (Files.exists(sourceDir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(sourceDir, new FileVisitOption[0]);){
                for (Path p : stream.sorted(Comparator.reverseOrder()).filter(f -> !f.equals(sourceDir)).collect(Collectors.toList())) {
                    try {
                        File f2 = p.toFile();
                        if (f2.isDirectory()) {
                            result.addDirectory(p);
                        } else {
                            result.addFile(p);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Files.delete(p);
                }
            }
        }
        result.finisch();
        return result;
    }

    public static long getLineCount(Path file) throws IOException {
        long result;
        try (Stream<String> stream = Files.lines(file);){
            result = stream.count();
        }
        return result;
    }

    public static Stream<Path> getFilesStream(String folder, String regexp, int flag) throws IOException {
        return SOSPath.getFilesStream(folder, regexp, flag, false);
    }

    public static Stream<Path> getFilesStream(Path folder, String regexp, int flag) throws IOException {
        return SOSPath.getFilesStream(folder, regexp, flag, false);
    }

    public static Stream<Path> getFilesStream(String folder, String regexp, int flag, boolean withSubFolder) throws IOException {
        if (folder == null || folder.isEmpty()) {
            throw new FileNotFoundException("empty directory not allowed!!");
        }
        return SOSPath.getFilesStream(Paths.get(folder, new String[0]), regexp, flag, withSubFolder);
    }

    public static Stream<Path> getFilesStream(Path folder, String regexp, int flag, boolean withSubFolder) throws IOException {
        if (folder == null) {
            throw new FileNotFoundException("empty directory not allowed!!");
        }
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            throw new FileNotFoundException("directory does not exist: " + folder.toString());
        }
        Predicate<Path> predicate = p -> !Files.isDirectory(p, new LinkOption[0]);
        if (regexp != null) {
            Pattern pattern = Pattern.compile(regexp, flag);
            predicate = p -> !Files.isDirectory(p, new LinkOption[0]) && pattern.matcher(p.getFileName().toString()).find();
        }
        if (withSubFolder) {
            return Files.walk(folder, new FileVisitOption[0]).filter(predicate);
        }
        return Files.list(folder).filter(predicate);
    }

    public static List<Path> getFileList(String folder) throws IOException {
        return SOSPath.getFilesStream(folder, null, 0).collect(Collectors.toList());
    }

    public static List<Path> getFileList(Path folder) throws IOException {
        return SOSPath.getFilesStream(folder, null, 0).collect(Collectors.toList());
    }

    public static List<Path> getFileList(String folder, String regexp, int flag) throws IOException {
        return SOSPath.getFilesStream(folder, regexp, flag).collect(Collectors.toList());
    }

    public static List<Path> getFileList(Path folder, String regexp, int flag) throws IOException {
        return SOSPath.getFilesStream(folder, regexp, flag).collect(Collectors.toList());
    }

    public static List<Path> getFileList(String folder, String regexp, int flag, boolean withSubFolder) throws IOException {
        return SOSPath.getFilesStream(folder, regexp, flag, withSubFolder).collect(Collectors.toList());
    }

    public static List<Path> getFileList(Path folder, String regexp, int flag, boolean withSubFolder) throws IOException {
        return SOSPath.getFilesStream(folder, regexp, flag, withSubFolder).collect(Collectors.toList());
    }

    public static Stream<Path> getFolderStream(String folder) throws IOException {
        return SOSPath.getFolderStream(folder, null, 0, false);
    }

    public static Stream<Path> getFolderStream(Path folder) throws IOException {
        return SOSPath.getFolderStream(folder, null, 0, false);
    }

    public static Stream<Path> getFolderStream(String folder, String regexp, int flag) throws IOException {
        return SOSPath.getFolderStream(folder, regexp, flag, false);
    }

    public static Stream<Path> getFolderStream(Path folder, String regexp, int flag) throws IOException {
        return SOSPath.getFolderStream(folder, regexp, flag, false);
    }

    public static Stream<Path> getFolderStream(String folder, String regexp, int flag, boolean withSubFolder) throws IOException {
        if (folder == null || folder.isEmpty()) {
            throw new FileNotFoundException("empty directory not allowed!!");
        }
        return SOSPath.getFolderStream(Paths.get(folder, new String[0]), regexp, flag, withSubFolder);
    }

    public static Stream<Path> getFolderStream(Path folder, String regexp, int flag, boolean withSubFolder) throws IOException {
        if (folder == null) {
            throw new FileNotFoundException("empty directory not allowed!!");
        }
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            throw new FileNotFoundException("directory does not exist: " + folder.toString());
        }
        Predicate<Path> predicate = p -> !".".equals(p.getFileName().toString()) && !"..".equals(p.getFileName().toString());
        if (regexp != null) {
            Pattern pattern = Pattern.compile(regexp, flag);
            predicate = p -> pattern.matcher(p.getFileName().toString()).find() && !".".equals(p.getFileName().toString()) && !"..".equals(p.getFileName().toString());
        }
        if (withSubFolder) {
            return Files.walk(folder, new FileVisitOption[0]).filter(predicate);
        }
        return Files.list(folder).filter(predicate);
    }

    public static List<Path> getFolderList(String folder) throws IOException {
        return SOSPath.getFolderStream(folder).collect(Collectors.toList());
    }

    public static List<Path> getFolderList(String folder, String regexp, int flag) throws IOException {
        return SOSPath.getFolderStream(folder, regexp, flag).collect(Collectors.toList());
    }

    public static List<Path> getFolderList(Path folder) throws IOException {
        return SOSPath.getFolderStream(folder).collect(Collectors.toList());
    }

    public static List<Path> getFolderList(Path folder, String regexp, int flag) throws IOException {
        return SOSPath.getFolderStream(folder, regexp, flag).collect(Collectors.toList());
    }

    public static List<Path> getFolderList(String folder, String regexp, int flag, boolean withSubFolder) throws IOException {
        return SOSPath.getFolderStream(folder, regexp, flag, withSubFolder).collect(Collectors.toList());
    }

    public static List<Path> getFolderList(Path folder, String regexp, int flag, boolean withSubFolder) throws IOException {
        return SOSPath.getFolderStream(folder, regexp, flag, withSubFolder).collect(Collectors.toList());
    }

    public static String readFile(Path source) throws IOException {
        return SOSPath.readFile(source, StandardCharsets.UTF_8);
    }

    public static String readFile(Path source, Charset charset) throws IOException {
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        return new String(Files.readAllBytes(source), charset);
    }

    public static String readFile(Path file, Collector<? super String, ?, String> collector) throws IOException {
        String result;
        try (Stream<String> stream = Files.lines(file);){
            result = stream.collect(collector);
        }
        return result;
    }

    public static List<String> readFileNonEmptyLines(Path path) throws IOException {
        return SOSPath.readFileNonEmptyLines(path, StandardCharsets.UTF_8);
    }

    public static List<String> readFileNonEmptyLines(Path path, Charset charset) throws IOException {
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        try (Stream<String> lines = Files.lines(path, charset);){
            List<String> list = lines.filter(line -> !line.trim().isEmpty()).collect(Collectors.toList());
            return list;
        }
    }

    public static void renameTo(Path source, Path target) throws IOException {
        LOGGER.debug("..trying to move File " + source.toString() + " to " + target.toString());
        if (!Files.exists(target, new LinkOption[0])) {
            try {
                Files.move(source, target, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(source, target, new CopyOption[0]);
            }
        } else {
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void renameTo(String source, String target) throws IOException {
        SOSPath.renameTo(SOSPath.toAbsolutePath(source), SOSPath.toAbsolutePath(target));
    }

    public static String subFileMask(String filespec, String substitute) throws IOException {
        if (filespec == null) {
            throw new IOException("file specification is null.");
        }
        String retVal = new String();
        int ipos1 = filespec.indexOf("[");
        int ipos2 = filespec.lastIndexOf("]");
        if (ipos1 == -1 || ipos2 == -1) {
            return filespec;
        }
        String midStr = new String();
        String startStr = new String();
        String endStr = new String();
        if (ipos1 != 0) {
            startStr = filespec.substring(0, ipos1);
        }
        midStr = substitute.concat(filespec.substring(ipos2 + 1, filespec.length()));
        retVal = startStr.concat(midStr).concat(endStr);
        return retVal;
    }

    public static String getFileNameWithoutExtension(Path path) {
        if (path != null) {
            return path.getFileName().toString().replaceFirst("\\.[^.]+$", "");
        }
        return null;
    }

    public static String getBasename(Path path) {
        if (path != null) {
            return path.getFileName().toString();
        }
        return null;
    }

    public static File toFile(Path file) {
        return file.isAbsolute() ? file.toFile() : file.toAbsolutePath().toFile();
    }

    public static Path toAbsolutePath(String file) {
        Path p = Paths.get(file, new String[0]);
        return p.isAbsolute() ? p : p.toAbsolutePath();
    }

    public static Path toAbsoluteNormalizedPath(String file) {
        return SOSPath.toAbsoluteNormalizedPath(Paths.get(file, new String[0]));
    }

    public static Path toAbsoluteNormalizedPath(Path path) {
        return path.isAbsolute() ? path.normalize() : path.toAbsolutePath().normalize();
    }

    public static boolean isRegularFile(String path) throws Exception {
        return SOSPath.isRegularFile(SOSPath.toAbsolutePath(path));
    }

    public static boolean isRegularFile(Path path) throws Exception {
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    public static boolean isDirectory(String path) throws Exception {
        return SOSPath.isDirectory(SOSPath.toAbsolutePath(path));
    }

    public static boolean isDirectory(Path path) throws Exception {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public static long getFileSize(String path) throws Exception {
        return SOSPath.getFileSize(SOSPath.toAbsolutePath(path));
    }

    public static long getFileSize(Path path) throws Exception {
        return Files.size(path);
    }

    public static long getLastModifiedMillis(String path) throws Exception {
        return SOSPath.getLastModifiedMillis(SOSPath.toAbsolutePath(path));
    }

    public static long getLastModifiedMillis(Path path) throws Exception {
        return Files.getLastModifiedTime(path, new LinkOption[0]).to(TimeUnit.MILLISECONDS);
    }

    public static void setLastModifiedFromMillis(String path, long milliseconds) throws Exception {
        SOSPath.setLastModifiedFromMillis(SOSPath.toAbsolutePath(path), milliseconds);
    }

    public static void setLastModifiedFromMillis(Path path, long milliseconds) throws Exception {
        Files.setLastModifiedTime(path, FileTime.fromMillis(milliseconds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean endsWithNewLine(Path file) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(SOSPath.toFile(file), "r");
            long len = raf.length() - 1L;
            if (len < 0L) {
                boolean bl = true;
                return bl;
            }
            raf.seek(len);
            byte readByte = raf.readByte();
            if (readByte == 10 || readByte == 13) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static boolean endsWithNewLine(String content) throws IOException {
        if (SOSString.isEmpty(content)) {
            return false;
        }
        return content.endsWith("\n") || content.endsWith("\r");
    }

    public static File getMostRecentFile(Path dir) {
        return Arrays.stream(SOSPath.toFile(dir).listFiles()).filter(f -> f.isFile()).max((f1, f2) -> Long.compare(f1.lastModified(), f2.lastModified())).orElse(null);
    }

    public static void setLastModifiedTime(Path path, Date date) throws Exception {
        if (path == null || date == null) {
            return;
        }
        Files.setLastModifiedTime(path, FileTime.fromMillis(date.getTime()));
    }

    public static Date getLastModified(Path path) {
        if (path == null) {
            return null;
        }
        return new Date(path.toAbsolutePath().toFile().lastModified());
    }

    public static long getCountSubfolders(Path dir, int maxDepth) throws IOException {
        long count = 0L;
        Path sourceDir = dir.toAbsolutePath();
        try (Stream<Path> stream = Files.find(sourceDir, maxDepth, (path, attributes) -> attributes.isDirectory(), new FileVisitOption[0]);){
            count = stream.count() - 1L;
        }
        return count;
    }

    public static boolean isDirectoryEmpty(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> entries = Files.list(path);){
                boolean bl = !entries.findFirst().isPresent();
                return bl;
            }
        }
        return false;
    }

    public static StringBuilder readFirstLastBytes(Path file, int firstBytes2read, int lastBytes2read, StringBuilder msgBetweenFirstLast) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean readLastBytes = true;
        try (SeekableByteChannel ch = Files.newByteChannel(file, new OpenOption[0]);){
            long total = ch.size();
            if (firstBytes2read > 0) {
                if ((long)firstBytes2read >= total) {
                    readLastBytes = false;
                }
                sb.append((CharSequence)SOSPath.readFirstLastBytes(ch, firstBytes2read, true));
            }
            if (readLastBytes && lastBytes2read > 0 && total - (long)lastBytes2read > 0L) {
                if (firstBytes2read > 0 && msgBetweenFirstLast != null) {
                    sb.append((CharSequence)msgBetweenFirstLast);
                }
                ch.position(total - (long)lastBytes2read);
                sb.append((CharSequence)SOSPath.readFirstLastBytes(ch, lastBytes2read, false));
            }
        }
        return sb;
    }

    private static StringBuilder readFirstLastBytes(SeekableByteChannel ch, int bytes2read, boolean firstBytes) throws IOException {
        int bufferSize = 8192;
        if (bufferSize > bytes2read) {
            bufferSize = bytes2read;
        }
        int totalBufferAllocated = 0;
        boolean end = false;
        StringBuilder sb = new StringBuilder();
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        while (ch.read(buffer) > 0) {
            buffer.flip();
            int limit = buffer.limit();
            if (firstBytes && (totalBufferAllocated += bufferSize) > bytes2read) {
                limit -= totalBufferAllocated - bytes2read;
                end = true;
            }
            for (int i = 0; i < limit; ++i) {
                sb.append((char)buffer.get());
            }
            if (end) {
                buffer = ByteBuffer.allocate(0);
                continue;
            }
            if (totalBufferAllocated >= bytes2read) continue;
            buffer.clear();
        }
        return sb;
    }

    public static void append(Path outputFile, String content) throws Exception {
        SOSPath.append(outputFile, content, (String)null);
    }

    public static void appendLine(Path outputFile, String content) throws Exception {
        SOSPath.append(outputFile, content, System.lineSeparator());
    }

    public static void append(Path outputFile, String content, String newLine) throws Exception {
        SOSPath.append(outputFile, content, newLine, StandardCharsets.UTF_8);
    }

    public static void append(Path outputFile, String content, Charset cs) throws Exception {
        SOSPath.append(outputFile, content, null, cs);
    }

    public static void appendLine(Path outputFile, String content, Charset cs) throws Exception {
        SOSPath.append(outputFile, content, System.lineSeparator(), cs);
    }

    public static void append(Path outputFile, String content, String newLine, Charset cs) throws Exception {
        SOSPath.write(outputFile, content, newLine, cs, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }

    public static void overwrite(Path outputFile, String content) throws Exception {
        SOSPath.overwrite(outputFile, content, (String)null);
    }

    public static void overwriteWithNewLine(Path outputFile, String content) throws Exception {
        SOSPath.overwrite(outputFile, content, System.lineSeparator());
    }

    public static void overwrite(Path outputFile, String content, String newLine) throws Exception {
        SOSPath.overwrite(outputFile, content, newLine, StandardCharsets.UTF_8);
    }

    public static void overwrite(Path outputFile, String content, Charset cs) throws Exception {
        SOSPath.overwrite(outputFile, content, null, cs);
    }

    public static void overwriteWithNewLine(Path outputFile, String content, Charset cs) throws Exception {
        SOSPath.overwrite(outputFile, content, System.lineSeparator(), cs);
    }

    public static void overwrite(Path outputFile, String content, String newLine, Charset cs) throws Exception {
        SOSPath.write(outputFile, content, newLine, cs, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static void write(Path outputFile, String content, List<OpenOption> openOptions) throws Exception {
        SOSPath.write(outputFile, content, null, StandardCharsets.UTF_8, openOptions == null ? null : (OpenOption[])openOptions.stream().toArray(OpenOption[]::new));
    }

    public static void write(Path outputFile, String content, String newLine, Charset cs, OpenOption ... openOptions) throws Exception {
        OpenOption[] openOptionArray;
        if (openOptions == null) {
            OpenOption[] openOptionArray2 = new OpenOption[1];
            openOptionArray = openOptionArray2;
            openOptionArray2[0] = StandardOpenOption.CREATE;
        } else {
            openOptionArray = openOptions;
        }
        OpenOption[] op = openOptionArray;
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile, cs == null ? StandardCharsets.UTF_8 : cs, op);){
            writer.write(content);
            writer.flush();
            if (newLine != null) {
                writer.write(newLine);
            }
        }
    }

    public static Set<Path> selectTopLevelPaths(Collection<Path> paths) {
        if (SOSCollection.isEmpty(paths)) {
            return new TreeSet<Path>();
        }
        return SOSPathUtils.selectTopLevelPaths(paths).stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toCollection(TreeSet::new));
    }

    public static Set<Path> selectDeepestLevelPaths(Collection<Path> paths) {
        if (SOSCollection.isEmpty(paths)) {
            return new TreeSet<Path>();
        }
        return SOSPathUtils.selectDeepestLevelPaths(paths).stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toCollection(TreeSet::new));
    }

    public static void main(String[] args) throws Exception {
        Path input = null;
        int sleep = 1;
        if (args.length <= 1) {
            return;
        }
        input = Paths.get(args[0], new String[0]);
        sleep = Integer.parseInt(args[1]);
        try {
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            String name = runtimeBean.getName();
            String pid = name.split("@")[0];
            System.out.println("PID=" + pid);
            SOSPath.getMostRecentFile(input);
            Thread.sleep(sleep * 1000);
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }

    public class SOSPathResult {
        private final Instant start;
        private Instant end;
        private Set<String> files = new HashSet<String>();
        private Set<String> directories = new HashSet<String>();

        protected SOSPathResult() {
            this.start = Instant.now();
        }

        protected void finisch() {
            this.end = Instant.now();
        }

        protected void addFile(Path p) {
            this.files.add(p.toString());
        }

        public Set<String> getFiles() {
            return this.files;
        }

        protected void addDirectory(Path p) {
            this.directories.add(p.toString());
        }

        public Set<String> getDirectories() {
            return this.directories;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("directories=").append(this.directories.size());
            sb.append(",files=").append(this.files.size());
            if (this.end != null) {
                sb.append(",duration=").append(SOSDate.getDuration(this.start, this.end));
            }
            return sb.toString();
        }
    }
}

