/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SOSStreamUnzip {
    private static final int BUFFER = 4096;

    public static byte[] unzip(byte[] source) throws IOException {
        return SOSStreamUnzip.unzip(source, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] unzip(byte[] source, int bufferSize) throws IOException {
        int l;
        if (source == null) {
            return null;
        }
        InputStream is = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream(bufferSize);
        if (source.length < 4 || source[0] != 31 || source[1] != -117) {
            byte[] byArray = source;
            return byArray;
        }
        is = new GZIPInputStream(new ByteArrayInputStream(source));
        byte[] buffer = new byte[bufferSize];
        while ((l = is.read(buffer)) != -1) {
            out.write(buffer, 0, l);
        }
        byte[] byArray = out.toByteArray();
        return byArray;
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Path unzipToFile(byte[] source, String prefix) throws IOException {
        if (source == null) {
            return null;
        }
        InputStream is = null;
        Path path = null;
        try {
            is = source.length >= 4 && source[0] == 31 && source[1] == -117 ? new GZIPInputStream(new ByteArrayInputStream(source)) : new ByteArrayInputStream(source);
            path = Files.createTempFile(prefix, null, new FileAttribute[0]);
            Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
            Path path2 = path;
            return path2;
        }
        catch (IOException e) {
            try {
                if (path != null) {
                    Files.deleteIfExists(path);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static Path toGzipFile(byte[] source, String prefix) throws IOException {
        Path path = null;
        try {
            path = Files.createTempFile(prefix, null, new FileAttribute[0]);
            if (SOSStreamUnzip.toGzipFile(source, path, false)) {
                return path;
            }
            return null;
        }
        catch (Exception e) {
            try {
                if (path != null) {
                    Files.deleteIfExists(path);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean toGzipFile(byte[] source, Path target, boolean append) throws IOException {
        if (source == null) {
            return false;
        }
        ByteArrayInputStream is = null;
        OutputStream out = null;
        try {
            int length;
            is = new ByteArrayInputStream(source);
            out = source.length >= 4 && source[0] == 31 && source[1] == -117 ? (append ? Files.newOutputStream(target, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND) : Files.newOutputStream(target, new OpenOption[0])) : (append ? new GZIPOutputStream(Files.newOutputStream(target, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND)) : new GZIPOutputStream(Files.newOutputStream(target, new OpenOption[0])));
            byte[] buffer = new byte[4096];
            while ((length = is.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
            out.flush();
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                    is = null;
                }
            }
            catch (IOException iOException) {}
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String unzip2String(byte[] source) throws IOException {
        return SOSStreamUnzip.unzip2String(source, 4096);
    }

    public static String unzip2String(byte[] source, int bufferSize) throws IOException {
        return new String(SOSStreamUnzip.unzip(source, bufferSize), "UTF-8");
    }

    public static long getSize(byte[] source) throws IOException {
        if (source == null) {
            return 0L;
        }
        int logLength = source.length;
        if (source.length >= 4 && source[0] == 31 && source[1] == 139) {
            byte b4 = source[logLength - 4];
            byte b3 = source[logLength - 3];
            byte b2 = source[logLength - 2];
            byte b1 = source[logLength - 1];
            return (long)b1 << 24 | (long)b2 << 16 | (long)b3 << 8 | (long)b4;
        }
        return logLength;
    }
}

