/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.http;

import com.sos.commons.util.SOSPathUtils;
import com.sos.commons.util.SOSString;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Locale;

public class HttpUtils {
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_TYPE_BINARY = "application/octet-stream";
    public static final String HEADER_CONTENT_TYPE_JSON = "application/json";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_WEBDAV_OVERWRITE = "Overwrite";
    public static final String HEADER_WEBDAV_OVERWRITE_VALUE = "T";
    public static final long DEFAULT_LAST_MODIFIED = -1L;
    private static final List<DateTimeFormatter> HTTP_DATE_FORMATTERS = List.of(DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).withZone(ZoneOffset.UTC), DateTimeFormatter.ofPattern("EEE, dd-MMM-yy HH:mm:ss zzz", Locale.US).withZone(ZoneOffset.UTC), DateTimeFormatter.ofPattern("EEE MMM d HH:mm:ss yyyy", Locale.US).withZone(ZoneOffset.UTC));

    public static String getAccessInfo(URI baseURI, String username) {
        if (baseURI == null) {
            return null;
        }
        String uri = SOSString.trimEnd(baseURI.toString(), "/");
        if (SOSString.isEmpty(username)) {
            return uri;
        }
        return "[" + username + "]" + uri;
    }

    public static String normalizePath(URI baseURI, String path) {
        try {
            if (baseURI == null) {
                if (SOSPathUtils.isAbsoluteURIPath(path)) {
                    return new URI(path).normalize().toString();
                }
                return SOSPathUtils.toUnixStyle(path);
            }
            return baseURI.resolve(path).normalize().toString();
        }
        catch (IllegalArgumentException | NullPointerException | URISyntaxException e) {
            return HttpUtils.normalizePathEncoded(baseURI, path);
        }
    }

    public static URI getParentURI(URI uri) {
        if (uri == null) {
            return null;
        }
        if (SOSString.isEmpty(uri.getPath()) || uri.getPath().equals("/")) {
            return uri;
        }
        URI directoryUri = HttpUtils.ensureDirectoryURI(uri);
        return directoryUri.resolve("..").normalize();
    }

    public static URI ensureDirectoryURI(URI uri) {
        if (uri != null && uri.getPath() != null && !uri.getPath().endsWith("/")) {
            return URI.create(uri.toString() + "/");
        }
        return uri;
    }

    public static String encodeQueryParam(String input) {
        if (input == null) {
            return null;
        }
        return URLEncoder.encode(input, StandardCharsets.UTF_8);
    }

    public static String decodeQueryParam(String input) {
        if (input == null) {
            return null;
        }
        return URLDecoder.decode(input, StandardCharsets.UTF_8);
    }

    public static String normalizeAndEncodeRelativePath(String relativePath) {
        if (relativePath == null) {
            return null;
        }
        try {
            String uri = new URI(null, relativePath, null).normalize().toASCIIString();
            return SOSString.trimStart(uri, "/");
        }
        catch (URISyntaxException e) {
            if (!relativePath.contains("/")) {
                return HttpUtils.normalizeAndEncodeRelativePath("/" + relativePath);
            }
            return relativePath;
        }
    }

    public static String decodeUriPath(String encoded) {
        if (encoded == null) {
            return null;
        }
        try {
            String replacedPlus = encoded.replace("+", "%2B");
            String decoded = URLDecoder.decode(replacedPlus, "UTF-8");
            return decoded.replace("%2B", "+");
        }
        catch (UnsupportedEncodingException e) {
            return encoded;
        }
    }

    public static String toValidFileSystemName(String input, boolean isWindows) {
        if (input == null) {
            return null;
        }
        String illegalChars = isWindows ? "[<>:\"/\\\\|?*]" : "[/]";
        try {
            if (input.contains("%")) {
                input = input.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
                input = HttpUtils.decodeUriPath(input);
            }
            return input.replaceAll(illegalChars, "_");
        }
        catch (IllegalArgumentException e) {
            return input.replaceAll(illegalChars, "_");
        }
    }

    public static long httpDateToMillis(String httpDate) {
        if (SOSString.isEmpty(httpDate)) {
            return -1L;
        }
        for (DateTimeFormatter formatter : HTTP_DATE_FORMATTERS) {
            try {
                return ZonedDateTime.parse(httpDate, formatter).toInstant().toEpochMilli();
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return -1L;
    }

    public static boolean isSuccessful(int code) {
        return code >= 200 && code < 300;
    }

    public static boolean isServerError(int code) {
        return code >= 500;
    }

    public static boolean isForbidden(int code) {
        return code == 403;
    }

    public static boolean isNotFound(int code) {
        return code == 404;
    }

    public static boolean isMethodNotAllowed(int code) {
        return code == 405;
    }

    public static String getReasonPhrase(int code) {
        Object reason = HttpUtils.getReasonPhraseFromOfficialCodes(code);
        if (reason == null && (reason = HttpUtils.getReasonPhraseFromUnofficialCodes(code)) == null) {
            reason = "Unknown Status Code: " + code + " - No description available.";
        }
        return reason;
    }

    private static String getReasonPhraseFromOfficialCodes(int code) {
        return switch (code) {
            case 100 -> "Continue - The server has received the request headers and the client should proceed to send the request body.";
            case 101 -> "Switching Protocols - The server is switching protocols as requested by the client.";
            case 102 -> "Processing - This code was used in WebDAV contexts to indicate that a request has been received by the server, but no status was available at the time of the response..";
            case 103 -> "Early Hints - Used to return some response headers before final HTTP message.";
            case 200 -> "OK - The request was successful.";
            case 201 -> "Created - The request was successful and a resource was created.";
            case 202 -> "Accepted - The request has been accepted for processing, but the processing is not complete.";
            case 203 -> "Non-Authoritative Information - TThe server is a transforming proxy (e.g. a Web accelerator) that received a 200 OK from its origin, but is returning a modified version of the origin's response.";
            case 204 -> "No Content - The server successfully processed the request but is not returning any content.";
            case 205 -> "Reset Content - The server successfully processed the request, asks that the requester reset its document view, and is not returning any content.";
            case 206 -> "Partial Content - The server is delivering only part of the resource (byte serving) due to a range header sent by the client. The range header is used by HTTP clients to enable resuming of interrupted downloads, or split a download into multiple simultaneous streams.";
            case 207 -> "Multi-Status - The message body that follows is by default an XML message and can contain a number of separate response codes, depending on how many sub-requests were made.";
            case 208 -> "Already Reported - The members of a DAV binding have already been enumerated in a preceding part of the (multistatus) response, and are not being included again.";
            case 226 -> "IM Used (HTTP Delta encoding) - The server has fulfilled a request for the resource, and the response is a representation of the result of one or more instance-manipulations applied to the current instance.";
            case 300 -> "Multiple Choices - Indicates multiple options for the resource from which the client may choose (via agent-driven content negotiation).";
            case 301 -> "Moved Permanently - The resource has been permanently moved to a new location.";
            case 302 -> "Found - The resource has temporarily moved to a different location.";
            case 303 -> "See Other - The server sent this response to direct the client to get the requested resource at another URI with a GET request.";
            case 304 -> "Not Modified - The resource has not been modified since the last request.";
            case 305 -> "Use Proxy -  Defined in a previous version of the HTTP specification to indicate that a requested response must be accessed by a proxy.";
            case 306 -> "Switch Proxy - Originally meant 'Subsequent requests should use the specified proxy'.";
            case 307 -> "Temporary Redirect - The server sends this response to direct the client to get the requested resource at another URI with the same method that was used in the prior request.";
            case 308 -> "Permanent Redirect - This and all future requests should be directed to the given URI.";
            case 400 -> "Bad Request - The server could not understand the request due to invalid syntax.";
            case 401 -> "Unauthorized - Authentication is required and has failed or has not yet been provided.";
            case 402 -> "Payment Required";
            case 403 -> "Forbidden - The client does not have access rights to the content.";
            case 404 -> "Not Found - The server can not find the requested resource.";
            case 405 -> "Method Not Allowed - The request method is not supported for the requested resource.";
            case 406 -> "Not Acceptable - The requested resource is capable of generating only content not acceptable according to the Accept headers sent in the request.";
            case 407 -> "Proxy Authentication Required - The client must first authenticate itself with the proxy.";
            case 408 -> "Request Timeout - The server timed out waiting for the request.";
            case 409 -> "Conflict - The request conflicts with the current state of the resource.";
            case 410 -> "Gone - The resource requested is no longer available and will not be available again.";
            case 411 -> "Length Required - Server rejected the request because the Content-Length header field is not defined and the server requires it.";
            case 412 -> "Precondition Failed - The server does not meet one of the preconditions that the requester put on the request header fields.";
            case 413 -> "Payload Too Large - The request entity is larger than the server is willing to process.";
            case 414 -> "URI Too Long - The URI requested by the client is longer than the server is willing to interpret.";
            case 415 -> "Unsupported Media Type - The media format of the requested data is not supported by the server.";
            case 416 -> "Range Not Satisfiable - The client has asked for a portion of the file (byte serving, Range header), but the server cannot supply that portion.";
            case 417 -> "Expectation Failed - The server cannot meet the requirements of the Expect request-header field.";
            case 418 -> "I'm a teapot - An April Fools' joke response code (RFC 2324).";
            case 421 -> "Misdirected Request - The request was directed at a server that is not able to produce a response (for example because of connection reuse).";
            case 422 -> "Unprocessable Content - The request was well-formed (i.e., syntactically correct) but could not be processed.";
            case 423 -> "Locked - The resource that is being accessed is locked.";
            case 424 -> "Failed Dependency - The request failed because it depended on another request and that request failed (e.g., a PROPPATCH).";
            case 425 -> "Too Early - Indicates that the server is unwilling to risk processing a request that might be replayed.";
            case 426 -> "Upgrade Required - The client should switch to a different protocol such as TLS/1.3, given in the Upgrade header field.";
            case 428 -> "Precondition Required - The origin server requires the request to be conditional.";
            case 429 -> "Too Many Requests - The user has sent too many requests in a given amount of time.";
            case 431 -> "Request Header Fields Too Large - The server is unwilling to process the request because either an individual header field, or all the header fields collectively, are too large.";
            case 451 -> "Unavailable For Legal Reasons - The user agent requested a resource that cannot legally be provided, such as a web page censored by a government.";
            case 500 -> "Internal Server Error - The server encountered an internal error and could not complete the request.";
            case 501 -> "Not Implemented - The server does not support the functionality required to fulfill the request.";
            case 502 -> "Bad Gateway - The server, while acting as a gateway, received an invalid response.";
            case 503 -> "Service Unavailable - The server is not ready to handle the request.";
            case 504 -> "Gateway Timeout - The server, while acting as a gateway, did not receive a timely response.";
            case 505 -> "HTTP Version Not Supported - The server does not support the HTTP protocol version used in the request.";
            case 506 -> "Variant Also Negotiates - Transparent content negotiation for the request results in a circular reference.";
            case 507 -> "Insufficient Storage - The server is unable to store the representation needed to complete the request.";
            case 508 -> "Loop Detected - The server detected an infinite loop while processing the request (sent instead of 208 Already Reported).";
            case 510 -> "Not Extended - Further extensions to the request are required for the server to fulfil it.";
            case 511 -> "Network Authentication Required - The client needs to authenticate to gain network access.";
            default -> null;
        };
    }

    private static String getReasonPhraseFromUnofficialCodes(int code) {
        return switch (code) {
            case 218 -> "[?]This is fine";
            case 419 -> "[?]Page Expired";
            case 420 -> "[?]Method Failure/Enhance Your Calm";
            case 430 -> "[?]Request Header Fields Too Large/Shopify Security Rejection";
            case 440 -> "[?]Login Time-out";
            case 444 -> "[?]No Response";
            case 449 -> "[?]Retry With";
            case 450 -> "[?]Blocked by Windows Parental Controls";
            case 460 -> "[?]Client closed the connection with the load balancer before the idle timeout period elapsed";
            case 463 -> "[?]The load balancer received an X-Forwarded-For request header with more than 30 IP addresses";
            case 464 -> "[?]Incompatible protocol versions between Client and Origin server";
            case 494 -> "[?]Request header too large";
            case 495 -> "[?]SSL Certificate Error";
            case 496 -> "[?]SSL Certificate Required";
            case 497 -> "[?]HTTP Request Sent to HTTPS Port";
            case 498 -> "[?]Invalid Token";
            case 499 -> "[?]Client Closed Request/Token Required";
            case 509 -> "[?]Bandwidth Limit Exceeded";
            case 520 -> "[?]Web Server Returned an Unknown Error";
            case 521 -> "[?]Web Server Is Down";
            case 522 -> "[?]Connection Timed Out";
            case 523 -> "[?]Origin Is Unreachable";
            case 524 -> "[?]A Timeout Occurred";
            case 525 -> "[?]SSL Handshake Failed";
            case 526 -> "[?]Invalid SSL Certificate";
            case 527 -> "[?]Railgun Error (obsolete)";
            case 529 -> "[?]Site is overloaded";
            case 530 -> "[?]Site is frozen/Origin DNS Error";
            case 540 -> "[?]Temporarily Disabled";
            case 561 -> "[?]Unauthorized";
            case 598 -> "[?][HTTP proxy]Network read timeout error";
            case 599 -> "[?][HTTP proxy]Network Connect Timeout Error";
            case 783 -> "[?]Unexpected Token";
            case 999 -> "[?]Non-standard";
            default -> null;
        };
    }

    private static String normalizePathEncoded(URI baseURI, String path) {
        try {
            if (baseURI == null) {
                return new URI(null, path, null).normalize().toASCIIString();
            }
            return baseURI.resolve(new URI(null, path, null)).normalize().toASCIIString();
        }
        catch (URISyntaxException e) {
            if (baseURI == null) {
                return SOSPathUtils.toUnixStyle(path);
            }
            return SOSPathUtils.appendPath(baseURI.toString(), path, "/");
        }
    }
}

