/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.keystore;

import com.sos.commons.util.arguments.base.ASOSArguments;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.keystore.KeyStoreType;
import java.nio.file.Path;

public class KeyStoreArguments
extends ASOSArguments {
    public static final String CLASS_KEY = "KEY_STORE";
    private SOSArgument<KeyStoreType> keyStoreType = new SOSArgument<KeyStoreType>("keystore_type", false, KeyStoreType.JKS);
    private SOSArgument<Path> keyStoreFile = new SOSArgument("keystore_file", false);
    private SOSArgument<String> keyStorePassword = new SOSArgument("keystore_password", false, SOSArgument.DisplayMode.MASKED);
    private SOSArgument<KeyStoreType> trustStoreType = new SOSArgument<KeyStoreType>("truststore_type", false, KeyStoreType.JKS);
    private SOSArgument<Path> trustStoreFile = new SOSArgument("truststore_file", false);
    private SOSArgument<String> trustStorePassword = new SOSArgument("truststore_password", false, SOSArgument.DisplayMode.MASKED);

    public boolean isCustomStoresEnabled() {
        return this.isCustomTrustStoreEnabled() || this.isCustomKeyStoreEnabled();
    }

    public boolean isCustomTrustStoreEnabled() {
        return !this.trustStoreFile.isEmpty();
    }

    public boolean isCustomKeyStoreEnabled() {
        return !this.keyStoreFile.isEmpty();
    }

    public SOSArgument<KeyStoreType> getKeyStoreType() {
        return this.keyStoreType;
    }

    public SOSArgument<Path> getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public SOSArgument<String> getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public SOSArgument<KeyStoreType> getTrustStoreType() {
        return this.trustStoreType;
    }

    public SOSArgument<Path> getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public SOSArgument<String> getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[keystore ").append((Object)this.keyStoreType.getValue());
        sb.append(" file=").append(this.keyStoreFile.getValue()).append("]");
        sb.append("[truststore ").append((Object)this.trustStoreType.getValue());
        sb.append(" file=").append(this.trustStoreFile.getValue()).append("]");
        return sb.toString();
    }
}

