/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.proxy;

import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.arguments.base.SOSArgumentHelper;
import com.sos.commons.util.proxy.ProxyConfigArguments;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;

public class ProxyConfig {
    private static final String SYSTEM_PROPERTY_NAME_HTTP_PROXY_HOST = "http.proxyHost";
    private static final String SYSTEM_PROPERTY_NAME_HTTP_PROXY_PORT = "http.proxyPort";
    private static final String SYSTEM_PROPERTY_NAME_HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String SYSTEM_PROPERTY_NAME_HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String SYSTEM_PROPERTY_NAME_SOCKS_PROXY_HOST = "socksProxyHost";
    private static final String SYSTEM_PROPERTY_NAME_SOCKS_PROXY_PORT = "socksProxyPort";
    private final Proxy proxy;
    private final String host;
    private final int port;
    private final String user;
    private final String password;
    private final int connectTimeoutAsMillis;
    private Charset charset = Charset.defaultCharset();

    public static ProxyConfig createInstance(ProxyConfigArguments args) {
        if (args == null || args.getType().isEmpty()) {
            return null;
        }
        String host = ProxyConfig.getHost(args.getType(), args.getHost());
        if (SOSString.isEmpty(host)) {
            return null;
        }
        return new ProxyConfig(host, args);
    }

    private ProxyConfig(String host, ProxyConfigArguments args) {
        this.host = host;
        this.port = this.getPort(args.getType(), args.getPort());
        this.user = args.getUser().getValue();
        this.password = args.getPassword().getValue();
        this.connectTimeoutAsMillis = (int)SOSArgumentHelper.asMillis(args.getConnectTimeout());
        this.proxy = new Proxy(args.getType().getValue(), new InetSocketAddress(this.host, this.port));
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean hasUserAndPassword() {
        return !SOSString.isEmpty(this.user) && !SOSString.isEmpty(this.password);
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getConnectTimeoutAsMillis() {
        return this.connectTimeoutAsMillis;
    }

    public void setCharset(Charset val) {
        this.charset = val;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[");
        if (this.proxy != null) {
            sb.append("type=").append((Object)this.proxy.type());
        }
        sb.append(",host=").append(this.host);
        sb.append(",port=").append(this.port);
        sb.append(",user=").append(this.user);
        if (!SOSString.isEmpty(this.password)) {
            sb.append(",password=").append(SOSArgument.DisplayMode.MASKED.getValue());
        }
        sb.append(",charset=").append(this.charset);
        sb.append(",getConnectTimeoutAsMillis=").append(this.getConnectTimeoutAsMillis());
        sb.append("]");
        return sb.toString();
    }

    public String getAccessInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.proxy.type().name().toLowerCase()).append("://");
        if (!SOSString.isEmpty(this.user)) {
            sb.append(this.user).append("@");
        }
        sb.append(this.host).append(":").append(this.port);
        return sb.toString();
    }

    private static String getHost(SOSArgument<Proxy.Type> typeArg, SOSArgument<String> hostArg) {
        if (typeArg == null || hostArg == null) {
            return null;
        }
        if (!hostArg.isEmpty()) {
            return hostArg.getValue();
        }
        switch (typeArg.getValue()) {
            case SOCKS: {
                return System.getProperty(SYSTEM_PROPERTY_NAME_SOCKS_PROXY_HOST);
            }
        }
        String host = System.getProperty(SYSTEM_PROPERTY_NAME_HTTP_PROXY_HOST);
        if (!SOSString.isEmpty(host)) {
            return host;
        }
        return System.getProperty(SYSTEM_PROPERTY_NAME_HTTPS_PROXY_HOST);
    }

    private int getPort(SOSArgument<Proxy.Type> typeArg, SOSArgument<Integer> portArg) {
        if (!portArg.isEmpty() && portArg.getValue() > 0) {
            return portArg.getValue();
        }
        String port = null;
        switch (typeArg.getValue()) {
            case SOCKS: {
                port = System.getProperty(SYSTEM_PROPERTY_NAME_SOCKS_PROXY_PORT);
                if (!SOSString.isEmpty(port)) {
                    return Integer.parseInt(port);
                }
                return 1080;
            }
        }
        port = System.getProperty(SYSTEM_PROPERTY_NAME_HTTP_PROXY_PORT);
        if (!SOSString.isEmpty(port)) {
            return Integer.parseInt(port);
        }
        port = System.getProperty(SYSTEM_PROPERTY_NAME_HTTPS_PROXY_PORT);
        if (!SOSString.isEmpty(port)) {
            return Integer.parseInt(port);
        }
        return 80;
    }
}

