/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdb;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.pwdb.Entry;
import org.linguafranca.pwdb.base.AbstractEntry;
import org.linguafranca.pwdb.kdb.KdbDatabase;
import org.linguafranca.pwdb.kdb.KdbGroup;
import org.linguafranca.pwdb.kdb.KdbIcon;

public class KdbEntry
extends AbstractEntry<KdbDatabase, KdbGroup, KdbEntry, KdbIcon> {
    KdbGroup parent;
    private UUID uuid = UUID.randomUUID();
    private String title = "";
    private String url = "";
    private String notes = "";
    private KdbIcon icon = new KdbIcon(0);
    private String username = "";
    private String password = "";
    private Date creationTime;
    private Date lastModificationTime = this.creationTime = new Date(System.currentTimeMillis());
    private Date lastAccessTime = this.creationTime;
    private boolean expires = false;
    private Date expiryTime = new Date(Long.MAX_VALUE);
    private String binaryDescription = "";
    private byte[] binaryData = new byte[0];

    public String getProperty(String name) {
        switch (name) {
            case "UserName": {
                return this.getUsername();
            }
            case "Password": {
                return this.getPassword();
            }
            case "URL": {
                return this.getUrl();
            }
            case "Title": {
                return this.getTitle();
            }
            case "Notes": {
                return this.getNotes();
            }
        }
        return null;
    }

    public void setProperty(String name, String value) {
        switch (name) {
            case "UserName": {
                this.setUsername(value);
                break;
            }
            case "Password": {
                this.setPassword(value);
                break;
            }
            case "URL": {
                this.setUrl(value);
                break;
            }
            case "Title": {
                this.setTitle(value);
                break;
            }
            case "Notes": {
                this.setNotes(value);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot set non-standard properties in KDB format");
            }
        }
    }

    public boolean removeProperty(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove non-standard properties in KDB format");
    }

    public boolean removeBinaryProperty(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove binary properties in KDB format");
    }

    public List<String> getPropertyNames() {
        return new ArrayList<String>(Entry.STANDARD_PROPERTY_NAMES);
    }

    public KdbGroup getParent() {
        return this.parent;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public KdbIcon getIcon() {
        return this.icon;
    }

    public void setIcon(KdbIcon icon) {
        this.icon = icon;
    }

    void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    void setLastModificationTime(Date lastModificationTime) {
        this.lastModificationTime = lastModificationTime;
    }

    public Date getLastModificationTime() {
        return this.lastModificationTime;
    }

    void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setExpiryTime(Date expiryTime) {
        if (expiryTime == null) {
            throw new IllegalArgumentException("expiryTime may not be null");
        }
        this.expiryTime = expiryTime;
    }

    public Date getExpiryTime() {
        return this.expiryTime;
    }

    public String getBinaryDescription() {
        return this.binaryDescription;
    }

    void setBinaryDescription(String binaryDescription) {
        this.binaryDescription = binaryDescription;
    }

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData;
    }

    public String toString() {
        String time = KdbDatabase.isoDateFormat.format(this.creationTime);
        return this.getPath() + String.format(" (%s, %s, %s) %s [%s]", this.url, this.username, this.notes.substring(0, Math.min(this.notes.length(), 24)), time, this.binaryDescription);
    }

    public boolean match(String text) {
        return super.match(text) || this.getBinaryDescription().toLowerCase().contains(text.toLowerCase());
    }

    public byte[] getBinaryProperty(String name) {
        throw new UnsupportedOperationException();
    }

    public void setBinaryProperty(String name, byte[] value) {
        throw new UnsupportedOperationException();
    }

    public List<String> getBinaryPropertyNames() {
        throw new UnsupportedOperationException();
    }

    public void setExpires(boolean expires) {
        this.expires = expires;
    }

    public boolean getExpires() {
        return this.expires;
    }

    protected void touch() {
        this.lastModificationTime = new Date();
    }
}

