/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.commons;

import com.sos.commons.httpclient.commons.ABaseHttpClient;
import com.sos.commons.httpclient.commons.auth.HttpClientAuthConfig;
import com.sos.commons.httpclient.commons.auth.HttpClientBasicAuthStrategy;
import com.sos.commons.httpclient.commons.auth.IHttpClientAuthStrategy;
import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.util.loggers.impl.SLF4JLogger;
import com.sos.commons.util.proxy.ProxyConfig;
import com.sos.commons.util.ssl.SslArguments;
import com.sos.commons.util.ssl.SslContextFactory;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;

public abstract class ABaseHttpClientBuilder<T extends ABaseHttpClient, B extends ABaseHttpClientBuilder<T, B>> {
    private final HttpClient.Builder httpClientBuilder;
    private ISOSLogger logger = new SLF4JLogger();
    private ProxyConfig proxyConfig;
    private SslArguments ssl;
    private IHttpClientAuthStrategy auth = null;
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    private Duration connectTimeout;

    public ABaseHttpClientBuilder() {
        this(HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS));
    }

    public ABaseHttpClientBuilder(HttpClient.Builder builder) {
        this.httpClientBuilder = builder;
    }

    protected abstract T createInstance(ISOSLogger var1, HttpClient var2) throws Exception;

    public B withLogger(ISOSLogger logger) {
        this.logger = logger;
        return this.self();
    }

    public B withProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        return this.self();
    }

    public B withSSL(SslArguments ssl) {
        this.ssl = ssl;
        return this.self();
    }

    public B withAuth(HttpClientAuthConfig authConfig) {
        this.auth = authConfig == null ? null : authConfig.getStrategy();
        return this.self();
    }

    public B withAuth(String username, String password) {
        this.auth = new HttpClientBasicAuthStrategy(username, password);
        return this.self();
    }

    public B withHeaders(List<String> headers) {
        if (headers != null) {
            this.setHeaders(headers);
        }
        return this.self();
    }

    public B withHeaders(Map<String, String> headers) {
        if (headers != null) {
            this.headers.putAll(headers);
        }
        return this.self();
    }

    public B withHeader(String name, String value) {
        if (SOSString.isEmpty((String)name)) {
            return this.self();
        }
        return this.withHeaders(Map.of(name, value == null ? "" : value));
    }

    public B withConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this.self();
    }

    public T build() throws Exception {
        if (this.connectTimeout != null) {
            this.httpClientBuilder.connectTimeout(this.connectTimeout);
        }
        if (this.auth != null) {
            if (this.auth.hasAuthenticator()) {
                this.httpClientBuilder.authenticator(this.auth.toAuthenticator());
            }
            if (!SOSCollection.isEmpty(this.auth.getAuthHeaders())) {
                this.auth.getAuthHeaders().entrySet().stream().forEach(e -> this.headers.put((String)e.getKey(), (String)e.getValue()));
            }
        }
        if (this.proxyConfig != null) {
            this.httpClientBuilder.proxy(ProxySelector.of(new InetSocketAddress(this.proxyConfig.getHost(), this.proxyConfig.getPort())));
            if (this.proxyConfig.hasUserAndPassword()) {
                this.httpClientBuilder.authenticator(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(ABaseHttpClientBuilder.this.proxyConfig.getUser(), ABaseHttpClientBuilder.this.proxyConfig.getPassword().toCharArray());
                    }
                });
            }
        }
        if (this.ssl != null) {
            SSLContext sslContext = SslContextFactory.create((ISOSLogger)this.logger, (SslArguments)this.ssl);
            this.httpClientBuilder.sslContext(sslContext);
        }
        T client = this.createInstance(this.logger, this.httpClientBuilder.build());
        if (this.logger.isDebugEnabled() && this.headers.size() > 0) {
            this.logger.debug((Object)"Headers:");
            this.headers.entrySet().forEach(e -> {
                String val = client.isSensitiveHeader((String)e.getKey()) ? "***" : (String)e.getValue();
                this.logger.debug((Object)("    name=" + (String)e.getKey() + ", value=" + val));
            });
        }
        ((ABaseHttpClient)client).setHeaders(this.headers);
        return client;
    }

    protected B self() {
        return (B)this;
    }

    private void setHeaders(List<String> defaultHeaders) {
        defaultHeaders.stream().map(String::trim).forEach(header -> {
            int p = header.indexOf(" ");
            if (p == -1) {
                this.headers.put((String)header, "");
            } else {
                this.headers.put(header.substring(0, p).trim(), header.substring(p).trim());
            }
        });
    }
}

