/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.commons;

import com.sos.commons.httpclient.BaseHttpClient;
import com.sos.commons.httpclient.commons.HttpExecutionResult;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.http.HttpUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpRequest;

public class HttpOutputStream
extends OutputStream {
    private final BaseHttpClient client;
    private final URI uri;
    private final boolean isWebDAV;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public HttpOutputStream(BaseHttpClient client, URI uri, boolean isWebDAV) throws IOException {
        this.client = client;
        this.uri = uri;
        this.isWebDAV = isWebDAV;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            HttpRequest request;
            HttpExecutionResult<Void> result;
            byte[] bytes = this.buffer.toByteArray();
            HttpRequest.Builder builder = this.client.createRequestBuilder(this.uri).expectContinue(true);
            builder.header("Content-Type", "application/octet-stream");
            BaseHttpClient.withWebDAVOverwrite(builder, this.isWebDAV);
            if (!this.client.isChunkedTransfer()) {
                builder.header("Content-Length", String.valueOf(bytes.length));
            }
            if (!HttpUtils.isSuccessful((int)(result = this.client.executeNoResponseBody(request = builder.PUT(HttpRequest.BodyPublishers.ofByteArray(bytes)).build())).response().statusCode())) {
                throw new IOException(BaseHttpClient.formatExecutionResult(result));
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            SOSClassUtil.closeQuietly((Closeable)this.buffer);
            super.close();
        }
    }
}

