/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.httpclient.deprecated;

import com.sos.commons.exception.SOSException;
import com.sos.commons.httpclient.exception.SOSBadRequestException;
import com.sos.commons.httpclient.exception.SOSConnectionRefusedException;
import com.sos.commons.httpclient.exception.SOSConnectionResetException;
import com.sos.commons.httpclient.exception.SOSNoResponseException;
import com.sos.commons.httpclient.exception.SOSSSLException;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class SOSRestApiClient {
    private String accept = "application/json";
    private String basicAuthorization = null;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private List<String> origResponseHeaders = new ArrayList<String>();
    private List<String> cookies = new ArrayList<String>();
    private RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
    private CredentialsProvider credentialsProvider = null;
    private HttpResponse httpResponse;
    private HttpRequestRetryHandler httpRequestRetryHandler;
    private CloseableHttpClient httpClient = null;
    private boolean forcedClosingHttpClient = false;
    private boolean autoCloseHttpClient = true;
    private HostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
    private KeyStore clientCertificate = null;
    private char[] clientCertificatePass = null;
    private String clientCertificateAlias = null;
    private KeyStore truststore = null;
    private SSLContext sslContext = null;

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public void setBasicAuthorization(String basicAuthorization) {
        this.basicAuthorization = basicAuthorization;
    }

    public int statusCode() {
        if (this.httpResponse.getStatusLine() != null) {
            return this.httpResponse.getStatusLine().getStatusCode();
        }
        return -1;
    }

    public String printStatusLine() {
        StatusLine s = this.httpResponse.getStatusLine();
        if (s != null) {
            return String.format("%s %d %s", s.getProtocolVersion(), s.getStatusCode(), s.getReasonPhrase());
        }
        return "statusline n/a";
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public String getResponseHeader(String key) {
        if (this.responseHeaders != null && key != null) {
            return this.responseHeaders.get(key.toLowerCase());
        }
        return null;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.requestConfigBuilder.setConnectTimeout(connectionTimeout);
    }

    public void setSocketTimeout(int socketTimeout) {
        this.requestConfigBuilder.setSocketTimeout(socketTimeout);
    }

    public void setAllowAllHostnameVerifier(boolean flag) {
        this.hostnameVerifier = flag ? NoopHostnameVerifier.INSTANCE : null;
    }

    public void closeHttpClient() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.httpClient = null;
        }
    }

    public boolean isForcedClosingHttpClient() {
        return this.forcedClosingHttpClient;
    }

    public void setAutoCloseHttpClient(boolean autoCloseHttpClient) {
        this.autoCloseHttpClient = autoCloseHttpClient;
    }

    public void setSSLContext(KeyStore clientCertificate, char[] clientCertificatePass, KeyStore truststore) throws SOSSSLException {
        this.setSSLContext(clientCertificate, clientCertificatePass, null, truststore);
    }

    public void setSSLContext(KeyStore clientCertificate, char[] clientCertificatePass, String clientCertificateAlias, KeyStore truststore) throws SOSSSLException {
        if (clientCertificate != null) {
            this.setClientCertificate(clientCertificate, clientCertificatePass, clientCertificateAlias);
        }
        this.setTruststore(truststore);
        this.setSSLContext();
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public <T, B> T executeRestService(HttpMethod method, URI uri, B body, Class<T> clazz) throws SocketException, SOSException {
        switch (method) {
            case GET: {
                return this.getRestService(uri, clazz);
            }
            case POST: {
                return this.postRestService(uri, body, clazz);
            }
            case PUT: {
                return this.putRestService(uri, body, clazz);
            }
            case DELETE: {
                return this.deleteRestService(uri, clazz);
            }
        }
        return null;
    }

    public void addHeader(String header, String value) {
        this.headers.put(header, value);
    }

    public void addCookieHeader() {
        this.addCookieHeader(this.cookies);
    }

    public String getRestService(URI uri) throws SOSException, SocketException {
        return this.getResponse((HttpUriRequest)new HttpGet(uri), String.class);
    }

    public <T> T getRestService(URI uri, Class<T> clazz) throws SOSException, SocketException {
        return this.getResponse((HttpUriRequest)new HttpGet(uri), clazz);
    }

    public Path getFilePathByRestService(URI uri, String prefix, boolean withGzipEncoding) throws SOSException, SocketException {
        return this.getFilePathResponse((HttpUriRequest)new HttpGet(uri), prefix, withGzipEncoding);
    }

    public StreamingOutput getStreamingOutputByRestService(URI uri, boolean withGzipEncoding) throws SOSException, SocketException {
        return this.getStreamingOutputResponse((HttpUriRequest)new HttpGet(uri), withGzipEncoding);
    }

    public <B> String postRestService(URI uri, B body) throws SOSException {
        HttpPost requestPost = new HttpPost(uri);
        HttpEntity entity = this.getEntity(body);
        if (entity != null) {
            requestPost.setEntity(entity);
        }
        this.createHttpClient();
        this.setHttpRequestHeaders((HttpRequest)requestPost);
        try {
            this.httpResponse = this.getResponse((HttpUriRequest)requestPost);
            return this.getResponse(this.httpResponse);
        }
        catch (SOSException e) {
            this.closeHttpClient();
            throw e;
        }
    }

    public String printHttpRequestHeaders() {
        return this.printHttpRequestHeaders(Collections.emptySet(), true);
    }

    public String printHttpResponseHeaders() {
        return this.printHttpResponseHeaders(true);
    }

    private <T, B> T postRestService(URI uri, B body, Class<T> clazz) throws SOSException {
        HttpPost requestPost = new HttpPost(uri);
        HttpEntity entity = this.getEntity(body);
        if (entity != null) {
            requestPost.setEntity(entity);
        }
        return this.getResponse((HttpUriRequest)requestPost, clazz);
    }

    private <T, B> T putRestService(URI uri, B body, Class<T> clazz) throws SOSException, SocketException {
        HttpPut requestPut = new HttpPut(uri);
        HttpEntity entity = this.getEntity(body);
        if (entity != null) {
            requestPut.setEntity(entity);
        }
        return this.getResponse((HttpUriRequest)requestPut, clazz);
    }

    private String printHttpRequestHeaders(Set<String> maskedHeaders, boolean pretty) {
        HashMap<String, String> h = new HashMap<String, String>();
        h.put("Accept", this.accept);
        h.putAll(this.headers);
        if (h.containsKey("Authorization")) {
            h.put("Authorization", "********");
        } else if (this.basicAuthorization != null && !this.basicAuthorization.isEmpty()) {
            h.put("Authorization", "********");
        }
        for (String maskedHeader : maskedHeaders) {
            if (!h.containsKey(maskedHeader)) continue;
            h.put(maskedHeader, "********");
        }
        Stream<String> s = h.entrySet().stream().map(e -> (String)e.getKey() + ": " + (String)e.getValue());
        if (pretty) {
            return s.collect(Collectors.joining(" \n\t> ", "Request headers \n\t> ", ""));
        }
        return s.collect(Collectors.joining("; ", "Request headers: ", ""));
    }

    private <T> T deleteRestService(URI uri, Class<T> clazz) throws SOSException, SocketException {
        return this.getResponse((HttpUriRequest)new HttpDelete(uri), clazz);
    }

    private void addCookieHeader(List<String> _cookies) {
        if (_cookies != null & !_cookies.isEmpty()) {
            this.headers.put("Cookie", String.join((CharSequence)"; ", _cookies));
        }
    }

    private void setSSLContext() throws SOSSSLException {
        if (this.clientCertificate != null || this.truststore != null) {
            try {
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                if (this.clientCertificate != null) {
                    if (this.clientCertificateAlias != null && !this.clientCertificateAlias.isEmpty()) {
                        sslContextBuilder.loadKeyMaterial(this.clientCertificate, this.clientCertificatePass, (aliases, socket) -> this.clientCertificateAlias);
                    } else {
                        sslContextBuilder.loadKeyMaterial(this.clientCertificate, this.clientCertificatePass);
                    }
                }
                if (this.truststore != null) {
                    sslContextBuilder.loadTrustMaterial(this.truststore, null);
                }
                this.sslContext = sslContextBuilder.build();
            }
            catch (GeneralSecurityException e) {
                throw new SOSSSLException(e);
            }
        }
    }

    private void createHttpClient() {
        this.createHttpClient(this.getDefaultHttpClientBuilder());
    }

    private void createHttpClient(HttpClientBuilder builder) {
        if (this.httpClient == null) {
            if (builder == null) {
                builder = this.getDefaultHttpClientBuilder();
            }
            this.httpClient = builder.setDefaultRequestConfig(this.requestConfigBuilder.build()).build();
        }
    }

    private HttpClientBuilder getDefaultHttpClientBuilder() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.httpRequestRetryHandler != null) {
            builder.setRetryHandler(this.httpRequestRetryHandler);
        } else {
            builder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        }
        if (this.credentialsProvider != null) {
            builder.setDefaultCredentialsProvider(this.credentialsProvider);
        }
        if (this.sslContext != null) {
            builder.setSSLContext(this.sslContext);
        }
        if (this.hostnameVerifier != null) {
            builder.setSSLHostnameVerifier(this.hostnameVerifier);
        }
        return builder;
    }

    private String printHttpResponseHeaders(boolean pretty) {
        Stream s = this.origResponseHeaders.stream();
        if (pretty) {
            return s.collect(Collectors.joining(" \n\t< ", "Response headers \n\t< ", ""));
        }
        return s.collect(Collectors.joining("; ", "Response headers: ", ""));
    }

    private String getDataString(HashMap<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return result.toString();
    }

    private <B> HttpEntity getEntity(B body) throws SOSBadRequestException {
        ByteArrayEntity entity = null;
        if (body != null) {
            try {
                if (body instanceof HashMap) {
                    String b = this.getDataString((HashMap)body);
                    if (!b.isEmpty()) {
                        entity = new StringEntity(b, StandardCharsets.UTF_8);
                    }
                } else if (body instanceof String) {
                    String b = (String)body;
                    if (!b.isEmpty()) {
                        entity = new StringEntity(b, StandardCharsets.UTF_8);
                    }
                } else if (body instanceof byte[]) {
                    entity = new ByteArrayEntity((byte[])body);
                } else if (body instanceof InputStream) {
                    entity = new InputStreamEntity((InputStream)body);
                }
            }
            catch (Exception e) {
                throw new SOSBadRequestException(e);
            }
        }
        return entity;
    }

    private HttpResponse getResponse(HttpUriRequest request) throws SOSException {
        try {
            return this.httpClient.execute(request);
        }
        catch (ClientProtocolException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            this.closeHttpClient();
            throw new SOSNoResponseException((HttpRequest)request, (Throwable)e);
        }
        catch (HttpHostConnectException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (SocketException e) {
            this.closeHttpClient();
            if ("connection reset".equalsIgnoreCase(e.getMessage())) {
                throw new SOSConnectionResetException((HttpRequest)request, (Throwable)e);
            }
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
    }

    private <T> T getResponse(HttpUriRequest request, Class<T> clazz) throws SOSException {
        this.httpResponse = null;
        this.createHttpClient();
        this.setHttpRequestHeaders((HttpRequest)request);
        try {
            this.httpResponse = this.getResponse(request);
            return this.getResponse(clazz);
        }
        catch (SOSException e) {
            this.closeHttpClient();
            throw e;
        }
    }

    private Path getFilePathResponse(HttpUriRequest request, String prefix, boolean withGzipEncoding) throws SOSException, SocketException {
        this.httpResponse = null;
        this.createHttpClient();
        this.setHttpRequestHeaders((HttpRequest)request);
        try {
            this.httpResponse = this.httpClient.execute(request);
            return this.getFilePathResponse(prefix, withGzipEncoding);
        }
        catch (SOSException e) {
            this.closeHttpClient();
            throw e;
        }
        catch (ClientProtocolException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            this.closeHttpClient();
            throw new SOSNoResponseException((HttpRequest)request, (Throwable)e);
        }
        catch (HttpHostConnectException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (SocketException e) {
            this.closeHttpClient();
            if ("connection reset".equalsIgnoreCase(e.getMessage())) {
                throw new SOSConnectionResetException((HttpRequest)request, (Throwable)e);
            }
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((HttpRequest)request, (Throwable)e);
        }
    }

    private StreamingOutput getStreamingOutputResponse(HttpUriRequest request, boolean withGzipEncoding) throws SOSException, SocketException {
        this.httpResponse = null;
        this.createHttpClient();
        this.setHttpRequestHeaders((HttpRequest)request);
        try {
            this.httpResponse = this.getResponse(request);
            return this.getStreamingOutputResponse(withGzipEncoding);
        }
        catch (SOSException e) {
            this.closeHttpClient();
            throw e;
        }
    }

    private String getResponse(HttpResponse response) throws SOSNoResponseException {
        try {
            this.setHttpResponseHeaders();
            String contentType = this.getResponseHeader("Content-Type");
            String contentEncoding = this.getResponseHeader("Content-Encoding");
            String contentDisposition = this.getResponseHeader("Content-Disposition");
            HttpEntity entity = this.httpResponse.getEntity();
            if (contentType != null && !contentType.isEmpty() && (contentDisposition != null && contentDisposition.contains("filename") || contentEncoding != null && contentEncoding.contains("gzip"))) {
                String string = this.processInputStreamFromResponse(entity);
                return string;
            }
            String string = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSNoResponseException(e);
        }
        finally {
            if (this.autoCloseHttpClient) {
                this.closeHttpClient();
            }
        }
    }

    private <T> T getResponse(Class<T> clazz) throws SOSNoResponseException {
        try {
            Object s = null;
            this.setHttpResponseHeaders();
            HttpEntity entity = this.httpResponse.getEntity();
            if (entity != null) {
                if (clazz.equals(String.class)) {
                    s = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                } else if (clazz.equals(byte[].class)) {
                    s = EntityUtils.toByteArray((HttpEntity)entity);
                } else if (clazz.equals(InputStream.class)) {
                    s = entity.getContent();
                }
            }
            if (this.autoCloseHttpClient) {
                this.closeHttpClient();
            }
            return (T)s;
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSNoResponseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String processInputStreamFromResponse(HttpEntity entity) throws SOSException {
        Path filePath;
        block27: {
            filePath = null;
            try {
                String targetPath = this.headers.get("X-Export-Directory");
                if (targetPath == null || targetPath.isEmpty()) {
                    targetPath = this.headers.get("X-Export-Directory".toLowerCase());
                }
                Path target = Paths.get(System.getProperty("user.dir"), new String[0]);
                if (targetPath != null && !targetPath.isEmpty()) {
                    target = target.resolve(targetPath);
                }
                if (entity == null) break block27;
                InputStream instream = entity.getContent();
                OutputStream out = null;
                if (instream == null) break block27;
                try {
                    int length;
                    String contentDisposition = this.getResponseHeader("Content-Disposition");
                    Path path = null;
                    if (contentDisposition != null) {
                        Files.createDirectories(target, new FileAttribute[0]);
                        String filename = SOSRestApiClient.decodeDisposition(contentDisposition);
                        filePath = target.resolve(filename);
                        if (Files.exists(filePath, new LinkOption[0])) {
                            Files.delete(filePath);
                        }
                        path = Files.createFile(filePath, new FileAttribute[0]);
                        out = Files.newOutputStream(path, new OpenOption[0]);
                        if (this.getResponseHeader("Content-Encoding") != null) {
                            instream = new GZIPInputStream(instream);
                        }
                    } else {
                        if (this.getResponseHeader("Content-Encoding") != null) {
                            instream = new GZIPInputStream(instream);
                        }
                        out = new ByteArrayOutputStream();
                    }
                    byte[] buffer = new byte[4096];
                    while ((length = instream.read(buffer)) > 0) {
                        out.write(buffer, 0, length);
                    }
                    out.flush();
                    if (out instanceof ByteArrayOutputStream) {
                        String string = ((ByteArrayOutputStream)out).toString(StandardCharsets.UTF_8);
                        return string;
                    }
                }
                finally {
                    try {
                        instream.close();
                        instream = null;
                    }
                    catch (Exception exception) {}
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException | UnsupportedOperationException e) {
                throw new SOSException((Throwable)e);
            }
        }
        if (filePath == null) return null;
        return "outfile:" + filePath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path getFilePathResponse(String prefix, boolean withGzipEncoding) throws SOSNoResponseException {
        Path path = null;
        try {
            this.setHttpResponseHeaders();
            HttpEntity entity = this.httpResponse.getEntity();
            if (entity != null) {
                InputStream instream = entity.getContent();
                OutputStream out = null;
                if (instream != null) {
                    try {
                        int length;
                        if (prefix == null) {
                            prefix = "sos-download-";
                        }
                        path = Files.createTempFile(prefix, null, new FileAttribute[0]);
                        out = withGzipEncoding ? new GZIPOutputStream(Files.newOutputStream(path, new OpenOption[0])) : Files.newOutputStream(path, new OpenOption[0]);
                        byte[] buffer = new byte[4096];
                        while ((length = instream.read(buffer)) > 0) {
                            out.write(buffer, 0, length);
                        }
                        out.flush();
                    }
                    finally {
                        try {
                            instream.close();
                            instream = null;
                        }
                        catch (Exception exception) {}
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (this.autoCloseHttpClient) {
                this.closeHttpClient();
            }
            return path;
        }
        catch (Exception e) {
            throw new SOSNoResponseException(e);
        }
        finally {
            if (path != null) {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException iOException) {}
            }
            this.closeHttpClient();
        }
    }

    private StreamingOutput getStreamingOutputResponse(final boolean withGzipEncoding) throws SOSNoResponseException {
        StreamingOutput fileStream = null;
        try {
            this.setHttpResponseHeaders();
            HttpEntity entity = this.httpResponse.getEntity();
            if (entity != null) {
                final InputStream instream = entity.getContent();
                fileStream = new StreamingOutput(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void write(OutputStream output) throws IOException {
                        if (withGzipEncoding) {
                            output = new GZIPOutputStream(output);
                        }
                        try {
                            int length;
                            byte[] buffer = new byte[4096];
                            while ((length = instream.read(buffer)) > 0) {
                                output.write(buffer, 0, length);
                            }
                            output.flush();
                        }
                        finally {
                            try {
                                output.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                };
            }
            if (this.autoCloseHttpClient) {
                this.closeHttpClient();
            }
            return fileStream;
        }
        catch (Exception e) {
            throw new SOSNoResponseException(e);
        }
        finally {
            this.closeHttpClient();
        }
    }

    private void setHttpRequestHeaders(HttpRequest request) {
        request.setHeader("Accept", this.accept);
        if (this.basicAuthorization != null && !this.basicAuthorization.isEmpty()) {
            request.setHeader("Authorization", "Basic " + this.basicAuthorization);
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            request.setHeader(entry.getKey(), entry.getValue());
        }
    }

    private void setHttpResponseHeaders() {
        if (this.httpResponse != null) {
            Header[] headers = this.httpResponse.getAllHeaders();
            this.responseHeaders.clear();
            this.origResponseHeaders.clear();
            for (Header header : headers) {
                if ("set-cookie".equals(header.getName().toLowerCase())) {
                    String[] cookieParts = header.getValue().split(";", 2);
                    if (cookieParts.length >= 1) {
                        this.cookies.add(cookieParts[0]);
                    }
                } else {
                    this.responseHeaders.put(header.getName().toLowerCase(), header.getValue());
                }
                this.origResponseHeaders.add(String.format("%s: %s", header.getName(), header.getValue()));
            }
        }
    }

    private void setClientCertificate(KeyStore clientCertificate, char[] clientCertificatePass, String clientCertificateAlias) {
        this.clientCertificate = clientCertificate;
        this.clientCertificatePass = clientCertificatePass;
        this.clientCertificateAlias = clientCertificateAlias;
    }

    private void setTruststore(KeyStore truststore) {
        this.truststore = truststore;
    }

    public static String decodeDisposition(String disposition) throws UnsupportedEncodingException {
        String dispositionFilenameValue = disposition.replaceFirst("(?i)^.*filename(?:=\"?([^\"]+)\"?|\\*=([^;,]+)).*$", "$1$2");
        return SOSRestApiClient.decodeFromUriFormat(dispositionFilenameValue);
    }

    private static String decodeFromUriFormat(String parameter) throws UnsupportedEncodingException {
        Pattern filenamePattern = Pattern.compile("(?<charset>[^']+)'(?<lang>[a-z]{2,8}(-[a-z0-9-]+)?)?'(?<filename>.+)", 2);
        Matcher matcher = filenamePattern.matcher(parameter);
        if (matcher.matches()) {
            String filename = matcher.group("filename");
            String charset = matcher.group("charset");
            return URLDecoder.decode(filename.replaceAll("%25", "%"), charset);
        }
        return parameter;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public static enum HttpMethod {
        POST,
        GET,
        PUT,
        DELETE;

    }
}

