@echo off

rem # ------------------------------------------------------------
rem # Company:  Software- und Organisations-Service GmbH
rem # Date:     2025-04-30
rem # Purpose:  execute YADE Client
rem # Platform: Windows
rem # ------------------------------------------------------------
rem #
rem # Example:  ./yade.cmd --java-options="-Xmx64m" --settings=./yade.xml --profile=copy_sftp
rem #           runs the "copy_sftp" profile from the indicated settings file and limits Java Heap Space

SETLOCAL

rem # ------------------------------
rem # Initialize variables
rem # ------------------------------

set yade_script=%~dpnx0
set YADE_HOME=%~dp0..
call :normalize_home "%YADE_HOME%\dummy"
set YADE_BIN=%YADE_HOME%\bin

set yade_java_options=%JAVA_OPTIONS%
set log_level=INFO
set settings=
set settings_arg=
set return_values=
set return_values_arg=
set java_bin=java.exe
set classpath=
set log4j_property=
set /a verbose=0


rem # set java
if exist "%JAVA_HOME%\bin\java.exe" set java_bin=%JAVA_HOME%\bin\java.exe


rem # set java class path
if not exist "%YADE_HOME%\lib" echo "ERROR: Directory %YADE_HOME%\lib not found." & exit /b 1
set YADE_LIB_DIR=%YADE_HOME:\=/%/lib
set classpath=%YADE_LIB_DIR%/patches/*;%YADE_LIB_DIR%/user_lib/*;%YADE_LIB_DIR%/3rd-party/*;%YADE_LIB_DIR%/sos/*


rem # set log4j_property
if not defined log4j_property (
  if exist "%YADE_HOME%\lib\log4j2.xml" set log4j_property=-Dlog4j.configurationFile="file:///%YADE_LIB_DIR%/log4j2.xml"
)


:read_command_line_options
if "%~1" == "" goto read_command_line_options_end
set arg=%~1
set arg=%arg:--=-%
set arg=%arg:_=-%

if x-java-options == x%arg% set yade_java_options=%~2 & shift
if x-log-level == x%arg% set log_level=%~2 & shift
if x-settings == x%arg% set settings=%~2 & shift
if x-return-values == x%arg% set return_values=%~2 & shift
if x-verbose == x%arg% set /a verbose=1

shift
goto read_command_line_options
:read_command_line_options_end


rem # set default java options
echo.%yade_java_options% | findstr /I /C:-Xmx >nul
if ERRORLEVEL 1 set yade_java_options=%yade_java_options% -Xmx32m
echo.%yade_java_options% | findstr /I /C:-Dfile.encoding >nul
if ERRORLEVEL 1 set yade_java_options=%yade_java_options% -Dfile.encoding=UTF-8


if not defined settings (
  if defined JS7_YADE_CONFIG_DIR set settings_arg=--settings="%JS7_YADE_CONFIG_DIR%\yade.xml" 
)
if not defined return_values (
  if defined JS7_RETURN_VALUES set return_values_arg=--return-values="%JS7_RETURN_VALUES%"
)
if defined JS7_RETURN_VALUES (
  rem # YADE is running at an JS7 Agent
  if defined JS7_AGENT_TZ set YADE_TZ=%JS7_AGENT_TZ%
  if not defined JS7_AGENT_TZ set YADE_TZ=Etc/UTC
) else (
  rem # YADE is running standalone
  if not defined YADE_TZ call :set_time_zone "%java_bin%"
)
if defined log_level set YADE_LOG_LEVEL=%log_level%

echo.
echo ****************************************************************************************
echo CLIENT START : %DATE% %TIME%
echo HOSTNAME     : %COMPUTERNAME%
echo USER         : %USERNAME%
echo CALL         : %yade_script% %*
echo.

call :log_verbose "%java_bin%" %log4j_property% %yade_java_options% -classpath "%classpath%" com.sos.yade.engine.YADEEngineMain %* %settings_arg% %return_values_arg%
"%java_bin%" %log4j_property% %yade_java_options% -classpath "%classpath%" com.sos.yade.engine.YADEEngineMain %* %settings_arg% %return_values_arg%  

echo.
echo ****************************************************************************************
echo CLIENT END   : %DATE% %TIME%, exit code %ERRORLEVEL%
echo.
ENDLOCAL
exit /b %ERRORLEVEL%


:set_time_zone
set java_bin_short=%~s1
if exist "%YADE_HOME%\lib\classes\DefaultTimeZone.class" (
  for /f "usebackq" %%i in (`%java_bin_short% -classpath "%YADE_LIB_DIR%/classes" DefaultTimeZone 2^>nul`) do set YADE_TZ=%%i
)
if not defined YADE_TZ set YADE_TZ=Etc/UTC
goto final


:normalize_home
set YADE_HOME=%~dp1
set YADE_HOME=%YADE_HOME:~0,-1%
goto final


:log_verbose
if %verbose% GTR 0 (
  echo. >&2
  echo Verbose: %* >&2
  echo. >&2
)
goto final


ENDLOCAL
:final
